// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: ConfigurationFiles.Options.java
package com.oracle.svm.core.configure;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class ConfigurationFiles_Options_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(ConfigurationFiles.Options.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "ConfigurationFileDirectories": {
            return OptionDescriptor.create(
                /*name*/ "ConfigurationFileDirectories",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Directories directly containing configuration files for dynamic features at runtime.",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.ConfigurationFileDirectories,
                /*fieldName*/ "ConfigurationFileDirectories",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConfigurationResourceRoots": {
            return OptionDescriptor.create(
                /*name*/ "ConfigurationResourceRoots",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Resource path above configuration resources for dynamic features at runtime.",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.ConfigurationResourceRoots,
                /*fieldName*/ "ConfigurationResourceRoots",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DynamicProxyConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "DynamicProxyConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ """
One or several (comma-separated) paths to JSON files that specify lists of interfaces that define Java proxy classes.

The JSON structure is described in the following schema:

  https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/proxy-config-schema-v1.0.0.json

An example file contents follows:

    [
      {
        \"condition\" : {
          \"typeReachable\" : \"org.example.CallingClass\"
        },
        \"interfaces\" : [
          \"java.lang.AutoCloseable\",
          \"java.util.Comparator\"
        ]
      },
      {
        \"condition\" : {
          \"typeReachable\" : \"org.example.CallingClass\"
        },
        \"interfaces\" : [
          \"java.util.Comparator\"
        ]
      }
    ]""",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.DynamicProxyConfigurationFiles,
                /*fieldName*/ "DynamicProxyConfigurationFiles",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "DynamicProxyConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "DynamicProxyConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing program elements to be made available for reflection (see ProxyConfigurationFiles).",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.DynamicProxyConfigurationResources,
                /*fieldName*/ "DynamicProxyConfigurationResources",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "This can be caused by a proxy-config.json file in your META-INF directory. Consider including proxy configuration in the reflection section of reachability-metadata.md instead.");
        }
        case "JNIConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "JNIConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Files describing program elements to be made accessible via JNI according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/jni-config-schema-v1.1.0.json",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.JNIConfigurationFiles,
                /*fieldName*/ "JNIConfigurationFiles",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNIConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "JNIConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing program elements to be made accessible via JNI according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/jni-config-schema-v1.1.0.json",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.JNIConfigurationResources,
                /*fieldName*/ "JNIConfigurationResources",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PredefinedClassesConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "PredefinedClassesConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Files describing predefined classes that can be loaded at runtime according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/predefined-classes-config-schema-v1.0.0.json",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.PredefinedClassesConfigurationFiles,
                /*fieldName*/ "PredefinedClassesConfigurationFiles",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PredefinedClassesConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "PredefinedClassesConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing predefined classes that can be loaded at runtime according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/predefined-classes-config-schema-v1.0.0.json",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.PredefinedClassesConfigurationResources,
                /*fieldName*/ "PredefinedClassesConfigurationResources",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReachabilityMetadataResources": {
            return OptionDescriptor.create(
                /*name*/ "ReachabilityMetadataResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing reachability metadata needed for the program https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/reachability-metadata-schema-v1.2.0.json",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.ReachabilityMetadataResources,
                /*fieldName*/ "ReachabilityMetadataResources",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReflectionConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "ReflectionConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ """
One or several (comma-separated) paths to JSON files that specify which program elements should be made available via reflection.

The JSON object schema is described at:

   https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/reflect-config-schema-v1.1.0.json

Example:

	[
	  {
	    \"condition\" : {
          \"typeReachable\" : \"org.example.CallingClass\"
        },
	    \"name\" : \"java.lang.Class\",
	    \"allDeclaredConstructors\" : \"true\",
	    \"allPublicConstructors\" : \"true\",
	    \"allDeclaredMethods\" : \"true\",
	    \"allPublicMethods\" : \"true\"
	  },
	  {
	    \"condition\" : {
          \"typeReachable\" : \"org.example.CallingClass\"
        },
	    \"name\" : \"java.lang.String\",
	    \"fields\" : [
	      { \"name\" : \"value\" },
	      { \"name\" : \"hash\" }
	    ],
	    \"methods\" : [
	      { \"name\" : \"<init>\", \"parameterTypes\" : [] },
	      { \"name\" : \"<init>\", \"parameterTypes\" : [\"char[]\"] },
	      { \"name\" : \"charAt\" },
	      { \"name\" : \"format\", \"parameterTypes\" : [\"java.lang.String\", \"java.lang.Object[]\"] },
	    ]
	  },
      {
        \"condition\" : {
          \"typeReachable\" : \"org.example.CallingClass\"
        },
        \"name\" : \"java.lang.String$CaseInsensitiveComparator\",
        \"methods\" : [
          { \"name\" : \"compare\" }
        ]
      }
	]""",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.ReflectionConfigurationFiles,
                /*fieldName*/ "ReflectionConfigurationFiles",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReflectionConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "ReflectionConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing program elements to be made available for reflection (see ReflectionConfigurationFiles).",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.ReflectionConfigurationResources,
                /*fieldName*/ "ReflectionConfigurationResources",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ResourceConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "ResourceConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Files describing Java resources to be included in the image according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/resource-config-schema-v1.0.0.json",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.ResourceConfigurationFiles,
                /*fieldName*/ "ResourceConfigurationFiles",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ResourceConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "ResourceConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing Java resources to be included in the image according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/resource-config-schema-v1.0.0.json",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.ResourceConfigurationResources,
                /*fieldName*/ "ResourceConfigurationResources",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SerializationConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "SerializationConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ """
One or several (comma-separated) paths to JSON files that specify lists of serialization configurations.

The structure is described in the following schema:

  https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/serialization-config-schema-v1.1.0.json

Example:

    {
      \"serialization\": [
        {
        \"condition\" : {
          \"typeReachable\" : \"app.DataSerializer\"
        },
        \"name\" : \"java.util.ArrayList\"
      }
      ]
    }


In rare cases an application might explicitly make calls to

    ReflectionFactory.newConstructorForSerialization(Class<?> cl, Constructor<?> constructorToCall)

The specified `constructorToCall` differs from the one that would be automatically used during regular serialization of `cl`.
When a class is registered for run-time serialization, all potential custom constructors are automatically registered.
As a result, this use case does not require any additional metadata.""",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.SerializationConfigurationFiles,
                /*fieldName*/ "SerializationConfigurationFiles",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SerializationConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "SerializationConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing program elements to be made available for serialization (see SerializationConfigurationFiles).",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.SerializationConfigurationResources,
                /*fieldName*/ "SerializationConfigurationResources",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SerializationDenyConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "SerializationDenyConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ """
One or several (comma-separated) paths to JSON files that specify lists of serialization configurations.

The structure is described in the following schema:

  https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/serialization-config-schema-v1.1.0.json

Example:

    {
      \"serialization\": [
        {
        \"condition\" : {
          \"typeReachable\" : \"app.DataSerializer\"
        },
        \"name\" : \"java.util.ArrayList\"
      }
      ]
    }


In rare cases an application might explicitly make calls to

    ReflectionFactory.newConstructorForSerialization(Class<?> cl, Constructor<?> constructorToCall)

The specified `constructorToCall` differs from the one that would be automatically used during regular serialization of `cl`.
When a class is registered for run-time serialization, all potential custom constructors are automatically registered.
As a result, this use case does not require any additional metadata.""",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.SerializationDenyConfigurationFiles,
                /*fieldName*/ "SerializationDenyConfigurationFiles",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SerializationDenyConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "SerializationDenyConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing program elements that must not be made available for serialization.",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.SerializationDenyConfigurationResources,
                /*fieldName*/ "SerializationDenyConfigurationResources",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StrictConfiguration": {
            return OptionDescriptor.create(
                /*name*/ "StrictConfiguration",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "When configuration files do not match their schema, abort the image build instead of emitting a warning.",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.StrictConfiguration,
                /*fieldName*/ "StrictConfiguration",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackTypeReachedOnInterfaces": {
            return OptionDescriptor.create(
                /*name*/ "TrackTypeReachedOnInterfaces",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Testing flag: print 'typeReached' conditions that are used on interfaces without default methods at build time.",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.TrackTypeReachedOnInterfaces,
                /*fieldName*/ "TrackTypeReachedOnInterfaces",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackUnsatisfiedTypeReachedConditions": {
            return OptionDescriptor.create(
                /*name*/ "TrackUnsatisfiedTypeReachedConditions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Testing flag: the 'typeReached' condition is always satisfied however it prints the stack trace where it would not be satisfied.",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.TrackUnsatisfiedTypeReachedConditions,
                /*fieldName*/ "TrackUnsatisfiedTypeReachedConditions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TreatAllNameEntriesAsType": {
            return OptionDescriptor.create(
                /*name*/ "TreatAllNameEntriesAsType",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Testing flag: the 'name' is treated as 'type' in reflection configuration.",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.TreatAllNameEntriesAsType,
                /*fieldName*/ "TreatAllNameEntriesAsType",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TreatAllTypeReachableConditionsAsTypeReached": {
            return OptionDescriptor.create(
                /*name*/ "TreatAllTypeReachableConditionsAsTypeReached",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Testing flag: the 'typeReachable' condition is treated as typeReached so the semantics of programs can change.",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.TreatAllTypeReachableConditionsAsTypeReached,
                /*fieldName*/ "TreatAllTypeReachableConditionsAsTypeReached",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TreatAllUserSpaceTypesAsTrackedForTypeReached": {
            return OptionDescriptor.create(
                /*name*/ "TreatAllUserSpaceTypesAsTrackedForTypeReached",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Testing flag: every type is considered as it participates in a typeReachable condition.",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.TreatAllUserSpaceTypesAsTrackedForTypeReached,
                /*fieldName*/ "TreatAllUserSpaceTypesAsTrackedForTypeReached",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "WarnAboutMissingReflectionOrJNIMetadataElements": {
            return OptionDescriptor.create(
                /*name*/ "WarnAboutMissingReflectionOrJNIMetadataElements",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Warn when reflection and JNI configuration files have elements that could not be found on the classpath or modulepath.",
                /*container*/ getContainer(),
                /*option*/ ConfigurationFiles.Options.WarnAboutMissingReflectionOrJNIMetadataElements,
                /*fieldName*/ "WarnAboutMissingReflectionOrJNIMetadataElements",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 24;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("ConfigurationFileDirectories");
                    case 1: return get("ConfigurationResourceRoots");
                    case 2: return get("DynamicProxyConfigurationFiles");
                    case 3: return get("DynamicProxyConfigurationResources");
                    case 4: return get("JNIConfigurationFiles");
                    case 5: return get("JNIConfigurationResources");
                    case 6: return get("PredefinedClassesConfigurationFiles");
                    case 7: return get("PredefinedClassesConfigurationResources");
                    case 8: return get("ReachabilityMetadataResources");
                    case 9: return get("ReflectionConfigurationFiles");
                    case 10: return get("ReflectionConfigurationResources");
                    case 11: return get("ResourceConfigurationFiles");
                    case 12: return get("ResourceConfigurationResources");
                    case 13: return get("SerializationConfigurationFiles");
                    case 14: return get("SerializationConfigurationResources");
                    case 15: return get("SerializationDenyConfigurationFiles");
                    case 16: return get("SerializationDenyConfigurationResources");
                    case 17: return get("StrictConfiguration");
                    case 18: return get("TrackTypeReachedOnInterfaces");
                    case 19: return get("TrackUnsatisfiedTypeReachedConditions");
                    case 20: return get("TreatAllNameEntriesAsType");
                    case 21: return get("TreatAllTypeReachableConditionsAsTypeReached");
                    case 22: return get("TreatAllUserSpaceTypesAsTrackedForTypeReached");
                    case 23: return get("WarnAboutMissingReflectionOrJNIMetadataElements");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
