// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SerialGCOptions.java
package com.oracle.svm.core.genscavenge;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class SerialGCOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(SerialGCOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "CollectYoungGenerationSeparately": {
            return OptionDescriptor.create(
                /*name*/ "CollectYoungGenerationSeparately",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if a full GC collects the young generation separately or together with the old generation. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.CollectYoungGenerationSeparately,
                /*fieldName*/ "CollectYoungGenerationSeparately",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GreyToBlackObjRefDemographics": {
            return OptionDescriptor.create(
                /*name*/ "GreyToBlackObjRefDemographics",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Develop demographics of the object references visited. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.GreyToBlackObjRefDemographics,
                /*fieldName*/ "GreyToBlackObjRefDemographics",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IgnoreMaxHeapSizeWhileInVMInternalCode": {
            return OptionDescriptor.create(
                /*name*/ "IgnoreMaxHeapSizeWhileInVMInternalCode",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Ignore the maximum heap size while in VM-internal code. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.IgnoreMaxHeapSizeWhileInVMInternalCode,
                /*fieldName*/ "IgnoreMaxHeapSizeWhileInVMInternalCode",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ImageHeapCardMarking": {
            return OptionDescriptor.create(
                /*name*/ "ImageHeapCardMarking",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables card marking for image heap objects, which arranges them in chunks. Automatically enabled when supported. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.ImageHeapCardMarking,
                /*fieldName*/ "ImageHeapCardMarking",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InitialCollectionPolicy": {
            return OptionDescriptor.create(
                /*name*/ "InitialCollectionPolicy",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "The garbage collection policy, either Adaptive (default) or BySpaceAndTime. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.InitialCollectionPolicy,
                /*fieldName*/ "InitialCollectionPolicy",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxHeapFree": {
            return OptionDescriptor.create(
                /*name*/ "MaxHeapFree",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The maximum free bytes reserved for allocations, in bytes (0 for automatic according to GC policy). Serial GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.MaxHeapFree,
                /*fieldName*/ "MaxHeapFree",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxSurvivorSpaces": {
            return OptionDescriptor.create(
                /*name*/ "MaxSurvivorSpaces",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of survivor spaces. Serial GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.MaxSurvivorSpaces,
                /*fieldName*/ "MaxSurvivorSpaces",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OutlineWriteBarriers": {
            return OptionDescriptor.create(
                /*name*/ "OutlineWriteBarriers",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines whether to always (if true) or never (if false) outline write barrier code to a separate function, trading reduced image size for (potentially) worse performance. Serial GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.OutlineWriteBarriers,
                /*fieldName*/ "OutlineWriteBarriers",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PercentTimeInIncrementalCollection": {
            return OptionDescriptor.create(
                /*name*/ "PercentTimeInIncrementalCollection",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "Percentage of total collection time that should be spent on young generation collections. Serial and parallel GC with collection policy 'BySpaceAndTime' only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.PercentTimeInIncrementalCollection,
                /*fieldName*/ "PercentTimeInIncrementalCollection",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGCSummary": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCSummary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print summary GC information after application main method returns. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.PrintGCSummary,
                /*fieldName*/ "PrintGCSummary",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGCTimes": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCTimes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the time for each of the phases of each collection, if +VerboseGC. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.PrintGCTimes,
                /*fieldName*/ "PrintGCTimes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SoftRefLRUPolicyMSPerMB": {
            return OptionDescriptor.create(
                /*name*/ "SoftRefLRUPolicyMSPerMB",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "This number of milliseconds multiplied by the free heap memory in MByte is the time span for which a soft reference will keep its referent alive after its last access. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.SoftRefLRUPolicyMSPerMB,
                /*fieldName*/ "SoftRefLRUPolicyMSPerMB",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "TraceHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace heap chunks during collections, if +VerboseGC. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.TraceHeapChunks,
                /*fieldName*/ "TraceHeapChunks",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyAfterGC": {
            return OptionDescriptor.create(
                /*name*/ "VerifyAfterGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the heap after doing a garbage collection if VerifyHeap is enabled. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.VerifyAfterGC,
                /*fieldName*/ "VerifyAfterGC",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyBeforeGC": {
            return OptionDescriptor.create(
                /*name*/ "VerifyBeforeGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the heap before doing a garbage collection if VerifyHeap is enabled. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.VerifyBeforeGC,
                /*fieldName*/ "VerifyBeforeGC",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyDuringGC": {
            return OptionDescriptor.create(
                /*name*/ "VerifyDuringGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the heap during a garbage collection if VerifyHeap is enabled. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.VerifyDuringGC,
                /*fieldName*/ "VerifyDuringGC",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyReferences": {
            return OptionDescriptor.create(
                /*name*/ "VerifyReferences",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify all object references if VerifyHeap is enabled. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.VerifyReferences,
                /*fieldName*/ "VerifyReferences",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyReferencesPointIntoValidChunk": {
            return OptionDescriptor.create(
                /*name*/ "VerifyReferencesPointIntoValidChunk",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify that object references point into valid heap chunks if VerifyHeap is enabled. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.VerifyReferencesPointIntoValidChunk,
                /*fieldName*/ "VerifyReferencesPointIntoValidChunk",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyRememberedSet": {
            return OptionDescriptor.create(
                /*name*/ "VerifyRememberedSet",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the remembered set if VerifyHeap is enabled. Serial and parallel GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.VerifyRememberedSet,
                /*fieldName*/ "VerifyRememberedSet",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyWriteBarriers": {
            return OptionDescriptor.create(
                /*name*/ "VerifyWriteBarriers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify write barriers. Serial GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialGCOptions.VerifyWriteBarriers,
                /*fieldName*/ "VerifyWriteBarriers",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 20;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("CollectYoungGenerationSeparately");
                    case 1: return get("GreyToBlackObjRefDemographics");
                    case 2: return get("IgnoreMaxHeapSizeWhileInVMInternalCode");
                    case 3: return get("ImageHeapCardMarking");
                    case 4: return get("InitialCollectionPolicy");
                    case 5: return get("MaxHeapFree");
                    case 6: return get("MaxSurvivorSpaces");
                    case 7: return get("OutlineWriteBarriers");
                    case 8: return get("PercentTimeInIncrementalCollection");
                    case 9: return get("PrintGCSummary");
                    case 10: return get("PrintGCTimes");
                    case 11: return get("SoftRefLRUPolicyMSPerMB");
                    case 12: return get("TraceHeapChunks");
                    case 13: return get("VerifyAfterGC");
                    case 14: return get("VerifyBeforeGC");
                    case 15: return get("VerifyDuringGC");
                    case 16: return get("VerifyReferences");
                    case 17: return get("VerifyReferencesPointIntoValidChunk");
                    case 18: return get("VerifyRememberedSet");
                    case 19: return get("VerifyWriteBarriers");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
