// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: NativeImageOptions.java
package com.oracle.svm.hosted;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class NativeImageOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(NativeImageOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "AllowFoldMethods": {
            return OptionDescriptor.create(
                /*name*/ "AllowFoldMethods",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allow MethodTypeFlow to see @Fold methods",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.AllowFoldMethods,
                /*fieldName*/ "AllowFoldMethods",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllowIncompleteClasspath": {
            return OptionDescriptor.create(
                /*name*/ "AllowIncompleteClasspath",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.AllowIncompleteClasspath,
                /*fieldName*/ "AllowIncompleteClasspath",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CPUFeatures": {
            return OptionDescriptor.create(
                /*name*/ "CPUFeatures",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Comma separated list of CPU features that will be enabled while building the target executable, irrespective of whether they are supported by the hosted environment. Note that enabling features not present within the target environment may result in application crashes. The specific options available are target platform dependent. See --list-cpu-features for feature list. These features are in addition to -march.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.CPUFeatures,
                /*fieldName*/ "CPUFeatures",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CStandard": {
            return OptionDescriptor.create(
                /*name*/ "CStandard",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "C standard to use in header files. Possible values are 'C89', 'C99', and 'C11'.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.CStandard,
                /*fieldName*/ "CStandard",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DiagnosticsDir": {
            return OptionDescriptor.create(
                /*name*/ "DiagnosticsDir",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Sets the dir where diagnostic information is dumped.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.DiagnosticsDir,
                /*fieldName*/ "DiagnosticsDir",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DiagnosticsMode": {
            return OptionDescriptor.create(
                /*name*/ "DiagnosticsMode",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables the diagnostic mode.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.DiagnosticsMode,
                /*fieldName*/ "DiagnosticsMode",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ErrorFile": {
            return OptionDescriptor.create(
                /*name*/ "ErrorFile",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "If an error occurs, save a build error report to this file [default: svm_err_b_%t_pid%p.md] (%p replaced with pid, %t with timestamp).)",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.ErrorFile,
                /*fieldName*/ "ErrorFile",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ExitAfterAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "ExitAfterAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exit after analysis",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.ExitAfterAnalysis,
                /*fieldName*/ "ExitAfterAnalysis",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ExitAfterRelocatableImageWrite": {
            return OptionDescriptor.create(
                /*name*/ "ExitAfterRelocatableImageWrite",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exit after writing relocatable file",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.ExitAfterRelocatableImageWrite,
                /*fieldName*/ "ExitAfterRelocatableImageWrite",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ListCPUFeatures": {
            return OptionDescriptor.create(
                /*name*/ "ListCPUFeatures",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show CPU features specific to the target platform and exit.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.ListCPUFeatures,
                /*fieldName*/ "ListCPUFeatures",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxReachableTypes": {
            return OptionDescriptor.create(
                /*name*/ "MaxReachableTypes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of types allowed in the image. Used for tests where small number of types is necessary.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.MaxReachableTypes,
                /*fieldName*/ "MaxReachableTypes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MicroArchitecture": {
            return OptionDescriptor.create(
                /*name*/ "MicroArchitecture",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Generate instructions for a specific machine type. Defaults to 'x86-64-v3' on AMD64 and 'armv8.1-a' on AArch64. Use -march=compatibility for best compatibility, or -march=native for best performance if the native executable is deployed on the same machine or on a machine with the same CPU features. To list all available machine types, use -march=list.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.MicroArchitecture,
                /*fieldName*/ "MicroArchitecture",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "NativeArchitecture": {
            return OptionDescriptor.create(
                /*name*/ "NativeArchitecture",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Uses the native architecture, i.e., the architecture of a machine that builds an image.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.NativeArchitecture,
                /*fieldName*/ "NativeArchitecture",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please use '-march=native' instead. See '--help' for details.");
        }
        case "NumberOfAnalysisThreads": {
            return OptionDescriptor.create(
                /*name*/ "NumberOfAnalysisThreads",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Deprecated, option no longer has any effect",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.NumberOfAnalysisThreads,
                /*fieldName*/ "NumberOfAnalysisThreads",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please use '--parallelism' instead.");
        }
        case "NumberOfThreads": {
            return OptionDescriptor.create(
                /*name*/ "NumberOfThreads",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of threads the build process is allowed to use.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.NumberOfThreads,
                /*fieldName*/ "NumberOfThreads",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintAOTCompilation": {
            return OptionDescriptor.create(
                /*name*/ "PrintAOTCompilation",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print logging information during compilation",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.PrintAOTCompilation,
                /*fieldName*/ "PrintAOTCompilation",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintFeatures": {
            return OptionDescriptor.create(
                /*name*/ "PrintFeatures",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print a list of active features",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.PrintFeatures,
                /*fieldName*/ "PrintFeatures",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintHeapHistogram": {
            return OptionDescriptor.create(
                /*name*/ "PrintHeapHistogram",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print class statistics of native image heap",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.PrintHeapHistogram,
                /*fieldName*/ "PrintHeapHistogram",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintImageElementSizes": {
            return OptionDescriptor.create(
                /*name*/ "PrintImageElementSizes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the sizes of the elements of the built image",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.PrintImageElementSizes,
                /*fieldName*/ "PrintImageElementSizes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintImageHeapPartitionSizes": {
            return OptionDescriptor.create(
                /*name*/ "PrintImageHeapPartitionSizes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the sizes of the native image heap as the image is built",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.PrintImageHeapPartitionSizes,
                /*fieldName*/ "PrintImageHeapPartitionSizes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintMethodHistogram": {
            return OptionDescriptor.create(
                /*name*/ "PrintMethodHistogram",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print statistics of methods in native image heap",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.PrintMethodHistogram,
                /*fieldName*/ "PrintMethodHistogram",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintUniverse": {
            return OptionDescriptor.create(
                /*name*/ "PrintUniverse",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print information about classes, methods, and fields that are present in the native image",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.PrintUniverse,
                /*fieldName*/ "PrintUniverse",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReportExceptionStackTraces": {
            return OptionDescriptor.create(
                /*name*/ "ReportExceptionStackTraces",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show exception stack traces for exceptions during image building.)",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.ReportExceptionStackTraces,
                /*fieldName*/ "ReportExceptionStackTraces",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReportUnsafeOffsetWarnings": {
            return OptionDescriptor.create(
                /*name*/ "ReportUnsafeOffsetWarnings",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print unsafe operation offset warnings.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.ReportUnsafeOffsetWarnings,
                /*fieldName*/ "ReportUnsafeOffsetWarnings",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReportUnsupportedElementsAtRuntime": {
            return OptionDescriptor.create(
                /*name*/ "ReportUnsupportedElementsAtRuntime",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report usage of unsupported methods and fields at run time when they are accessed the first time, instead of as an error during image building",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.ReportUnsupportedElementsAtRuntime,
                /*fieldName*/ "ReportUnsupportedElementsAtRuntime",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReturnAfterAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "ReturnAfterAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Return after analysis",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.ReturnAfterAnalysis,
                /*fieldName*/ "ReturnAfterAnalysis",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RuntimeCheckedCPUFeatures": {
            return OptionDescriptor.create(
                /*name*/ "RuntimeCheckedCPUFeatures",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Comma separated list of CPU features that will be enabled for runtime checks. The native image may check at run time if such features are supported by the target CPU, and can optimize certain operations based on this information. If a feature is not supported at run time, a less optimized variant will be executed. Because of the presence of multiple code variants, enabling runtime features can result in larger executables. To completely turn off runtime checked CPU features, set this option to the empty string. The specific options available are target platform dependent. See --list-cpu-features for feature list. The default values are: AMD64: 'AVX,AVX2'; AArch64: ''",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.RuntimeCheckedCPUFeatures,
                /*fieldName*/ "RuntimeCheckedCPUFeatures",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SuppressStderr": {
            return OptionDescriptor.create(
                /*name*/ "SuppressStderr",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Suppress console error output for unittests",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.SuppressStderr,
                /*fieldName*/ "SuppressStderr",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SuppressStdout": {
            return OptionDescriptor.create(
                /*name*/ "SuppressStdout",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Suppress console normal output for unittests",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.SuppressStdout,
                /*fieldName*/ "SuppressStdout",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TempDirectory": {
            return OptionDescriptor.create(
                /*name*/ "TempDirectory",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Directory for temporary files generated during native image generation. If this option is specified, the temporary files are not deleted so that you can inspect them after native image generation",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.TempDirectory,
                /*fieldName*/ "TempDirectory",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ThrowUnsafeOffsetErrors": {
            return OptionDescriptor.create(
                /*name*/ "ThrowUnsafeOffsetErrors",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Throw unsafe operation offset errors.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.ThrowUnsafeOffsetErrors,
                /*fieldName*/ "ThrowUnsafeOffsetErrors",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UnsafeOffsetWarningsAreFatal": {
            return OptionDescriptor.create(
                /*name*/ "UnsafeOffsetWarningsAreFatal",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print unsafe operation offset warnings.",
                /*container*/ getContainer(),
                /*option*/ NativeImageOptions.UnsafeOffsetWarningsAreFatal,
                /*fieldName*/ "UnsafeOffsetWarningsAreFatal",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 32;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AllowFoldMethods");
                    case 1: return get("AllowIncompleteClasspath");
                    case 2: return get("CPUFeatures");
                    case 3: return get("CStandard");
                    case 4: return get("DiagnosticsDir");
                    case 5: return get("DiagnosticsMode");
                    case 6: return get("ErrorFile");
                    case 7: return get("ExitAfterAnalysis");
                    case 8: return get("ExitAfterRelocatableImageWrite");
                    case 9: return get("ListCPUFeatures");
                    case 10: return get("MaxReachableTypes");
                    case 11: return get("MicroArchitecture");
                    case 12: return get("NativeArchitecture");
                    case 13: return get("NumberOfAnalysisThreads");
                    case 14: return get("NumberOfThreads");
                    case 15: return get("PrintAOTCompilation");
                    case 16: return get("PrintFeatures");
                    case 17: return get("PrintHeapHistogram");
                    case 18: return get("PrintImageElementSizes");
                    case 19: return get("PrintImageHeapPartitionSizes");
                    case 20: return get("PrintMethodHistogram");
                    case 21: return get("PrintUniverse");
                    case 22: return get("ReportExceptionStackTraces");
                    case 23: return get("ReportUnsafeOffsetWarnings");
                    case 24: return get("ReportUnsupportedElementsAtRuntime");
                    case 25: return get("ReturnAfterAnalysis");
                    case 26: return get("RuntimeCheckedCPUFeatures");
                    case 27: return get("SuppressStderr");
                    case 28: return get("SuppressStdout");
                    case 29: return get("TempDirectory");
                    case 30: return get("ThrowUnsafeOffsetErrors");
                    case 31: return get("UnsafeOffsetWarningsAreFatal");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
