/*
 * Copyright (c) 2015, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 3 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.truffle.r.nodes.primitive;

import com.oracle.truffle.r.runtime.RInternalError;
import com.oracle.truffle.r.runtime.data.RComplex;
import com.oracle.truffle.r.runtime.data.model.RAbstractVector;
import com.oracle.truffle.r.runtime.nodes.RBaseNode;

@SuppressWarnings("unused")
public abstract class UnaryMapFunctionNode extends RBaseNode {

    public boolean mayFoldConstantTime(Class<?> operandClass) {
        return false;
    }

    public RAbstractVector tryFoldConstantTime(RAbstractVector operand, int operandLength) {
        return null;
    }

    /**
     * Enables all NA checks for the given input vectors.
     */
    public void enable(RAbstractVector operand) {
    }

    public boolean isComplete() {
        return false;
    }

    public byte applyLogical(byte operand) {
        throw RInternalError.shouldNotReachHere();
    }

    public int applyInteger(int operand) {
        throw RInternalError.shouldNotReachHere();
    }

    public double applyDouble(double operand) {
        throw RInternalError.shouldNotReachHere();
    }

    public double applyDouble(RComplex operand) {
        throw RInternalError.shouldNotReachHere();
    }

    public String applyCharacter(String operand) {
        throw RInternalError.shouldNotReachHere();
    }

    public RComplex applyComplex(RComplex operand) {
        throw RInternalError.shouldNotReachHere();
    }
}
