/*
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Copyright (c) 2012-2014, Purdue University
 * Copyright (c) 2013, 2018, Oracle and/or its affiliates
 *
 * All rights reserved.
 */
package com.oracle.truffle.r.test.builtins;

import org.junit.Test;

import com.oracle.truffle.r.test.TestBase;

// Checkstyle: stop line length check
public class TestBuiltin_Mod extends TestBase {

    @Test
    public void testMod1() {
        assertEval("argv <- list(c(0+0i, 0-1.70620776722167e-16i, 0+3.59617031290993e-17i, 3.33066907387547e-16-8.7147236198461e-17i, 3.33066907387547e-16-4.4517026198843e-17i, 5.55111512312578e-16-1.81766397811914e-16i, -2.22044604925031e-16+3.76574595498641e-16i, 3.33066907387547e-16+2.8373545612348e-17i, -6.66133814775094e-16-1.98666621484541e-16i, 1.11022302462516e-15+1.3900988495185e-16i, 0+0i, 1.11022302462516e-16+0i, 0-4.88556439671224e-17i, 1.4432899320127e-15+5.4401706444201e-16i, -6.66133814775094e-16+4.18075097302204e-16i, -1.11022302462516e-15-3.7758383211069e-16i, 1.11022302462516e-16+1.21021749072872e-16i, 5.55111512312578e-16-9.7601012134884e-17i, 0+3.64949907708171e-17i, 2.99760216648792e-15-3.2254749723992e-16i));Mod(argv[[1]]);");
    }

    @Test
    public void testMod2() {
        assertEval("argv <- list(c(1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600, 6227020800, 87178291200, 1307674368000, 20922789888000, 355687428096000, 6402373705728000, 121645100408832000));Mod(argv[[1]]);");
    }

    @Test
    public void testMod3() {
        assertEval("argv <- list(structure(c(-0.00275201701154004+0i, 0.73267342182576+1.53432836384434i, 1.19603180664097+2.58954103250214i, -1.78551995785074+3.6927974843213i, -0.21286727655171-2.24663622584203i, 1.71166744547715-2.14519629896288i, -1.56293209739181+1.57166915011841i, -1.58375104473686+3.6829699402818i, -2.00504145581753-1.3546174582843i, 0.683574008984187+0.815530349018154i, -1.53010401343571-2.36562392372444i, 0.99061039704013+3.53936165201907i, 1.67472443120722-1.95559489480179i, -0.68341618370449-2.47704044044817i, 1.48062655483323-1.57686725056915i, 2.87299425968444+2.35949377337065i, 1.8028932379829+0.54336001329155i, 0.8410445275115-2.79377726088858i, -0.85630340738898+1.95000905938152i, -0.070268282309003-0.407774647142381i, 0.87904100084727+1.42913449570069i, -0.5398835286832-1.49689799587001i, -4.20150499254585-1.17770608296304i, -4.20150499254585+1.17770608296304i, -0.5398835286832+1.49689799587001i, 0.87904100084727-1.42913449570068i, -0.070268282309002+0.407774647142381i, -0.85630340738898-1.95000905938152i, 0.8410445275115+2.79377726088858i, 1.8028932379829-0.54336001329155i, 2.87299425968444-2.35949377337065i, 1.48062655483323+1.57686725056915i, -0.68341618370449+2.47704044044817i, 1.67472443120722+1.95559489480179i, 0.99061039704013-3.53936165201907i, -1.53010401343571+2.36562392372443i, 0.683574008984187-0.815530349018153i, -2.00504145581753+1.3546174582843i, -1.58375104473686-3.6829699402818i, -1.56293209739181-1.57166915011841i, 1.71166744547714+2.14519629896288i, -0.21286727655171+2.24663622584203i, -1.78551995785073-3.6927974843213i, 1.19603180664097-2.58954103250214i, 0.73267342182576-1.53432836384434i), .Dim = c(45L, 1L), '`scaled:center`' = -0.00488570008479763));Mod(argv[[1]]);");
    }

    @Test
    public void testMod4() {
        assertEval("argv <- list(logical(0));Mod(argv[[1]]);");
    }

    @Test
    public void testMod5() {
        assertEval("argv <- list(c(1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600, 6227020800, 87178291200, 1307674368000, 20922789888000, 355687428096000, 6402373705728000, 121645100408832000, 2432902008176640000, 51090942171709440000, 1.12400072777761e+21, 2.5852016738885e+22, 6.20448401733239e+23, 1.5511210043331e+25, 4.03291461126606e+26, 1.08888694504184e+28, 3.04888344611714e+29, 8.8417619937397e+30, 2.65252859812191e+32, 8.22283865417792e+33, 2.63130836933694e+35, 8.68331761881189e+36, 2.95232799039604e+38, 1.03331479663861e+40, 3.71993326789901e+41, 1.37637530912263e+43, 5.23022617466601e+44, 2.03978820811974e+46, 8.15915283247898e+47, 3.34525266131638e+49, 1.40500611775288e+51, 6.04152630633738e+52, 2.65827157478845e+54, 1.1962222086548e+56, 5.50262215981209e+57, 2.58623241511168e+59, 1.24139155925361e+61, 6.08281864034268e+62, 3.04140932017134e+64, 1.55111875328738e+66, 8.06581751709439e+67, 4.27488328406003e+69, 2.30843697339241e+71, 1.26964033536583e+73, 7.10998587804863e+74, 4.05269195048772e+76, 2.35056133128288e+78, 1.3868311854569e+80, 8.32098711274139e+81, 5.07580213877225e+83, 3.14699732603879e+85, 1.98260831540444e+87, 1.26886932185884e+89, 8.24765059208247e+90, 5.44344939077443e+92, 3.64711109181887e+94, 2.48003554243683e+96, 1.71122452428141e+98, 1.19785716699699e+100, 8.50478588567862e+101, 6.12344583768861e+103, 4.47011546151268e+105, 3.30788544151939e+107, 2.48091408113954e+109, 1.88549470166605e+111, 1.45183092028286e+113, 1.13242811782063e+115, 8.94618213078298e+116, 7.15694570462638e+118, 5.79712602074737e+120, 4.75364333701284e+122, 3.94552396972066e+124, 3.31424013456535e+126, 2.81710411438055e+128, 2.42270953836727e+130, 2.10775729837953e+132, 1.85482642257398e+134, 1.65079551609085e+136, 1.48571596448176e+138, 1.3520015276784e+140, 1.24384140546413e+142, 1.15677250708164e+144, 1.08736615665674e+146, 1.03299784882391e+148, 9.9167793487095e+149, 9.61927596824821e+151, 9.42689044888325e+153, 9.33262154439442e+155, 9.33262154439442e+157, 9.42594775983836e+159, 9.61446671503513e+161, 9.90290071648618e+163, 1.02990167451456e+166, 1.08139675824029e+168, 1.14628056373471e+170, 1.22652020319614e+172, 1.32464181945183e+174, 1.44385958320249e+176, 1.58824554152274e+178, 1.76295255109024e+180, 1.97450685722107e+182, 2.23119274865981e+184, 2.54355973347219e+186, 2.92509369349302e+188, 3.3931086844519e+190, 3.96993716080872e+192, 4.68452584975429e+194, 5.57458576120761e+196));Mod(argv[[1]]);");
    }

    @Test
    public void testMod() {
        assertEval("{ round(Mod(1+1i)*10000) }");
        assertEval("{ Mod(as.raw(12)) }");
        assertEval("{ is.integer(Mod(FALSE)) }");
    }
}
