/*
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Copyright (c) 2012-2014, Purdue University
 * Copyright (c) 2013, 2018, Oracle and/or its affiliates
 *
 * All rights reserved.
 */
package com.oracle.truffle.r.test.builtins;

import org.junit.Test;

import com.oracle.truffle.r.test.TestBase;

// Checkstyle: stop line length check
public class TestBuiltin_isatomic extends TestBase {

    @Test
    public void testisatomic1() {
        assertEval("argv <- list(c('01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12'));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic2() {
        assertEval("argv <- list(structure(c(1, 2, 3, 0, 10, NA), .Dim = c(3L, 2L)));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic3() {
        assertEval("argv <- list(structure(list(x = 1:10, yyy = 11:20), .Names = c('x', 'yyy'), row.names = c(NA, -10L), class = 'data.frame'));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic4() {
        assertEval("argv <- list(c(-1.12778377684043, -12820.0784261145, -21650982809.6744, -473300382255715392, -6.08456909882282e+25, -3.04622557026196e+34, -4.60125024792566e+43, -1.76183826972506e+53, -1.5069799345972e+63, -2.61556777274611e+73, -8.54170618068872e+83, -4.9383857330861e+94, -4.80716085942859e+105, -7.55412056676629e+116, -1.84898368353639e+128, -6.83535188151783e+139, -3.71562599613334e+151, -2.90089508183654e+163, -3.18582547396557e+175, -4.83110332887119e+187, -9.94902790498679e+199, -2.74100158340596e+212, -9.96611412047338e+224, -4.72336572671053e+237, -2.88514442494869e+250, -2.24780296109123e+263, -2.21240023126594e+276, -2.72671165723473e+289, -4.17369555651928e+302, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic5() {
        assertEval("argv <- list(c(2.5, 6, 6, 7.5, 8, 8, 16, 6, 5, 6, 28, 5, 9.5, 6, 4.5, 10, 14, 3, 4.5, 5.5, 3, 3.5, 6, 2, 3, 4, 6, 5, 6.5, 5, 10, 6, 18, 4.5, 20));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic6() {
        assertEval("argv <- list(structure(c(1, 2, 2, 3, 3, 3, 4, 5), .Names = c('dsyMatrix', 'ddenseMatrix', 'symmetricMatrix', 'dMatrix', 'denseMatrix', 'compMatrix', 'Matrix', 'mMatrix')));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic7() {
        assertEval("argv <- list(c(-Inf, -Inf, -Inf, -Inf, 0, 1, 2, 3, Inf, Inf, Inf));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic8() {
        assertEval("argv <- list(structure(c(4.17, 5.58, 5.18, 6.11, 4.5, 4.61, 5.17, 4.53, 5.33, 5.14, 4.81, 4.17, 4.41, 3.59, 5.87, 3.83, 6.03, 4.89, 4.32, 4.69, 17.3889, 31.1364, 26.8324, 37.3321, 20.25, 21.2521, 26.7289, 20.5209, 28.4089, 26.4196, 23.1361, 17.3889, 19.4481, 12.8881, 34.4569, 14.6689, 36.3609, 23.9121, 18.6624, 21.9961), .Dim = c(20L, 2L), .Dimnames = list(NULL, c('w', 'w2'))));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic9() {
        assertEval("argv <- list(structure(c(TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE), .Names = c('1', '2', '3', '4', '5', '6', '7', '8')));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic10() {
        assertEval("argv <- list(structure(c(123.263157894737, 88.6052631578949, 77.0526315789476, 60.9473684210528, 54.3947368421055, 43.8421052631581, 34.2894736842107, 14.7368421052633, 10.6315789473686, 1.07894736842124, -9.47368421052613, -11.0263157894735, -16.1315789473682, -13.6842105263156, -3.23684210526298, -1.34210526315772, 11.1052631578949, -0.44736842105246, 7.00000000000017, 7.4473684210528, 6.89473684210543, 5.34210526315806, -8.21052631578931, -15.7631578947367, -3.31578947368405, 24.5789473684212, 27.0263157894738, 26.4736842105265, 21.9210526315791, 23.3684210526317, 27.263157894737, 19.6052631578949, 21.0526315789475, 26.5000000000001, 22.9473684210528, 12.3947368421054, 1.84210526315803, 5.28947368421066, -1.81578947368408, 4.63157894736855, 24.5263157894738, 10.9736842105264, 4.42105263157907, -10.1315789473683, -10.6842105263157, 12.763157894737, 33.2105263157896, 35.1052631578949, 44.5526315789475, 41.0000000000001, 46.4473684210527, 59.8947368421054, 69.342105263158, 64.7894736842106, 48.6842105263159, 63.1315789473685, 54.0263157894738, 46.4736842105264, 41.921052631579, 35.3684210526317, 27.8157894736843, 32.2631578947369, 36.7105263157896, 32.1578947368422, 23.6052631578948, 14.0526315789475, 12.5000000000001, -5.05263157894728, 9.84210526315798, 7.28947368421061, 16.7368421052632, 13.1842105263159, 13.6315789473685, 7.07894736842113, 9.52631578947376, 6.42105263157902, 4.31578947368428, -7.23684210526309, -15.7894736842105, 0.657894736842167, -5.8947368421052, 0.552631578947427, 7.44736842105269, -10.1052631578947, -3.65789473684205, 0.789473684210577, 7.23684210526321, 16.6842105263158, 7.13157894736847, -4.4210526315789, -5.97368421052627, -11.5263157894736, -4.07894736842101, -16.6315789473684, -14.1842105263158, -19.7368421052631, -11.2894736842105, -5.84210526315786, -13.3947368421052, -14.9473684210526, -15.5, -21.0526315789473, -6.60526315789471, -14.1578947368421, -8.71052631578945, -6.26315789473682, -11.8157894736842, -19.3684210526316, -6.92105263157893, -18.4736842105263, -19.0263157894737, -15.578947368421, -16.1315789473684, -12.6842105263158, 5.76315789473685, 3.21052631578948, 2.65789473684211, 5.10526315789474, 11.5526315789474), .Names = c('11', '12', '13', '15', '26', '30', '31', '53', '54', '59', '60', '65', '71', '81', '88', '92', '93', '95', '105', '107', '110', '116', '118', '131', '132', '135', '142', '144', '147', '156', '163', '166', '170', '174', '175', '176', '177', '179', '180', '181', '183', '185', '188', '189', '191', '196', '197', '202', '207', '210', '212', '218', '221', '222', '223', '225', '229', '230', '237', '239', '246', '259', '267', '269', '270', '279', '283', '284', '285', '286', '288', '291', '292', '300', '301', '303', '306', '310', '320', '329', '337', '353', '363', '364', '371', '387', '390', '394', '404', '413', '428', '429', '442', '444', '455', '457', '458', '460', '477', '519', '524', '533', '558', '567', '574', '583', '613', '624', '643', '655', '689', '707', '791', '806', '814', '840', '883', '1010', '1022')));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic11() {
        assertEval("argv <- list(structure(c(0, -0.0555555555555556, 0.02, 0.0625, 0.0625, 0.04, 0, 0), .Dim = c(8L, 1L), .Dimnames = list(c('2', '3', '6', '7', '8', '9', '14', '17'), 'x')));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic12() {
        assertEval("argv <- list(structure(c(2.21843970753346, 1.80732678656753, -1.09399175987006, 0.585986462327552, -5.68458926982395, 1.23352238598674, 0.457950438444482, 2.51599006679516, -2.28780372840319, 5.53596062467695, 2.17890565095959, -1.59611751350773, -2.9672978602151, 0.745175851232308, 1.93388282434376, -3.03559459078455, 2.19500990255906, 0.0725275773318347, -0.75336064096447, -1.15505962102859, -2.84782886882524, -1.41070341448251, -0.540252474026749, 4.87719739781058, 0.890715639552621, -0.968642103099399, 1.73177156113283, -0.993218102309356, -0.656454198323984, -1.5299506933835, -0.298424468882268, 6.51011264717937, 2.68326774833378, 1.99295445531679, -0.214079422583434, 6.73505308264589, -4.54579214489424, -2.3991834444486, -1.71479569181251, -6.47293095421849, -1.67116930820449, -11.5853328029437, -2.48588878138021, -0.888857646918452, 8.06807102468956, -0.216046323028316, 6.24682938323398, -1.74761908105831, 2.53082303181417, 2.31410662801887, 2.97453294161523, -2.88723068649699, -1.04144266580674, -0.835536300630093, -6.10229135345437, -4.37605802846523, -1.94289029309402e-16, 5.96619037131792, -1.1474434665393, 3.78819830631063, -3.01580771910632, -0.656454198323984, 1.50824785799851, -2.06401783962239, -3.02346226775125, 0.407243897855763, -3.96478352340807, -2.12718621336067, -0.78924288871239, -3.03559459078455, 0.457950438444496, -0.797900839851943, -3.38233849466459, 1.97815029009903, 0.745175851232309, -1.09645503136389, 0.341748714147263, 7.32472922782987, -1.33672649241008, 1.51931399477032, 0.00590129163826772, -4.09533092706814, 0.195481697042187, -2.7736762657602, -3.48737543915568, 0.536312040203338, 0.775871729180551, 4.37979177946206, 1.30271070089245, 4.2132287611068, 7.33457656622414, 3.28311350719274, -1.30271070089245), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '40', '41', '42', '43', '44', '45', '46', '47', '48', '49', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '60', '61', '62', '63', '64', '65', '66', '67', '68', '69', '70', '71', '72', '73', '74', '75', '76', '77', '78', '79', '80', '81', '82', '83', '84', '85', '86', '87', '88', '89', '90', '91', '92', '93')));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic13() {
        assertEval("argv <- list(c(1, 0, 2, NA, 3));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic14() {
        assertEval("argv <- list(c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.00566013786017473, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.00900237050730269, -0.728901016108085, 1, 0, 0, 0, 0, 0, 0, 0, 0, -0.0165439610603712, 0.195986923200517, -0.65974257839475, 1, 0, 0, 0, 0, 0, 0, 0, -0.066085607580362, -0.0156976524162818, 0.173905017001082, -0.499536921684336, 1, 0, 0, 0, 0, 0, 0, -0.0738085645370442, -0.0203225592950423, -0.115986092442635, 0.0129919901272555, -0.442920654638837, 1, 0, 0, 0, 0, 0, 0.0393894522336503, -0.0197375262983596, -0.124011676515792, -0.217221939591068, -0.129869023991585, -0.565387274218169, 1, 0, 0, 0, 0, 0.0607863121945582, -0.0166644168652946, -0.107337280394758, -0.197961946387821, -0.278643450192551, -0.207586147284064, -0.767412521925717, 1, 0, 0, 0, 0.062350529551034, -0.00752786862124525, -0.0512212310455943, -0.0966787787982999, -0.13451920005707, -0.183723918913255, -0.15174930099133, -1.08016400642495, 1, 0, 0, 0.00956599068508591, -0.00134207672049057, -0.00895378984363029, -0.0175914048294707, -0.0252596683886793, -0.0334470581271047, -0.0623904491074943, 0.117178336161866, -1.32461347964996, 1, 0, -0.000288769768734922, -7.2526747819756e-05, -0.000396728614559744, -0.000760325293277726, -0.00119170347009929, -0.00158048211775626, -0.00256503558312322, -0.00605270851626604, 0.3995724375217, -0.740914424130097, 1));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic15() {
        assertEval("argv <- list(structure(list(age = 62.4473684210526, age.strata.sex.sex.2 = 24.109649122807), .Names = c('age', 'age.strata.sex.sex.2'), row.names = c(NA, -1L), class = 'data.frame'));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic16() {
        assertEval("argv <- list(structure(list(base = c(11L, 11L, 6L, 8L, 66L, 27L, 12L, 52L, 23L, 10L, 52L, 33L, 18L, 42L, 87L, 50L, 18L, 111L, 18L, 20L, 12L, 9L, 17L, 28L, 55L, 9L, 10L, 47L, 76L, 38L, 19L, 10L, 19L, 24L, 31L, 14L, 11L, 67L, 41L, 7L, 22L, 13L, 46L, 36L, 38L, 7L, 36L, 11L, 151L, 22L, 41L, 32L, 56L, 24L, 16L, 22L, 25L, 13L, 12L)), .Names = 'base', class = 'data.frame', row.names = c(1L, 5L, 9L, 13L, 17L, 21L, 25L, 29L, 33L, 37L, 41L, 45L, 49L, 53L, 57L, 61L, 65L, 69L, 73L, 77L, 81L, 85L, 89L, 93L, 97L, 101L, 105L, 109L, 113L, 117L, 121L, 125L, 129L, 133L, 137L, 141L, 145L, 149L, 153L, 157L, 161L, 165L, 169L, 173L, 177L, 181L, 185L, 189L, 193L, 197L, 201L, 205L, 209L, 213L, 217L, 221L, 225L, 229L, 233L)));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic17() {
        assertEval("argv <- list(c(0, 0, 0, 0, 0, 0, 2.47032822920623e-323, 0, 0, 0, 0, 0));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic18() {
        assertEval("argv <- list(structure(c(1+2i, 5+0i, 3-4i, -6+0i), .Dim = c(2L, 2L)));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic19() {
        assertEval("argv <- list(c(NA, 'Ripley', 'Venables & Smith'));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic20() {
        assertEval("argv <- list(structure(3.14159265358979, class = structure('3.14159265358979', class = 'testit')));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic21() {
        assertEval("argv <- list(structure(FALSE, .Tsp = c(1, 1, 1), class = 'ts'));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic22() {
        assertEval("argv <- list(structure(numeric(0), .Dim = c(4L, 0L)));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic23() {
        assertEval("argv <- list(structure(1:3, .Label = c('4', '5', '6'), class = 'factor'));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic24() {
        assertEval("argv <- list(structure(c(1L, 1L, 1L, 2L, 2L, 2L, 3L, 3L, 3L, 4L, 4L, 4L), .Label = c('freckle', 'superficial', 'nodular', 'indeterminate'), class = 'factor', contrasts = 'contr.treatment'));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic25() {
        assertEval("argv <- list(raw(0));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic26() {
        assertEval("argv <- list(c(19.7787405591752, 12504507.4953993, 12504507.4953993, 5.96190157728191e+41));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic27() {
        assertEval("argv <- list(character(0));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic28() {
        assertEval("argv <- list(structure(list(a1 = 1:3, a2 = 4:6, a3 = 3.14159265358979, a4 = c('a', 'b', 'c')), .Names = c('a1', 'a2', 'a3', 'a4')));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic29() {
        assertEval("argv <- list(structure(c(2L, 1L, 3L), .Label = c('1', '2', NA), class = 'factor'));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic30() {
        assertEval("argv <- list(c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic31() {
        assertEval("argv <- list(c(2L, 1L, NA));is.atomic(argv[[1]]);");
    }

    @Test
    public void testisatomic32() {
        assertEval("argv <- list(structure(1:20, .Tsp = c(1, 20, 1), class = 'ts'));is.atomic(argv[[1]]);");
    }

    @Test
    public void testIsAtomic() {
        assertEval("{ is.atomic(1) }");
        assertEval("{ is.atomic(1L) }");
        assertEval("{ is.atomic(1:3) }");
        assertEval("{ is.atomic(c(1,2,3)) }");
        assertEval("{ is.atomic(NA) }");
        assertEval("{ is.atomic(NULL) }");
        assertEval("{ is.atomic(TRUE) }");
        assertEval("{ !is.atomic(list()) }");
        assertEval("{ !is.atomic(function() {}) }");
    }
}
