/*
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Copyright (c) 2012-2014, Purdue University
 * Copyright (c) 2013, 2018, Oracle and/or its affiliates
 *
 * All rights reserved.
 */
package com.oracle.truffle.r.test.builtins;

import org.junit.Test;

import com.oracle.truffle.r.test.TestBase;

// Checkstyle: stop line length check
public class TestBuiltin_isfinite extends TestBase {

    @Test
    public void testisfinite1() {
        assertEval("argv <- list(c(20.1635649375266, 0.00464806897188935, 7.66871331765456, 12.5627629785965, 11.5797681339384, 12.9719582729673, 25.2769526097163, -1.81739378653632, 0.81215865601413, -3.83170645669318, -0.246853801421158, 3.46135095276697, 2.4554639832607, -3.21187324485145, -3.0183971859156));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite2() {
        assertEval("argv <- list(c(NA, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite3() {
        assertEval("argv <- list(structure(485.051413351662, .Names = 'value'));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite4() {
        assertEval("argv <- list(151.670620533678);is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite5() {
        assertEval("argv <- list(c(NA, 5, 9, 1, 2, 5, 6, 7, 8, 3, 8));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite6() {
        assertEval("argv <- list(structure(1.27861470300044, .Dim = c(1L, 1L), .Dimnames = list('(Intercept)', '(Intercept)')));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite7() {
        assertEval("argv <- list(c(3.16233404821525, 0.257188565034331, -0.453229834209339, 0.242190153165057, -0.923637244637281, -0.792686406797337, -0.000583432444331871, -0.115409318984254, 0.305847927531439, 0.0246693430266492, 0.461347310132161, -0.236100949717949, 0.28892702011061, -0.134702428025256, -0.00354133265015019, -0.239319416508562, -0.657338306370259, 0.617201588652923, 0.864066808989359, 0.903680787204032, 0.524476724719486, 1.12851069606821, -0.0690532444696005, 0.111965689984579, -0.494558736384601, -0.26678456955063, -0.953423764504691, 0.0388401464034938, -0.280977489674148, -0.0317343673308523, 0.332270617799988, -0.0953997363217814));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite8() {
        assertEval("argv <- list(c(96L, 78L, 73L, 91L, 47L, 32L, 20L, 23L, 21L, 24L, 44L, 21L, 28L, 9L, 13L, 46L, 18L, 13L, 24L, 16L, 13L, 23L, 36L, 7L, 14L, 30L, NA, 14L, 18L, 20L));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite9() {
        assertEval("argv <- list(structure(c(0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.0220588235294118, 0.00735294117647059, 0.0147058823529412, 0.0110294117647059, 0.0257352941176471, 0.00735294117647059, 0.0294117647058824, 0.0147058823529412, 0.00735294117647059, 0.00735294117647059, 0.00367647058823529, 0.0110294117647059, 0.0110294117647059, 0.0147058823529412, 0.0110294117647059, 0.00735294117647059, 0.00367647058823529, 0.00735294117647059, 0.0110294117647059, 0.00367647058823529, 0.00367647058823529, 0.00735294117647059, 0.00367647058823529, 0.0110294117647059, 0.00367647058823529, 0.00735294117647059, 0.00735294117647059, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00735294117647059, 0.00735294117647059, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00735294117647059, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00735294117647059, 0.00735294117647059, 0.0147058823529412, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00735294117647059, 0.00367647058823529, 0.0183823529411765, 0.00735294117647059, 0.00367647058823529, 0.0110294117647059, 0.00735294117647059, 0.00367647058823529, 0.00367647058823529, 0.0220588235294118, 0.00735294117647059, 0.00367647058823529, 0.00735294117647059, 0.0183823529411765, 0.00735294117647059, 0.00735294117647059, 0.00735294117647059, 0.0147058823529412, 0.0147058823529412, 0.00367647058823529, 0.00367647058823529, 0.0110294117647059, 0.0147058823529412, 0.00735294117647059, 0.00735294117647059, 0.00735294117647059, 0.00367647058823529, 0.0183823529411765, 0.0147058823529412, 0.00367647058823529, 0.0110294117647059, 0.00367647058823529, 0.00367647058823529, 0.0147058823529412, 0.00735294117647059, 0.0110294117647059, 0.00735294117647059, 0.00367647058823529, 0.0294117647058824, 0.00367647058823529, 0.0183823529411765, 0.00367647058823529, 0.0110294117647059, 0.0147058823529412, 0.0147058823529412, 0.00367647058823529, 0.0110294117647059, 0.00367647058823529, 0.00735294117647059, 0.0220588235294118, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.0220588235294118, 0.00735294117647059, 0.00735294117647059, 0.00367647058823529, 0.00367647058823529, 0.00735294117647059, 0.0110294117647059, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529, 0.00367647058823529), class = 'table', .Dim = 126L, .Dimnames = structure(list(fe = c('1.6', '1.667', '1.7', '1.733', '1.75', '1.783', '1.8', '1.817', '1.833', '1.85', '1.867', '1.883', '1.917', '1.933', '1.95', '1.967', '1.983', '2', '2.017', '2.033', '2.067', '2.083', '2.1', '2.133', '2.15', '2.167', '2.183', '2.2', '2.217', '2.233', '2.25', '2.267', '2.283', '2.3', '2.317', '2.333', '2.35', '2.367', '2.383', '2.4', '2.417', '2.483', '2.617', '2.633', '2.8', '2.883', '2.9', '3.067', '3.317', '3.333', '3.367', '3.417', '3.45', '3.5', '3.567', '3.6', '3.683', '3.717', '3.733', '3.75', '3.767', '3.817', '3.833', '3.85', '3.883', '3.917', '3.95', '3.966', '3.967', '4', '4.033', '4.05', '4.067', '4.083', '4.1', '4.117', '4.133', '4.15', '4.167', '4.183', '4.2', '4.233', '4.25', '4.267', '4.283', '4.3', '4.317', '4.333', '4.35', '4.366', '4.367', '4.383', '4.4', '4.417', '4.433', '4.45', '4.467', '4.483', '4.5', '4.517', '4.533', '4.55', '4.567', '4.583', '4.6', '4.617', '4.633', '4.65', '4.667', '4.7', '4.716', '4.733', '4.75', '4.767', '4.783', '4.8', '4.817', '4.833', '4.85', '4.883', '4.9', '4.933', '5', '5.033', '5.067', '5.1')), .Names = 'fe')));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite10() {
        assertEval("argv <- list(structure(c(-32.6915744137254, -24.6945405669482, -24.6945405669482, -357.79068676373), .Dim = c(2L, 2L)));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite11() {
        assertEval("argv <- list(3.18309886183776e-301);is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite12() {
        assertEval("argv <- list(c(0.0599, 0.00599, 0.000599, 5.99e-05, 5.99e-06, 5.99e-07));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite13() {
        assertEval("argv <- list(structure(c(-0.560475646552213+0i, 0.7424437487+0.205661411508856i, 1.39139505579429-0.26763356813179i, 0.928710764113827-0.221714979045717i, -0.46926798541295+1.18846175213664i, 0.7424437487-0.205661411508856i, 0.460916205989202+0i, -0.452623703774585+0.170604003753717i, -0.094501186832143+0.54302538277632i, -0.331818442379127+0.612232958468282i, 1.39139505579429+0.26763356813179i, -0.452623703774585-0.170604003753717i, 0.400771450594052+0i, -0.927967220342259+0.479716843914174i, -0.790922791530657+0.043092176305418i, 0.928710764113827+0.221714979045717i, -0.094501186832143-0.54302538277632i, -0.927967220342259-0.479716843914174i, 0.701355901563686+0i, -0.600841318509537+0.213998439984336i, -0.46926798541295-1.18846175213664i, -0.331818442379127-0.612232958468282i, -0.790922791530657-0.043092176305418i, -0.600841318509537-0.213998439984336i, -0.625039267849257+0i), .Dim = c(5L, 5L)));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite14() {
        assertEval("argv <- list(structure(2L, .Label = c('Northeast', 'South', 'North Central', 'West'), class = 'factor'));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite15() {
        assertEval("argv <- list(c(0.0099, 0.099, 0.99, 9.9, 99, 990, 9900, 99000, 990000, 9900000, 9.9e+07, 9.9e+08, 9.9e+09, 9.9e+10));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite16() {
        assertEval("argv <- list(structure(numeric(0), .Dim = c(0L, 0L)));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite17() {
        assertEval("argv <- list(NULL);is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite18() {
        assertEval("argv <- list(structure(1, .Tsp = c(1, 1, 1), class = 'ts'));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite19() {
        assertEval("argv <- list(structure(c(100, -1e-13, Inf, -Inf, NaN, 3.14159265358979, NA), .Names = c(' 100', '-1e-13', ' Inf', '-Inf', ' NaN', '3.14', '  NA')));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite20() {
        assertEval("argv <- list(structure(c(100L, 0L, NA, NA, NA, 3L, NA), .Names = c(' 100', '-1e-13', ' Inf', '-Inf', ' NaN', '3.14', '  NA')));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite21() {
        assertEval("argv <- list(c(1.86606598307361, 339033474310168, 6.15968019059533e+28, 1.11911250438065e+43, 2.03324321833028e+57, 3.69406826275609e+71, 6.71151400229846e+85, 1.21937162496937e+100, 2.2153975381282e+114, 4.02501267984465e+128, 7.31278553581751e+142, 1.32861276588395e+157, 2.41387071044804e+171, 4.38560576593759e+185, 7.96792382084694e+199, 1.44764060891943e+214, 2.63012470966353e+228, 4.77850368783602e+242, 8.6817546752692e+256, 1.57733192575377e+271));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite22() {
        assertEval("argv <- list(structure(1:7, .Dim = c(1L, 7L)));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite23() {
        assertEval("argv <- list(structure(c(-4, 0, 0, 0, 0, 0, 0, -406.725, 41.7955066364795, 0, 0, 0, 0, 0, -1550.79375, 381.717151319926, 49.8228991342168, 0, 0, 0, 0, -1277.325, 224.617432123818, -31.1858918860748, -282.060212912726, 0, 0, 0, -1042.675, 125.261805546114, -29.9849484767744, 164.425554254677, -170.353263600129, 0, 0, -469.696, 26.3795103523805, 4.19691803785862, -3.18974110831568, 0.0462484557378925, 1.46320172717486, 0, -7818, 18.2758880432689, 1.77525956575195, -1.45298766739792, -0.449176219307484, -0.281900648530911, -0.669305080560524), .Dim = c(7L, 7L), .Dimnames = list(c('1947', '1948', '1949', '1950', '1951', '1952', '1953'), c('(Intercept)', 'GNP.deflator', 'GNP', 'Unemployed', 'Armed.Forces', 'Population', 'Year'))));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite24() {
        assertEval("argv <- list(c(13L, 13L));is.finite(argv[[1]]);");
    }

    @Test
    public void testisfinite25() {
        assertEval("argv <- list(structure(c(13991, 13995), class = 'Date'));is.finite(argv[[1]]);");
    }

    @Test
    public void testIsFinite() {
        assertEval("{ is.finite(1:100) }");
        assertEval("{ is.finite(1:1) }");
        assertEval("{ is.finite(c(1,2,3)) }");
        assertEval("{ is.finite(c(1,2,Inf)) }");
        assertEval("{ is.finite(c(1,2,-Inf)) }");
        assertEval("{ is.finite(c(Inf,2,-Inf)) }");
        assertEval("{ is.finite(c(Inf,NA,-Inf)) }");
        assertEval("{ is.finite(1) }");
        assertEval("{ is.finite(c(1L,2L,3L)) }");
        assertEval("{ is.finite(c(1L,2L,NA)) }");
        assertEval("{ is.finite(1L) }");
        assertEval("{ is.finite(as.raw(c(1L,2L,3L))) }");
        assertEval("{ is.finite(c(TRUE, FALSE)) }");
        assertEval("{ is.finite(c(TRUE, FALSE, NA)) }");
    }
}
