/*
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Copyright (c) 2012-2014, Purdue University
 * Copyright (c) 2013, 2021, Oracle and/or its affiliates
 *
 * All rights reserved.
 */
package com.oracle.truffle.r.test.builtins;

import org.junit.Test;

import com.oracle.truffle.r.test.TestBase;

// Checkstyle: stop line length check
public class TestBuiltin_operators extends TestBase {

    @Test
    public void testoperators1() {
        assertEval("argv <- list(structure(numeric(0), .Dim = c(0L, 0L)));`!`(argv[[1]]);");
    }

    @Test
    public void testoperators2() {
        assertEval("argv <- list(c(NA, '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1'), c('1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', NA));`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators3() {
        assertEval("argv <- list(2.2250738585072e-308, c(0.0009765625, 0.001953125, 0.00390625, 0.0078125, 0.015625, 0.03125, 0.0625, 0.125, 0.25, 0.5, 1, 2, 4, 8, 1e+05, 1e+10));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators4() {
        assertEval(Output.IgnoreWarningContext,
                        "argv <- list(structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = 'data.frame'), structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = 'data.frame'));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators5() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'));`*`(argv[[1]]);");
    }

    @Test
    public void testoperators6() {
        assertEval("argv <- list(structure(5.34872109992236, .Names = 'x'), structure(-17494.4659893938, .Names = 'x'));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators7() {
        assertEval("argv <- list(structure(c(1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0.5, 0.5, 1, 1, 0, 0, 0, 0, 0, 1), .Dim = c(6L, 4L)), c(1, 1, 1, 0, 0, 0));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators8() {
        assertEval("argv <- list(0.5, c(0.0945457474962427, 0.369817831189094, 0.485958087431202, 0.498816870239398, 0.499902671395055));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators9() {
        assertEval("argv <- list(structure(1:10, class = structure('NumericNotStructure', package = '.GlobalEnv')), 1);`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators10() {
        assertEval("argv <- list(1, 0+1i);`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators11() {
        assertEval("argv <- list(structure(68.6851383798793, .Names = ''), structure(35.9756377289347, .Names = 'Var1'));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators12() {
        assertEval("argv <- list(structure(0.070387338608913, .Names = 'Var1'), structure(0.00374843815077052, .Names = 'Var2'));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators13() {
        assertEval("argv <- list(c(1, 1, 10, 1, 1, 10, 10), 0);`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators14() {
        assertEval("argv <- list(c(23.454000046244, 23.454000046244, 23.454000046244, 23.454000046244, 28.3020224298599, 28.3020224298599, 28.3020224298599, 28.3020224298599, 30.800519631939, 30.800519631939, 30.800519631939, 30.800519631939, 25.9206422064884, 25.9206422064884, 25.9206422064884, 23.2002066882042, 23.2002066882042, 23.2002066882042, 20.1196890721666, 20.1196890721666, 20.1196890721666, 33.5952341720171, 33.5952341720171, 39.0519830824759, 39.0519830824759, 32.136512000254, 32.136512000254, 40.0046131871928, 40.0046131871928, 36.1899385542654, 36.1899385542654, 36.1899385542654, 36.9107066354437, 36.9107066354437, 30.6345192978006, 30.6345192978006, 34.3113600002908, 34.3113600002908, 38.3947952390571, 38.3947952390571, 31.2256309266188, 31.2256309266188, 31.2256309266188, 31.2256309266188, 31.2302025081837, 31.2302025081837, 31.2302025081837, 31.2302025081837, 19.9976293105352, 19.9976293105352, 19.9976293105352, 37.0952034528547, 37.0952034528547, 37.0952034528547, 32.5940180631865, 32.5940180631865, 32.5940180631865, 30.3755575381127, 30.3755575381127, 30.3755575381127), c(-7.78372381938215, -2.21918545910218, -0.632702831725275, -0.180387300047981, -7.49017129741483, -2.13549190787282, -0.608841307830204, -0.173584239188075, -22.5802449738518, -16.4998575320751, -8.81014962829596, -2.51182549655016, -23.557038894075, -17.2136212906412, -9.19126598036131, -21.8778835738372, -15.9866273589884, -8.53610880037608, -15.0686941140291, -11.0110101269414, -5.87936269076593, -5.59523381317633, -1.59523408160483, -33.4519828181102, -13.051983020203, -16.7365117167447, -8.93651185736664, -28.2046129643012, -11.0046131346857, -24.7866580698756, -18.1121297542524, -9.67102733534973, -10.9107059357263, -3.11070645913868, -6.43451888517834, -1.83451919385285, -19.311359673177, -10.3113598354284, -17.5947943688525, -9.39479451670115, -13.4592527410221, -3.83731214857368, -1.09404027169438, -0.311917318619494, -9.6582725100978, -2.75363032037238, -0.7850762062622, -0.223829845669225, -4.53229442651767, -1.2921838083017, -0.368409206751382, -8.25942763485825, -2.35481141586021, -0.671370589998607, -10.5255747423345, -3.00090328985181, -0.855575184775718, -7.55762449149225, -2.15472321038819, -0.614324265331269));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators15() {
        assertEval("argv <- list(structure(c(1976, 1976.08333333333, 1976.16666666667, 1976.25, 1976.33333333333, 1976.41666666667, 1976.5, 1976.58333333333, 1976.66666666667, 1976.75, 1976.83333333333, 1976.91666666667, 1977, 1977.08333333333, 1977.16666666667, 1977.25, 1977.33333333333, 1977.41666666667, 1977.5, 1977.58333333333, 1977.66666666667, 1977.75, 1977.83333333333, 1977.91666666667, 1978), .Tsp = c(1976, 1978, 12), class = 'ts'), 0.001);`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators16() {
        assertEval("argv <- list(1.678932e-305, 0+0i);`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators17() {
        assertEval("argv <- list(4.40646552950873, structure(c(2.62980519617636, 3.871217247387, 4.50132920500077, 4.98499803067693, 5.10709299286893, 5.03983500591087, 4.63030887318817, 5.53509956067429, 5.33332559980012, 5.70084841033141, 4.71574513022187, 4.22037009914704, 3.98171648049174, 4.03049403236714, 4.12846177743637, 4.47709151156657, 5.3332151234887, 5.63317778205492, 5.92697054095118, 6.19581080008781, 6.04311655609605, 6.94831988490059, 6.18986185304067, 5.62147157665625, 4.74634441202163, 4.26914765102244, 5.32109627677161, 6.60533693281051, 5.67035960484307, 5.44401652160046, 3.65126501643718, 3.93293892861635, 3.04580339357603, 3.07640267537579, 2.77049106976243, 2.76443164640389, 3.33918351115387, 4.07927158424254, 4.04908494376122, 4.33034621462195, 3.99989475056739, 4.25702880430535), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '40', '41', '42')));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators18() {
        assertEval("argv <- list(100.35609040323, c(16.9869197055322, 32.9569269674228, 63.9409059420178, 124.054025326065, 240.681625836759, 466.954980809107, 905.955962962971, 1757.67737910411, 3410.13238536472, 6616.11910351861, 12836.1679387595, 24903.9058659644, 48316.9533415093, 93741.4393055559, 181871.099797343, 352854.587965931, 684585.733452663, 1328189.12501195, 2576866.95120412, 4999471.20418434, 9699651.86203691, 18818639.4925072, 36510711.6612103, 70835729.9973146, 137430918.652385, 266634612.255063, 517307292.635014, 1003646273.64047, 1947209824.67014, 3777851022.69026, 7329543107.69234, 14220307218.2724, 27589323701.4766, 53527027976.3571, 103849690372.38, 201482477136.65, 390903318513.094, 758405428581.828, 1471409340525, 2854733584163.2, 5538570139592.47, 10745576876721.9, 20847875806089.6, 40447705191861.9, 78474031143733.8, 152250258320878, 295386140114522, 573089154225693, 1111870646888807, 2157179779616058, 4185221198711724, 8119896472079771, 15753699885107074, 30564313341110788, 59298911165416064, 115047926192872144, 223208572655883520, 433054888999496256, 840185189372140416, 1630073162483360512, 3162562907154039296, 6135800755390145536, 11904285231665293312, 23095927088628809728, 44809229424741679104, 86935979401654583296, 1.68667585038894e+20, 3.27237979472409e+20, 6.34886040400066e+20, 1.23176498322335e+21, 2.3897910449238e+21, 4.63651858608037e+21, 8.99547458123233e+21, 1.74524401098118e+22, 3.38600996574481e+22, 6.56931833943232e+22, 1.2745368112143e+23, 2.47277418935474e+23, 4.79751713543167e+23, 9.30783359186e+23, 1.80584589336672e+24, 3.50358583273485e+24, 6.79743145992125e+24, 1.31879384887967e+25, 2.55863884188836e+25, 4.96410620111801e+25, 9.63103896202531e+25, 1.8685521165353e+26, 3.62524440610747e+26, 7.03346558424191e+26, 1.36458766866515e+27, 2.64748506006045e+27, 5.13647990832267e+27, 9.96546732089944e+27, 1.93343575165167e+28, 3.75112745382766e+28, 7.27769576146466e+28, 1.41197163381895e+29, 2.73941637580644e+29, 5.31483912303488e+29));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators19() {
        assertEval("argv <- list(structure(c(798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988, 798.368155587988), .Tsp = c(1971, 2000, 1), class = 'ts'), structure(c(96.1627886140128, 99.5328179233045, 102.792420797859, 105.951789523417, 109.019638748919, 112.00348906474, 114.909884224142, 117.744560053261, 120.512577567101, 123.218429147578, 125.866124161059, 128.459258681722, 131.001072784874, 133.494498015905, 135.942197018618, 138.34659685001, 140.70991716901, 143.034194231449, 145.321301429523, 147.572966965162, 149.790789131479, 151.976249586445, 154.130724932091, 156.255496856342, 158.351761049736, 160.420635073182, 162.463165323754, 164.480333221768, 166.473060722972, 168.442215243699), .Tsp = c(1971, 2000, 1), class = 'ts'));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators20() {
        assertEval("argv <- list(structure(978350400, class = c('POSIXct', 'POSIXt'), tzone = 'GMT'), c(1605796.39468342, 2250605.34500331, 3464617.14155227, 5492840.71388841, 1219772.31891453, 5433460.81468463, 5713396.02452517, 3996505.04896045, 3804881.73750043, 373683.36378783, 1245734.22899097, 1067815.23929536, 4155114.17658627, 2323059.28775668, 4656000.90815127, 3010085.0161314, 4340156.73798323, 5999048.06153476, 2298452.76521891, 4701988.69854212, 5653097.23772854, 1283037.96871752, 3941322.93728739, 759357.220374048, 1616150.60446411, 2335218.03170443, 80984.7349449992, 2312682.3643595, 5259890.2349174, 2058430.73196709, 2915620.53836882, 3626174.11217093, 2984937.82503158, 1126244.053334, 5003953.83093506, 4042886.83258742, 4803562.677674, 652843.049369752, 4377003.8016513, 2487387.75048405, 4965083.1868127, 3913420.05222291, 4735177.34632641, 3344763.6128068, 3203744.02103573, 4774026.48925781, 141107.11171478, 2886287.43334115, 4429033.49147737, 4189640.45360684, 2888643.47467571, 5208594.91588175, 2649611.30449176, 1480533.93148631, 427466.877132654, 601571.336723864, 1912811.28504127, 3136700.02379268, 4003806.70217425, 2460508.97211581, 5521073.589921, 1775713.19845319, 2776429.51241881, 2010322.98948616, 3936464.58484232, 1560485.48977822, 2894241.66157097, 4634646.93606645, 509525.338098407, 5293943.40406358, 2050713.12808245, 5076935.23793668, 2096741.74243212, 2018670.78146338, 2880972.33020514, 5396015.5351907, 5227525.11837333, 2358656.75892681, 4701235.58655381, 5809817.647174, 2628820.56391239, 4309288.77686709, 2419165.9430936, 1967729.81455922, 4578863.07127029, 1225882.75911659, 4300861.15349829, 735992.738373578, 1484714.53242749, 866704.886756837, 1449278.70250493, 356435.113750398, 3884559.38760191, 5299676.19835585, 4710875.96918643, 4822123.77896905, 2753499.89549071, 2480188.52821738, 4904143.22827756, 3658636.53959334));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators21() {
        assertEval("argv <- list(1, c(FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators22() {
        assertEval("argv <- list(1, structure(list(x = 1:9, y = c(-0.626453810742332, 0.183643324222082, -0.835628612410047, 1.59528080213779, 0.329507771815361, -0.820468384118015, 0.487429052428485, 0.738324705129217, 0.575781351653492)), .Names = c('x', 'y'), row.names = c(NA, -9L), class = 'data.frame'));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators23() {
        assertEval("argv <- list(1:2, c(0+8i, 0+9i));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators24() {
        assertEval("argv <- list(c(14, 2, 2, -7), c(14, 2, 2, -7));`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators25() {
        assertEval("argv <- list(c(-1, -2, -3, -4, -5, -6, -7, -8, -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -29, -30, -31, -32, -33, -34, -35, -36, -37, -38, -39, -40, -41, -42, -43, -44, -45, -46, -47, -48, -49, -50, -1000, -10000, -1e+05, -1e+06, -1e+07, -1e+08, -1e+09, -1e+10, -1e+20, -1e+50, -1e+150, -1e+250, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 1000, 10000, 1e+05, 1e+06, 1e+07, 1e+08, 1e+09, 1e+10, 1e+20, 1e+50, 1e+150, 1e+250));`+`(argv[[1]]);");
    }

    @Test
    public void testoperators26() {
        assertEval("argv <- list(structure(c(1+1i, 2+2i, 1.2+10i, 2.4+20i), .Dim = c(2L, 2L), .Dimnames = list(c('x', ''), c('a', 'b'))), 3.14159265358979);`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators27() {
        assertEval("argv <- list(structure(c(1, 0.81, 0.64, 0.49, 0.36, 0.25, 0.16, 0.09, 0.04, 0.01, 0.81, 1, 0.81, 0.64, 0.49, 0.36, 0.25, 0.16, 0.09, 0.04, 0.64, 0.81, 1, 0.81, 0.64, 0.49, 0.36, 0.25, 0.16, 0.09, 0.49, 0.64, 0.81, 1, 0.81, 0.64, 0.49, 0.36, 0.25, 0.16, 0.36, 0.49, 0.64, 0.81, 1, 0.81, 0.64, 0.49, 0.36, 0.25, 0.25, 0.36, 0.49, 0.64, 0.81, 1, 0.81, 0.64, 0.49, 0.36, 0.16, 0.25, 0.36, 0.49, 0.64, 0.81, 1, 0.81, 0.64, 0.49, 0.09, 0.16, 0.25, 0.36, 0.49, 0.64, 0.81, 1, 0.81, 0.64, 0.04, 0.09, 0.16, 0.25, 0.36, 0.49, 0.64, 0.81, 1, 0.81, 0.01, 0.04, 0.09, 0.16, 0.25, 0.36, 0.49, 0.64, 0.81, 1), .Dim = c(10L, 10L)), structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), .Dim = c(10L, 10L)));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators28() {
        assertEval("argv <- list(structure(5.5965311794562, .Names = 'thetas'), structure(c(3, 2, 2, 1, 1, 2), .Dim = 6L, .Dimnames = list(c('1', '2', '3', '4', '5', '6'))));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators29() {
        assertEval("argv <- list(c(NA, 6.12, 19.92, 29.64, 35.4, 39.72, 45.24, 52.32, 63.48), c(6.12, 19.92, 29.64, 35.4, 39.72, 45.24, 52.32, 63.48, NA));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators30() {
        assertEval("argv <- list(structure(c(-0.560475646552213+0i, 0.7424437487+0i, 1.39139505579429+0i, 0.928710764113827+0i, -0.469267985412949+0i, 0.7424437487+0i, 0.460916205989202+0i, -0.452623703774585+0i, -0.0945011868321433+0i, -0.331818442379127+0i, 1.39139505579429+0i, -0.452623703774585+0i, 0.400771450594052+0i, -0.927967220342259+0i, -0.790922791530657+0i, 0.928710764113827+0i, -0.0945011868321433+0i, -0.927967220342259+0i, 0.701355901563686+0i, -0.600841318509537+0i, -0.469267985412949+0i, -0.331818442379127+0i, -0.790922791530657+0i, -0.600841318509537+0i, -0.625039267849257+0i), .Dim = c(5L, 5L)), c(0-1.68669331074241i, 0+0.837787044494525i, 0+0.153373117836515i, 0-1.13813693701195i, 0+1.25381492106993i, 0+0.426464221476814i, 0-0.295071482992271i, 0+0.895125661045022i, 0+0.878133487533042i, 0+0.821581081637487i, 0+0.688640254100091i, 0+0.553917653537589i, 0-0.0619117105767217i, 0-0.305962663739917i, 0-0.380471001012383i, 0-0.694706978920513i, 0-0.207917278019599i, 0-1.26539635156826i, 0+2.16895596533851i, 0+1.20796199830499i, 0-1.12310858320335i, 0-0.402884835299076i, 0-0.466655353623219i, 0+0.779965118336318i, 0-0.0833690664718293i));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators31() {
        assertEval("argv <- list(structure(FALSE, class = structure('foo', package = '.GlobalEnv')), NA);`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators32() {
        assertEval("argv <- list(2.11111111111111, structure(c(3, 2, 2, 1, 1, 2), .Dim = 6L, .Dimnames = list(c('1', '2', '3', '4', '5', '6'))));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators33() {
        assertEval("argv <- list(c(20.8, 11.2, 6.2, 12.8, 43.4), c(10.4, 5.6, 3.1, 6.4, 21.7, 0, 10.4, 5.6, 3.1, 6.4, 21.7));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators34() {
        assertEval(Output.IgnoreWarningContext,
                        "argv <- list(structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = 'data.frame'), structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = 'data.frame'));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators35() {
        assertEval("argv <- list(c(3, 1, 2, 2, 3.2, -1, 1, 3.2, 4, 3, 3.2, 3.2, 202, 241, 243), 0);`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators36() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'));`+`(argv[[1]]);");
    }

    @Test
    public void testoperators37() {
        assertEval("argv <- list(logical(0));`+`(argv[[1]]);");
    }

    @Test
    public void testoperators38() {
        assertEval("argv <- list(structure(c(0.2, -1.84560926910116e-17, -3.69226410848886e-17, 2.11212282911474e-17, 9.44321399451751e-18, 3.05608209061811e-17, 0.2, -5.35638147485559e-17, 5.12150597333887e-17, 1.92692213766805e-17, 6.57361167807833e-17, -7.28393619263486e-17, 0.2, 7.17735727503349e-17, 3.10850404080861e-17, -2.28831714606547e-17, 2.83709294123644e-17, 7.98995130974544e-17, 0.2, 0, 8.8841915809257e-17, -1.17177477007305e-16, -1.30709215062431e-16, 1.04641694001652e-16, 0.2), .Dim = c(5L, 5L), fracs = c('1/5', '0', '0', '0', '0', '0', '1/5', '0', '0', '0', '0', '0', '1/5', '0', '0', '0', '0', '0', '1/5', '0', '0', '0', '0', '0', '1/5'), class = c('fractions', 'matrix')), 1);`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators39() {
        assertEval("argv <- list(structure(c(-24.5833333333333, -5.08333333333333, 10.25, 19.4166666666667), .Dim = 4L, .Dimnames = structure(list(N = c('0.0cwt', '0.2cwt', '0.4cwt', '0.6cwt')), .Names = 'N'), strata = structure('Within', .Names = 'N'), class = 'mtable'), structure(103.972222222222, class = 'mtable'));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators40() {
        assertEval("argv <- list(structure(1.2728543779194, .Names = 'Var1'), 1);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators41() {
        assertEval("argv <- list(1.15);`-`(argv[[1]]);");
    }

    @Test
    public void testoperators42() {
        assertEval("argv <- list(structure(c(6316.53846153846, 6350.69230769231), .Dim = 2L, .Dimnames = list(c('1', '2'))), c(6314.13609467456, 6338.60946745562));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators43() {
        assertEval("argv <- list(1, c(0.588534374722704, 0.346372710230244, 0.203852246436365, 0.119974054392244, 0.0706088550846872, 0.0244569805019377));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators44() {
        assertEval("argv <- list(structure(c(-0.560475646552213+0i, 0.7424437487+0i, 1.39139505579429+0i, 0.928710764113827+0i, -0.469267985412949+0i, 0.7424437487+0i, 0.460916205989202+0i, -0.452623703774585+0i, -0.0945011868321433+0i, -0.331818442379127+0i, 1.39139505579429+0i, -0.452623703774585+0i, 0.400771450594052+0i, -0.927967220342259+0i, -0.790922791530657+0i, 0.928710764113827+0i, -0.0945011868321433+0i, -0.927967220342259+0i, 0.701355901563686+0i, -0.600841318509537+0i, -0.469267985412949+0i, -0.331818442379127+0i, -0.790922791530657+0i, -0.600841318509537+0i, -0.625039267849257+0i), .Dim = c(5L, 5L)), structure(c(-0.560475646552213+0i, 0.742443748700001+0i, 1.39139505579429+0i, 0.928710764113827+0i, -0.469267985412949+0i, 0.742443748700001+0i, 0.460916205989202+0i, -0.452623703774585+0i, -0.094501186832143+0i, -0.331818442379127+0i, 1.39139505579429+0i, -0.452623703774585+0i, 0.400771450594052+0i, -0.927967220342258+0i, -0.790922791530656+0i, 0.928710764113827+0i, -0.094501186832143+0i, -0.927967220342258+0i, 0.701355901563685+0i, -0.600841318509537+0i, -0.469267985412949+0i, -0.331818442379127+0i, -0.790922791530656+0i, -0.600841318509537+0i, -0.625039267849256+0i), .Dim = c(5L, 5L)));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators45() {
        assertEval("argv <- list(38, 24L);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators46() {
        assertEval("argv <- list(structure(c(14, 2, 0, 2, -7, 0), .Dim = c(3L, 2L)), 0);`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators47() {
        assertEval("argv <- list(1979.91666666667, structure(1979.91666666667, .Names = 'data'));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators48() {
        assertEval("argv <- list(41L, 0L);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators49() {
        assertEval("argv <- list(7.12801378828154e+22);`-`(argv[[1]]);");
    }

    @Test
    public void testoperators50() {
        assertEval("argv <- list(structure(c(315.42, 316.31, 316.5, 317.56, 318.13, 318, 316.39, 314.65, 313.68, 313.18, 314.66, 315.43, 316.27, 316.81, 317.42, 318.87, 319.87, 319.43, 318.01, 315.74, 314, 313.68, 314.84, 316.03), .Tsp = c(1959, 1960.91666666667, 12), class = 'ts'), structure(c(-0.234444444444459, 0.192638888888913, 0.743888888888894, 2.15972222222219, 3.13138888888888, 2.65888888888892, 0.480138888888822, -1.31611111111111, -2.34527777777775, -2.93819444444447, -1.58527777777776, -0.947361111111074, -0.234444444444459, 0.192638888888913, 0.743888888888894, 2.15972222222219, 3.13138888888888, 2.65888888888892, 0.480138888888822, -1.31611111111111, -2.34527777777775, -2.93819444444447, -1.58527777777776, -0.947361111111074), .Tsp = c(1959, 1960.91666666667, 12), class = 'ts'));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators51() {
        assertEval("argv <- list(structure(c(94694400, 126230400, 157766400, 189302400, 220924800, 252460800, 283996800, 315532800, 362793600, 394329600, 425865600, 489024000, 567993600, 631152000, 662688000, 709948800, 741484800, 773020800, 820454400, 867715200, 915148800, 1136073600, 1230768000, 1341100800), class = c('POSIXct', 'POSIXt')), structure(c(78796800, 94694400, 126230400, 157766400, 189302400, 220924800, 252460800, 283996800, 315532800, 362793600, 394329600, 425865600, 489024000, 567993600, 631152000, 662688000, 709948800, 741484800, 773020800, 820454400, 867715200, 1136073600, 1230768000, 1341100800), class = c('POSIXct', 'POSIXt')));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators52() {
        assertEval("argv <- list(structure(c(9, 12, 12, 15, 9, 9, 13, 11, 15, 10, 13, 13, 13, 15, 8, 13, 13, 10, 7, 9, 6, 11, 3, 5, 9, 3, 5, 1, 1, 2, NA, 10, 1, 4, 7, 4, NA, NA, 5, 2, 4, 3, 3, 6, 1, 1, 63, 41, 59, 50, 290, 226, 60, 36, 32, 121, 70, 51, 79, 32, 42, 39, 76, 60, 56, 88, 57, 309, 254, 146, 43, 78, 88, 314, 149, 78, NA, 238, 153, 159, 222, 203, NA, NA, 74, 100, 111, 9, 180, 50, 256, 107), .Dim = c(23L, 4L), .Dimnames = list(NULL, c('V1', 'V2', 'V3', 'V4'))), structure(c(10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 10.8260869565217, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 3.85, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 95.2608695652174, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9, 137.9), .Dim = c(23L, 4L)));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators53() {
        assertEval("argv <- list(structure(c(58.56, 2.776, 61.341, 0, 0), .Names = c('user.self', 'sys.self', 'elapsed', 'user.child', 'sys.child'), class = 'proc_time'), structure(c(40.692, 0.307, 41, 0, 0), .Names = c('user.self', 'sys.self', 'elapsed', 'user.child', 'sys.child'), class = 'proc_time'));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators54() {
        assertEval("argv <- list(0+1e-04i);`-`(argv[[1]]);");
    }

    @Test
    public void testoperators55() {
        assertEval("argv <- list(structure(c(1.05569354979237, 0.694336127879446, -0.0222037058662105), .Dim = c(1L, 3L)), 0.055);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators56() {
        assertEval("argv <- list(structure(c(-50, 175, 149, 214, 247, 237, 225, 329, 729, 809, 530, 489, 540, 457, 195, 176, 337, 239, 128, 102, 232, 429, 3, 98, 43, -141, -77, -13, 125, 361, -45, 184), .Tsp = c(1951, 1958.75, 4), class = 'ts'), structure(c(NA, NA, 159.125, 204, 221.25, 245.125, 319.75, 451.5, 561.125, 619.25, 615.625, 548, 462.125, 381.125, 316.625, 264, 228.375, 210.75, 188.375, 199, 207.125, 191, 166.875, 72, -9.25, -33.125, -36.75, 36.25, 103, 131.625, NA, NA), .Tsp = c(1951, 1958.75, 4), class = 'ts'));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators57() {
        assertEval("argv <- list(structure(c(0, 1, 0, 2), .Names = c('age', 'strata(ss)', 'age2', 'age:strata(ss)')), 1);`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators58() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'), 1L);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators59() {
        assertEval("argv <- list(50, structure(c(1, 2, 1, 3, 4, 4, 4, 1, 2, 2, 1, 4, 2, 1, 5, 5, 5, 1, 1, 5, 2, 4, 5, 2, 3, 2, 1, 1, 1, 3, 2, 2, 5, 5, 2, 1, 1, 4, 1, 1, 1, 6, 4, 1, 4, 2, 4, 1, 1, 1, 7, 7, 7, 8, 8, 9, 10, 7, 7, 10, 8, 7, 8, 9, 11, 7, 9, 10, 12, 7, 9, 7, 12, 9, 7, 7, 8, 8, 9, 11, 7, 7, 7, 13, 9, 10, 7, 8, 10, 8, 9, 9, 7, 7, 9, 10, 10, 7, 11, 10, 14, 14, 12, 14, 14, 15, 14, 14, 15, 13, 8, 12, 12, 15, 15, 12, 13, 13, 15, 15, 12, 14, 15, 12, 13, 13, 12, 13, 15, 13, 15, 13, 15, 13, 14, 12, 14, 13, 9, 12, 12, 8, 14, 14, 12, 12, 12, 12, 13, 13, 4, 1, 4, 2, 1, 1, 1, 4, 3, 3, 4, 3, 1, 4, 1, 4, 1, 4, 2, 4, 3, 1, 4, 1, 4, 3, 2, 4, 2, 2, 3, 1, 4, 4, 1, 2, 2, 1, 4, 2, 4, 2, 1, 4, 3, 1, 1, 4, 4, 2, 10, 10, 8, 12, 7, 10, 7, 10, 8, 7, 7, 10, 7, 10, 7, 11, 10, 7, 8, 10, 13, 11, 13, 10, 10, 10, 7, 9, 10, 7, 8, 10, 10, 14, 10, 7, 10, 12, 7, 7, 13, 10, 10, 10, 10, 7, 7, 10, 7, 7, 15, 15, 15, 13, 15, 14, 13, 15, 14, 12, 9, 15, 13, 14, 14, 13, 14, 14, 14, 14, 13, 13, 14, 8, 14, 14, 8, 9, 14, 12, 12, 9, 14, 9, 13, 15, 13, 14, 13, 8, 15, 12, 15, 15, 15, 8, 15, 13, 14, 14), .Dim = c(150L, 2L), .Dimnames = list(NULL, c('cluster', 'neighbor'))));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators60() {
        assertEval("argv <- list(structure(c(1L, 1L, 1L, 2L, 2L, 2L, 3L, 3L, 3L), .Dim = c(3L, 3L)), structure(c(1L, 2L, 3L, 1L, 2L, 3L, 1L, 2L, 3L), .Dim = c(3L, 3L)));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators61() {
        assertEval("argv <- list(structure(c(1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1), .Dim = c(7L, 7L), .Dimnames = list(NULL, NULL)), c(1, 0, 0, 0, 0, 0, 0));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators62() {
        assertEval("argv <- list(c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0), structure(c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1), .Dim = c(10L, 10L)));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators63() {
        assertEval("argv <- list(structure(list(war = c(1L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 2L), fly = c(1L, 2L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), ver = c(1L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 2L), end = c(1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, NA, 1L, 1L, 2L, 1L, 1L, NA, 2L), gro = c(2L, 2L, 1L, 1L, 2L, 2L, 2L, 1L, 2L, 1L, NA, 2L, 2L, 1L, NA, 2L, 2L, NA, 1L, 2L), hai = c(1L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L)), .Names = c('war', 'fly', 'ver', 'end', 'gro', 'hai'), class = 'data.frame', row.names = c('ant', 'bee', 'cat', 'cpl', 'chi', 'cow', 'duc', 'eag', 'ele', 'fly', 'fro', 'her', 'lio', 'liz', 'lob', 'man', 'rab', 'sal', 'spi', 'wha')), 1);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators64() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'));`-`(argv[[1]]);");
    }

    @Test
    public void testoperators65() {
        assertEval("argv <- list(c(41L, 36L, 12L, 18L, NA, 28L, 23L, 19L, 8L, NA, 7L, 16L, 11L, 14L, 18L, 14L, 34L, 6L, 30L, 11L, 1L, 11L, 4L, 32L, NA, NA, NA, 23L, 45L, 115L, 37L, NA, NA, NA, NA, NA, NA, 29L, NA, 71L, 39L, NA, NA, 23L, NA, NA, 21L, 37L, 20L, 12L, 13L, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 135L, 49L, 32L, NA, 64L, 40L, 77L, 97L, 97L, 85L, NA, 10L, 27L, NA, 7L, 48L, 35L, 61L, 79L, 63L, 16L, NA, NA, 80L, 108L, 20L, 52L, 82L, 50L, 64L, 59L, 39L, 9L, 16L, 78L, 35L, 66L, 122L, 89L, 110L, NA, NA, 44L, 28L, 65L, NA, 22L, 59L, 23L, 31L, 44L, 21L, 9L, NA, 45L, 168L, 73L, NA, 76L, 118L, 84L, 85L, 96L, 78L, 73L, 91L, 47L, 32L, 20L, 23L, 21L, 24L, 44L, 21L, 28L, 9L, 13L, 46L, 18L, 13L, 24L, 16L, 13L, 23L, 36L, 7L, 14L, 30L, NA, 14L, 18L, 20L));`-`(argv[[1]]);");
    }

    @Test
    public void testoperators66() {
        assertEval("argv <- list(structure(c(0.163529648037515, 0.690300939958932, 1.33873438218701, 1.66977334065937, 2.08385700655167, 1.90103052674775, 1.24826888183738, -0.346530864750065, -2.02114485014442, -1.391176571206, -0.974900546993623, -0.592397172772186, 1.12800897451332, 1.28932367812798, 1.52806194332292, 0.902674841819288, -0.592397172772186, -1.58883249200006, -2.79944983904467, -2.38660462363888, 1.11301751209174, 0.656516272159253, 0.0219290473645453, -0.905668755424301, -1.30280742075591, -1.17239032526075, -0.455509560368709, -0.00488221008611145, 1.01557266990962, 1.33518324209154, 1.7902682423845, 1.2223240303426, -0.642532985196542, -2.3156528876666, -2.94255068268534, -2.71429203070436, -2.52857488490927, -1.36967036598504, -0.673867141366977, 0.557834355527559, -1.17239032526075, -0.455509560368709, -0.00488221008611145, 1.01557266990962, 1.33518324209154, 1.7902682423845, 1.2223240303426, -0.642532985196542, -2.3156528876666, -2.94255068268534, -2.71429203070436, -2.52857488490927, -1.36967036598504, -0.673867141366977, 0.557834355527559, 1.69565743430218, 1.55297632585292, -0.231087508986891, -1.95215197865747, -1.57567440742255, 1.27884061694483, 1.52424121861625, -1.01140094921315, -0.834671205684972, -0.234500481583131, 0.163529648037515, 0.690300939958932, 1.33873438218701, 1.66977334065937, 2.08385700655167, 1.90103052674775, 1.24826888183738, -0.346530864750065, -2.02114485014442, -1.391176571206, -0.974900546993623, -0.592397172772186, 1.12800897451332, 1.28932367812798, 1.52806194332292, -0.720008297364832, -0.01169886906521, 0.795118935598027, 1.30411137828236, 1.35630335130608, 1.05258722945331, -0.0781544111924379, -0.905668755424301, -1.14228052378938, -1.10485411827026, -0.292564282537893, 0.785919238699603, 1.49889320873226, 2.20687990315498, 1.74950266694519, -0.073778036592639, -1.06484878365656, -0.447016940323056, -0.725579342414288, 0.0582966915354195, 1.55297632585292, -0.231087508986891, -1.95215197865747, -1.57567440742255, -0.647687635785206, 0.0245710568273836, 0.569377384809234, 1.54435558280902, 2.246266557697, 2.14425394955264, 1.63506382167997, 0.909232242365448, -0.762567911783628, -0.660691720208413), .Dim = c(114L, 1L), .Dimnames = list(NULL, 'Series 1'), .Tsp = c(1, 114, 1), class = 'ts'), structure(c(-1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16, -1.79193891693885e-16), .Dim = c(114L, 1L)));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators67() {
        assertEval("argv <- list(c(4L, 3L, 2L, 1L, 2L, 3L, 4L, 5L), 0+5i);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators68() {
        assertEval("argv <- list(structure(integer(0), .Label = character(0), class = 'factor'), structure(integer(0), .Label = character(0), class = 'factor'));`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators69() {
        assertEval(Output.IgnoreWarningContext,
                        "argv <- list(structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = 'data.frame'), structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = 'data.frame'));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators70() {
        assertEval("argv <- list(1, structure(c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59), .Tsp = c(0, 59, 1), class = 'ts'));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators71() {
        assertEval("argv <- list(-3.14159265358979, 3.14159265358979);`:`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators72() {
        // FIXME
        // Expected output: [1] 1:1 1:1 1:2 2:2 2:3 2:3
        // Levels: 1:1 1:2 1:3 2:1 2:2 2:3
        // FastR output: [1] 1
        // Warning messages:
        // 1: In argv[[1]]:argv[[2]] :
        // numerical expression has 6 elements: only the first used
        // 2: In argv[[1]]:argv[[2]] :
        // numerical expression has 6 elements: only the first used
        assertEval(Ignored.ImplementationError,
                        "argv <- list(structure(c(1L, 1L, 1L, 2L, 2L, 2L), .Label = c('1', '2'), class = 'factor'), structure(c(1L, 1L, 2L, 2L, 3L, 3L), .Label = c('1', '2', '3'), class = 'factor'));`:`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators74() {
        assertEval("argv <- list(0.5, -0.5);`:`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators75() {
        assertEval("argv <- list(101L, 1L);`:`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators76() {
        assertEval("argv <- list(FALSE, 1);`:`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators77() {
        assertEval("argv <- list(structure(c(0, 4.44089209850063e-16, 8.88178419700125e-16, 1.66533453693773e-15, 2.22044604925031e-16, 3.33066907387547e-16, 2.77555756156289e-16, 5.55111512312578e-17, 8.32667268468867e-17, 1.66533453693773e-16, 8.88178419700125e-16, 1.11022302462516e-16, 2.44249065417534e-15, 2.22044604925031e-16, 1.11022302462516e-16, 1.88737914186277e-15, 1.11022302462516e-16, 2.22044604925031e-16, 1.4432899320127e-15, 8.88178419700125e-16, 3.33066907387547e-16, 1.66533453693773e-16, 1.11022302462516e-16, 7.7715611723761e-16, 1.11022302462516e-16), .Dim = c(5L, 5L)), 2.22044604925031e-13);`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators78() {
        assertEval("argv <- list(1, 4);`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators79() {
        assertEval("argv <- list(NULL, NULL);`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators80() {
        assertEval("argv <- list(structure(1L, .Label = c('A', 'B', 'C'), class = c('ordered', 'factor')), structure(3L, .Label = c('A', 'B', 'C'), class = c('ordered', 'factor')));`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators81() {
        assertEval("argv <- list(structure(1386500270.17764, class = c('POSIXct', 'POSIXt')), structure(c(1383854025.35606, 1386388510.66806), class = c('POSIXct', 'POSIXt')));`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators82() {
        assertEval("argv <- list(c(0.999998001700552, -0.0013118835870674, -0.000526551904329415, 0.999999038344567, -0.000903475278483392, -0.000381296378838388, 0.999999057686544, -0.000896140095625969, -0.000373156128147092, 0.999998405868953, -0.00114777435393854, -0.000526063245555164, 0.99999814161282, -0.00120795166706622, -0.000631851641234638, 0.999997792453059, -0.00139185834612791, -0.000519877304541034, 0.999998020546725, -0.00127080900255349, -0.00060373324887666, 0.999998059330159, -0.00123814735894241, -0.000638480377887232, 0.999998337108097, -0.00115570987192407, -0.000572034814304861, 0.999998571810103, -0.00106400147389197, -0.00054414035107764, 0.999999136998844, -0.000829344110491764, -0.000418555560445895, 0.999999436800894, -0.000688792506748533, -0.00029793232712181, 0.999999182435777, -0.000786088000160243, -0.000446798847724984, 0.999998035855459, -0.00125214214514046, -0.000629508325517675, 0.999995461301925, -0.00191759993645823, -0.000928163756226527, 0.999990501294199, -0.00282586497589704, -0.00123008240127283, 0.99998523015117, -0.00349306924843624, -0.00160252859811979, 0.999980247693918, -0.00393070891026528, -0.00207399213858218, 0.999258133391236, -0.0212608113487506, 0.0170086490790013, 0.999752823870685, -0.0151150534926454, -0.00431858671218418, 0.998521231438773, -0.0331918414882689, 0.0193619075348229, 0.973987730061349, 0.0773006134969334, -0.139141104294479, 0.997923156801661, -0.0321910695742469, 0.0321910695742468, 0.999947758503179, -0.00259457124676546, -0.006745885241587, -0.0013118835870674, 0.138748425090248, -0.345681325192261, -0.000903475278483392, 0.151184975864853, -0.358227947918666, -0.000896140095625969, 0.147770769059702, -0.354871477867884, -0.00114777435393854, 0.173602465164251, -0.378765536799718, -0.00120795166706622, 0.214831416406957, -0.410703566802515, -0.00139185834612791, 0.122433312766354, -0.327782640513123, -0.00127080900255349, 0.184140620360657, -0.387596745778816, -0.00123814735894241, 0.21006198499474, -0.407350481092054, -0.00115570987192407, 0.196781639012774, -0.397564195941878, -0.00106400147389197, 0.207318901950479, -0.405384561552842, -0.000829344110491764, 0.203000309817415, -0.402231893588506, -0.000688792506748533, 0.157606764246543, -0.364371236069974, -0.000786088000160243, 0.244176387845927, -0.429597092087573, -0.00125214214514046, 0.201759382472957, -0.401311557517518, -0.00191759993645823, 0.189814026846399, -0.392149187005707, -0.00282586497589704, 0.159305169670633, -0.365949514378666, -0.00349306924843624, 0.173889122744829, -0.378998013455332, -0.00393070891026528, 0.217788926857211, -0.412724435577854, -0.0212608113487506, 0.000452357688250284, -0.00036188615058233, -0.0151150534926454, 0.000228521327097438, 6.52918077527545e-05, -0.0331918414882689, 0.00110332991097693, -0.000643609114746404, 0.0773006134969334, 0.00613496932514866, -0.0110429447852694, -0.0321910695742469, 0.0010384215991718, -0.00103842159917336, -0.00259457124676546, 6.73215168555691e-06, 1.75035942027152e-05, -0.000526551904329415, -0.345681325192261, 0.861253573209199, -0.000381296378838388, -0.358227947918666, 0.848815985790579, -0.000373156128147092, -0.354871477867884, 0.852230173253752, -0.000526063245555164, -0.378765536799718, 0.826399128966796, -0.000631851641234638, -0.410703566802515, 0.785170441980223, -0.000519877304541034, -0.327782640513123, 0.877568894780586, -0.00060373324887666, -0.387596745778816, 0.815861359092619, -0.000638480377887232, -0.407350481092054, 0.789939955675102, -0.000572034814304861, -0.397564195941878, 0.803220023879128, -0.00054414035107764, -0.405384561552842, 0.792682526239419, -0.000418555560445895, -0.402231893588506, 0.797000553183741, -0.00029793232712181, -0.364371236069974, 0.842393798952562, -0.000446798847724984, -0.429597092087573, 0.755824429718295, -0.000629508325517675, -0.401311557517518, 0.798242581671585, -0.000928163756226527, -0.392149187005707, 0.810190511851676, -0.00123008240127283, -0.365949514378666, 0.840704329035169, -0.00160252859811979, -0.378998013455332, 0.826125647104002, -0.00207399213858218, -0.412724435577854, 0.782230825448871, 0.0170086490790013, -0.00036188615058233, 0.00028950892043616, -0.00431858671218418, 6.52918077527545e-05, 1.86548021961656e-05, 0.0193619075348229, -0.000643609114746404, 0.000375438650284673, -0.139141104294479, -0.0110429447852694, 0.0198773006134874, 0.0321910695742468, -0.00103842159917336, 0.00103842159917592, -0.006745885241587, 1.75035942027152e-05, 4.55093454284494e-05), 0.692636183089874);`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators83() {
        assertEval("argv <- list(20, structure(c(-1, -1, -1, -1, -1, -1, -1, 8, 9, 10, 11, 12, 13, 14, 15, 100, 17, 18, 19, 20, 21, 200, 200, 24, 25, 26, 27, 28), .Dim = c(7L, 4L), .Dimnames = list(NULL, NULL)));`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators84() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'));`<`(argv[[1]]);");
    }

    @Test
    public void testoperators85() {
        assertEval("argv <- list(c(2.00256647265648e-308, 2.22284878464869e-308, 2.22507363599982e-308, 2.2250738585072e-308, 2.22507408101459e-308, 2.22729893236571e-308, 2.44758124435792e-308, 1.61792382137608e+308, 1.79589544172745e+308, 1.797692955093e+308, 1.79769313486232e+308), 1);`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators86() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'), 1L);`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators87() {
        assertEval("argv <- list(structure(c(629, 1026, 1422, 1819, 2214, 2611), class = 'difftime', units = 'days', .Names = c('1', '2', '3', '4', '5', '6')), 0);`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators88() {
        assertEval("argv <- list(c(1, 2, 3, 4, 5, 6, 7, NA, 9, 10, 11, 12), 2);`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators89() {
        assertEval("argv <- list(structure(3.0625, base = 4, lens = 3L, .classes = c('R_system_version', 'package_version', 'numeric_version')), structure(3.25, .Names = 'gridSVG2', base = 4, lens = structure(2L, .Names = 'gridSVG2'), .classes = 'numeric_version'));`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators90() {
        assertEval("argv <- list(c(1, 0, 0, 1, 0, 1, 2, 2, 1, 2, 1, 2, 1, NA, 1, 1, 1, 2, 2, 1, 1, 0, 1, 0, 0, 1, 0, 3, 1, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 1, 2, 0, 2, 1, 2, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 2, 1, 1, 2, 1, 1, 1, 1, 2, 2, 0, 0, 1, 0, 1, 2, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 2, 0, 1, 1, 1, 0, 2, 1, 1, 1, 0, 0, 1, 1, 1, 2, 1, 1, 1, 1, 2, 0, 1, 1, 0, 1, 2, 2, 2, 2, 1, 0, 2, 1, 2, 0, 1, 1, 1, 2, 0, 1, 1, 0, 1, 0, 2, 1, 2, 1, 0, 2, 1, 2, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 2, 2, 1, 2, 1, 1, 0, 1, 2, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 2, 1, 1, 0, 0, 0, 0, 1, 0, 0, 2, 0, 1, 0, 1, 2, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 2, 0, 2, 1, 1, 0, 1, 1, 2, 1, 1, 1, 2, 2, 0, 1, 1, 1, 1, 0, 2, 1, 1), 1);`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators91() {
        assertEval("argv <- list(structure(list(c(3L, 0L, 1L)), class = c('R_system_version', 'package_version', 'numeric_version')), structure('3.1', .Names = 'gridSVG2'));`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators92() {
        assertEval("argv <- list(structure(c(0, 0.414213562373095, 0.732050807568877, 0, 0.23606797749979, 0.449489742783178, 0.645751311064591, 0.82842712474619, 0, 0.16227766016838), id = 'test 1', class = structure('withId', package = '.GlobalEnv')), 0.01);`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators93() {
        assertEval("argv <- list(NULL, NULL);`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators94() {
        assertEval("argv <- list('a', 'b');`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators95() {
        assertEval("argv <- list(structure(c(1386478800, 1386651600, 1386824400, 1386997200, 1387170000, 1387342800, 1387515600, 1387688400, 1387861200, 1388034000, 1388206800, 1388379600, 1388552400, 1388725200), class = c('POSIXct', 'POSIXt'), tzone = ''), structure(1387538790.57927, class = c('POSIXct', 'POSIXt')));`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators96() {
        assertEval("argv <- list(c(17, 45.1, 39.7, 36.5, 43.5), 6);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators97() {
        assertEval("argv <- list(structure(c(69, 35, 26, 21, 18, 16, 13, 12, 12), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9')), 0);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators98() {
        assertEval("argv <- list(c(0L, 1L, 2L, 2L, 2L, 3L, 4L, 5L, 5L, 5L, 6L, 7L, 7L, 7L, 8L, 9L, 9L, 9L, 10L, 11L, 11L, 11L, 12L, 12L, 12L, 13L, 14L, 14L, 14L), 1L);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators99() {
        assertEval("argv <- list(150000, 3e+09);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators100() {
        assertEval("argv <- list(c(30L, 30L, 60L, 60L, 60L, 60L, 60L, 60L, 30L, 30L, 60L, 60L, 60L, NA, 30L, 30L, 30L, 30L, 60L, 60L, 60L, 60L, 60L, 60L, 30L, 30L, 60L, 60L, 60L, 60L, 30L, 30L, 30L, NA, 30L, 30L, 60L, 60L, 30L, 30L, 30L, 30L, 30L, 60L, 60L, 30L, 30L, 30L, 30L, 60L, NA, 60L, NA, 30L, 60L, 60L, 30L, NA, 30L, 30L, 60L, NA, 30L, 30L, 30L, 30L, 30L, NA, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, NA, 18L, 18L, 30L, 30L, 30L, 30L, 18L, 18L, 30L, 30L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, NA, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, NA, 18L, 18L, 30L, 30L, 18L, 18L, 30L, 30L, 18L, 18L, 30L, 30L, 30L, 30L, NA, 18L, NA, 30L, 30L, NA, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 30L, 30L, NA, 30L, 18L, 18L, 30L, 30L, 18L, 18L, 7L, 7L, 30L, 30L, 18L, 18L, NA, 30L, 7L, 7L, 7L, NA, 18L, 18L, 7L, 7L, 18L, NA, 30L, 30L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 18L, 18L), 60);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators101() {
        assertEval("argv <- list(structure(c(21, 0, 77, 0, 0, 96, 0, 0, 0, 0, 0, 0, 0, 0, 77, 0, 325, 0, 0, 288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 361, 0, 513, 96, 0, 288, 0, 0, 576, 0, 0, 0, 0, 0, 513, 0, 729), .Dim = c(7L, 7L), .Dimnames = list(NULL, NULL)), 0);`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators102() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'), 0L);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators103() {
        assertEval("argv <- list(NULL, NULL);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators104() {
        assertEval("argv <- list(structure(c(-1.47120249322699, 0.791288894530825, 4.43110323863505), .Dim = c(1L, 3L)), 0.0031308);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators105() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'));`<=`(argv[[1]]);");
    }

    @Test
    public void testoperators106() {
        assertEval("argv <- list(0.998212441139784, c(0.999998001700552, -0.0013118835870674, -0.000526551904329415, 0.999999038344567, -0.000903475278483392, -0.000381296378838388, 0.999999057686544, -0.000896140095625969, -0.000373156128147092, 0.999998405868953, -0.00114777435393854, -0.000526063245555164, 0.99999814161282, -0.00120795166706622, -0.000631851641234638, 0.999997792453059, -0.00139185834612791, -0.000519877304541034, 0.999998020546725, -0.00127080900255349, -0.00060373324887666, 0.999998059330159, -0.00123814735894241, -0.000638480377887232, 0.999998337108097, -0.00115570987192407, -0.000572034814304861, 0.999998571810103, -0.00106400147389197, -0.00054414035107764, 0.999999136998844, -0.000829344110491764, -0.000418555560445895, 0.999999436800894, -0.000688792506748533, -0.00029793232712181, 0.999999182435777, -0.000786088000160243, -0.000446798847724984, 0.999998035855459, -0.00125214214514046, -0.000629508325517675, 0.999995461301925, -0.00191759993645823, -0.000928163756226527, 0.999990501294199, -0.00282586497589704, -0.00123008240127283, 0.99998523015117, -0.00349306924843624, -0.00160252859811979, 0.999980247693918, -0.00393070891026528, -0.00207399213858218, 0.999258133391236, -0.0212608113487506, 0.0170086490790013, 0.999752823870685, -0.0151150534926454, -0.00431858671218418, 0.998521231438773, -0.0331918414882689, 0.0193619075348229, 0.973987730061349, 0.0773006134969334, -0.139141104294479, 0.997923156801661, -0.0321910695742469, 0.0321910695742468, 0.999947758503179, -0.00259457124676546, -0.006745885241587, -0.0013118835870674, 0.138748425090248, -0.345681325192261, -0.000903475278483392, 0.151184975864853, -0.358227947918666, -0.000896140095625969, 0.147770769059702, -0.354871477867884, -0.00114777435393854, 0.173602465164251, -0.378765536799718, -0.00120795166706622, 0.214831416406957, -0.410703566802515, -0.00139185834612791, 0.122433312766354, -0.327782640513123, -0.00127080900255349, 0.184140620360657, -0.387596745778816, -0.00123814735894241, 0.21006198499474, -0.407350481092054, -0.00115570987192407, 0.196781639012774, -0.397564195941878, -0.00106400147389197, 0.207318901950479, -0.405384561552842, -0.000829344110491764, 0.203000309817415, -0.402231893588506, -0.000688792506748533, 0.157606764246543, -0.364371236069974, -0.000786088000160243, 0.244176387845927, -0.429597092087573, -0.00125214214514046, 0.201759382472957, -0.401311557517518, -0.00191759993645823, 0.189814026846399, -0.392149187005707, -0.00282586497589704, 0.159305169670633, -0.365949514378666, -0.00349306924843624, 0.173889122744829, -0.378998013455332, -0.00393070891026528, 0.217788926857211, -0.412724435577854, -0.0212608113487506, 0.000452357688250284, -0.00036188615058233, -0.0151150534926454, 0.000228521327097438, 6.52918077527545e-05, -0.0331918414882689, 0.00110332991097693, -0.000643609114746404, 0.0773006134969334, 0.00613496932514866, -0.0110429447852694, -0.0321910695742469, 0.0010384215991718, -0.00103842159917336, -0.00259457124676546, 6.73215168555691e-06, 1.75035942027152e-05, -0.000526551904329415, -0.345681325192261, 0.861253573209199, -0.000381296378838388, -0.358227947918666, 0.848815985790579, -0.000373156128147092, -0.354871477867884, 0.852230173253752, -0.000526063245555164, -0.378765536799718, 0.826399128966796, -0.000631851641234638, -0.410703566802515, 0.785170441980223, -0.000519877304541034, -0.327782640513123, 0.877568894780586, -0.00060373324887666, -0.387596745778816, 0.815861359092619, -0.000638480377887232, -0.407350481092054, 0.789939955675102, -0.000572034814304861, -0.397564195941878, 0.803220023879128, -0.00054414035107764, -0.405384561552842, 0.792682526239419, -0.000418555560445895, -0.402231893588506, 0.797000553183741, -0.00029793232712181, -0.364371236069974, 0.842393798952562, -0.000446798847724984, -0.429597092087573, 0.755824429718295, -0.000629508325517675, -0.401311557517518, 0.798242581671585, -0.000928163756226527, -0.392149187005707, 0.810190511851676, -0.00123008240127283, -0.365949514378666, 0.840704329035169, -0.00160252859811979, -0.378998013455332, 0.826125647104002, -0.00207399213858218, -0.412724435577854, 0.782230825448871, 0.0170086490790013, -0.00036188615058233, 0.00028950892043616, -0.00431858671218418, 6.52918077527545e-05, 1.86548021961656e-05, 0.0193619075348229, -0.000643609114746404, 0.000375438650284673, -0.139141104294479, -0.0110429447852694, 0.0198773006134874, 0.0321910695742468, -0.00103842159917336, 0.00103842159917592, -0.006745885241587, 1.75035942027152e-05, 4.55093454284494e-05));`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators107() {
        // FIXME FastR output ignores .Tsp attribute of structure()
        assertEval(Ignored.OutputFormatting, "argv <- list(structure(0:100, .Tsp = c(1, 101, 1), class = 'ts'), 0);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators108() {
        // FIXME FastR output ignores .Tsp attribute of structure()
        assertEval(Ignored.OutputFormatting,
                        "argv <- list(structure(c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 210, 220, 230, 240, 250, 260, 270, 280, 290, 300, 310, 320, 330, 340, 350, 360, 370, 380, 390, 400, 410, 420, 430, 440, 450, 460, 470, 480, 490, 500, 510, 520, 530, 540, 550, 560, 570, 580, 590, 600, 610, 620, 630, 640, 650, 660, 670, 680, 690, 700, 710, 720, 730, 740, 750, 760, 770, 780, 790, 800, 810, 820, 830, 840, 850, 860, 870, 880, 890, 900, 910, 920, 930, 940, 950, 960, 970, 980, 990, 1000, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96), .Dim = c(101L, 3L), .Dimnames = list(NULL, c('t1', '10 * t1', 't1 - 4')), .Tsp = c(1, 101, 1), class = c('mts', 'ts', 'matrix')), 0);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators109() {
        // FIXME FastR output ignores .Tsp attribute of structure()
        assertEval(Ignored.OutputFormatting,
                        "argv <- list(structure(c(112, 118, 132, 129, 121, 135, 148, 148, 136, 119, 104, 118, 115, 126, 141, 135, 125, 149, 170, 170, 158, 133, 114, 140, 145, 150, 178, 163, 172, 178, 199, 199, 184, 162, 146, 166, 171, 180, 193, 181, 183, 218, 230, 242, 209, 191, 172, 194, 196, 196, 236, 235, 229, 243, 264, 272, 237, 211, 180, 201, 204, 188, 235, 227, 234, 264, 302, 293, 259, 229, 203, 229, 242, 233, 267, 269, 270, 315, 364, 347, 312, 274, 237, 278, 284, 277, 317, 313, 318, 374, 413, 405, 355, 306, 271, 306, 315, 301, 356, 348, 355, 422, 465, 467, 404, 347, 305, 336, 340, 318, 362, 348, 363, 435, 491, 505, 404, 359, 310, 337, 360, 342, 406, 396, 420, 472, 548, 559, 463, 407, 362, 405, 417, 391, 419, 461, 472, 535, 622, 606, 508, 461, 390, 432, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 419.147602949539, 391.474665943444, 435.919286153217, 443.935203034261, 455.023399013445, 517.28707821144, 589.71337277669, 582.999919227301, 484.573388713116, 428.878182738437, 368.526582998452, 406.728709993152, 415.660571294428, 388.716535970235, 433.006017658935, 440.885684396326, 451.651900136866, 513.051252429496, 584.327164324967, 577.055407135124, 479.076505013118, 423.494870357491, 363.43932958967, 400.592058645117, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 484.030717075782, 462.954959541421, 526.353307750503, 546.165638262644, 569.502470928676, 657.838443307596, 761.241730163307, 763.280655335144, 642.989004951864, 576.423799567567, 501.429012064338, 559.981301364233, 591.700754553767, 565.210772316967, 642.377841008703, 666.682421047093, 695.547100430962, 804.065022775202, 931.340589597203, 934.837830059897, 788.422986194072, 707.666678543854, 616.37838266375, 689.250456425465), .Dim = c(168L, 3L), .Dimnames = list(NULL, c('structure(c(112, 118, 132, 129, 121, 135, 148, 148, 136, 119, ', 'structure(c(419.147602949539, 391.474665943444, 435.919286153217, ', 'structure(c(484.030717075782, 462.954959541421, 526.353307750503, ')), .Tsp = c(1949, 1962.91666666667, 12), class = c('mts', 'ts', 'matrix')), 0);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators110() {
        assertEval("argv <- list(structure(list(Fertility = c(80.2, 83.1, 92.5, 85.8, 76.9), Agriculture = c(17, 45.1, 39.7, 36.5, 43.5), Examination = c(15L, 6L, 5L, 12L, 17L), Education = c(12L, 9L, 5L, 7L, 15L)), .Names = c('Fertility', 'Agriculture', 'Examination', 'Education'), row.names = c('Courtelary', 'Delemont', 'Franches-Mnt', 'Moutier', 'Neuveville'), class = 'data.frame'), 6);`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators111() {
        assertEval("argv <- list(c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, NA, 2L, 2L, 0L, NA, 1L, 1L), c(0, 0, 0, 0, 0, 0, 0, 0, 1, NA, 2, 2, 0, NA, 1, 1));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators112() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'));`!`(argv[[1]]);");
    }

    @Test
    public void testoperators113() {
        assertEval("argv <- list(structure(c(2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Label = c('fm2', 'original'), class = c('ordered', 'factor')), 'original');`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators114() {
        assertEval("argv <- list(structure(c(1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0), .Dim = 12L), 0);`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators115() {
        assertEval("argv <- list(c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 124, 125, 126, 127, 160, 160, 164, 167, 168, 173, 173, 176, 180, 184, 193, 194, 196, 199, 201, 203, 205, 206, 211, 212, 214, 215, 218, 220, 221, 223, 225, 226, 228, 231, 233, 235, 237, 238, 243, 244, 246, 247, 250, 252, 253, 258, 259, 260, 261, 262, 263, 268, 269, 270, 271, 272, 272, 273, 273, 280, 281, 282, 283, 313, 314, 317, 318, 321, 322, 323, 324, 327, 328, 336, 336, 337, 337, 340, 341, 344, 345, 346, 347, 350, 351, 352, 353, 354, 354, 355, 355, 356, 357, 366, 367, 368, 368, 369, 369, 377, 378, 379, 379, 380, 380, 381, 382, 711, 728, 729, 731, 733), structure(231L, .Names = 'e7', class = c('noquote', 'hexmode')));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators116() {
        assertEval("argv <- list(structure(c(1L, 2L, 3L, 1L, 2L, 3L, 1L, 2L, 3L, 1L, 2L, 3L), .Dim = 3:4), structure(c(1L, 1L, 1L, 2L, 2L, 2L, 3L, 3L, 3L, 4L, 4L, 4L), .Dim = 3:4));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators117() {
        assertEval("argv <- list(structure(c(9L, 4L, 6L, 5L, 3L, 10L, 5L, 3L, 5L), .Dim = 9L, .Dimnames = structure(list(x = c('0', '1', '2', '3', '4', '5', '6', '7', '8')), .Names = 'x'), class = 'table'), c(9, 4, 6, 5, 3, 10, 5, 3, 5));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators118() {
        assertEval("argv <- list(structure(c('white', 'aquamarine3', 'bisque2', 'blueviolet', 'burlywood4', 'chartreuse4', 'coral4', 'cyan3', 'darkgreen', 'darkorange1', 'aliceblue', 'white', 'white', 'white', 'white', 'chocolate', 'cornflowerblue', 'cyan4', 'darkgrey', 'darkorange2', 'antiquewhite', 'white', 'white', 'white', 'white', 'chocolate1', 'cornsilk', 'darkblue', 'darkkhaki', 'darkorange3', 'antiquewhite1', 'white', 'white', 'white', 'white', 'chocolate2', 'cornsilk1', 'darkcyan', 'darkmagenta', 'darkorange4', 'antiquewhite2', 'azure2', 'blanchedalmond', 'brown3', 'cadetblue3', 'chocolate3', 'cornsilk2', 'darkgoldenrod', 'darkolivegreen', 'darkorchid', 'antiquewhite3', 'azure3', 'blue', 'brown4', 'cadetblue4', 'chocolate4', 'cornsilk3', 'darkgoldenrod1', 'darkolivegreen1', 'darkorchid1', 'antiquewhite4', 'azure4', 'blue1', 'burlywood', 'chartreuse', 'coral', 'cornsilk4', 'darkgoldenrod2', 'darkolivegreen2', 'darkorchid2', 'aquamarine', 'beige', 'blue2', 'burlywood1', 'chartreuse1', 'coral1', 'cyan', 'darkgoldenrod3', 'darkolivegreen3', 'darkorchid3', 'aquamarine1', 'bisque', 'blue3', 'burlywood2', 'chartreuse2', 'coral2', 'cyan1', 'darkgoldenrod4', 'darkolivegreen4', 'darkorchid4', 'aquamarine2', 'bisque1', 'blue4', 'burlywood3', 'chartreuse3', 'coral3', 'cyan2', 'darkgray', 'darkorange', 'darkred'), .Dim = c(10L, 10L), class = 'raster'), 'white');`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators119() {
        assertEval("argv <- list(c(0, 7.93839803127729e-06, 7.93839803127729e-06, 1.58767960625546e-05, 2.38151940938319e-05, 3.96919901563864e-05, 5.5568786218941e-05, 8.73223783440502e-05, 0.000119075970469159, 0.0001746447566881, 0.000230213542907041, 0.000317535921251092, 0.000412796697626419, 0.00055568786218941, 0.000698579026752401, 0.000904977375565611, 0.00112725252044137, 0.00142097324759863, 0.00173057077081845, 0.00213542907041359, 0.00255616416607129, 0.00308803683416687, 0.00364372469635628, 0.00431848852901484, 0.00501706755576725, 0.00585853774708264, 0.00670000793839803, 0.00769230769230769, 0.00869254584424863, 0.00983567516075256, 0.0109629276811939, 0.0122410097642296, 0.0134714614590776, 0.0148448043184885, 0.016146701595618, 0.0175597364451854, 0.0188775105183774, 0.020298483765976, 0.0215606890529491, 0.022902278320235, 0.0240692228308327, 0.0252758593315869, 0.0262602206874653, 0.0272763356354688, 0.0280304834484401, 0.0287925696594427, 0.0292768119393506, 0.0297372390251647, 0.0299118837818528, 0.0300706517424784, 0.0299118837818528, 0.0297372390251647, 0.0292768119393506, 0.0287925696594427, 0.0280304834484401, 0.0272763356354688, 0.0262602206874653, 0.0252758593315869, 0.0240692228308327, 0.022902278320235, 0.0215606890529491, 0.020298483765976, 0.0188775105183774, 0.0175597364451854, 0.016146701595618, 0.0148448043184885, 0.0134714614590776, 0.0122410097642296, 0.0109629276811939, 0.00983567516075256, 0.00869254584424863, 0.00769230769230769, 0.00670000793839803, 0.00585853774708264, 0.00501706755576725, 0.00431848852901484, 0.00364372469635628, 0.00308803683416687, 0.00255616416607129, 0.00213542907041359, 0.00173057077081845, 0.00142097324759863, 0.00112725252044137, 0.000904977375565611, 0.000698579026752401, 0.00055568786218941, 0.000412796697626419, 0.000317535921251092, 0.000230213542907041, 0.0001746447566881, 0.000119075970469159, 8.73223783440502e-05, 5.5568786218941e-05, 3.96919901563864e-05, 2.38151940938319e-05, 1.58767960625546e-05, 7.93839803127729e-06, 7.93839803127729e-06, 0), c(0, 7.93839803127729e-06, 7.93839803127729e-06, 1.58767960625546e-05, 2.38151940938319e-05, 3.96919901563864e-05, 5.5568786218941e-05, 8.73223783440502e-05, 0.000119075970469159, 0.0001746447566881, 0.000230213542907041, 0.000317535921251092, 0.000412796697626419, 0.00055568786218941, 0.000698579026752401, 0.000904977375565611, 0.00112725252044137, 0.00142097324759863, 0.00173057077081845, 0.00213542907041359, 0.00255616416607129, 0.00308803683416687, 0.00364372469635628, 0.00431848852901484, 0.00501706755576725, 0.00585853774708264, 0.00670000793839803, 0.00769230769230769, 0.00869254584424863, 0.00983567516075256, 0.0109629276811939, 0.0122410097642296, 0.0134714614590776, 0.0148448043184885, 0.016146701595618, 0.0175597364451854, 0.0188775105183774, 0.020298483765976, 0.0215606890529491, 0.022902278320235, 0.0240692228308327, 0.0252758593315869, 0.0262602206874653, 0.0272763356354688, 0.0280304834484401, 0.0287925696594427, 0.0292768119393506, 0.0297372390251647, 0.0299118837818528, 0.0300706517424784, 0.0299118837818528, 0.0297372390251647, 0.0292768119393506, 0.0287925696594427, 0.0280304834484401, 0.0272763356354688, 0.0262602206874653, 0.0252758593315869, 0.0240692228308327, 0.022902278320235, 0.0215606890529491, 0.020298483765976, 0.0188775105183774, 0.0175597364451854, 0.016146701595618, 0.0148448043184885, 0.0134714614590776, 0.0122410097642296, 0.0109629276811939, 0.00983567516075256, 0.00869254584424863, 0.00769230769230769, 0.00670000793839803, 0.00585853774708264, 0.00501706755576725, 0.00431848852901484, 0.00364372469635628, 0.00308803683416687, 0.00255616416607129, 0.00213542907041359, 0.00173057077081845, 0.00142097324759863, 0.00112725252044137, 0.000904977375565611, 0.000698579026752401, 0.00055568786218941, 0.000412796697626419, 0.000317535921251092, 0.000230213542907041, 0.0001746447566881, 0.000119075970469159, 8.73223783440502e-05, 5.5568786218941e-05, 3.96919901563864e-05, 2.38151940938319e-05, 1.58767960625546e-05, 7.93839803127729e-06, 7.93839803127729e-06, 0));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators120() {
        // FIXME FastR output ignores .Tsp attribute of structure()
        assertEval(Ignored.OutputFormatting,
                        "argv <- list(structure(c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12), .Tsp = c(1959, 1997.91666666667, 12), class = 'ts'), 10L);`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators121() {
        assertEval("argv <- list(structure(c(0.86317353889998+0i, -3.79913366221062+3.31244294914647i, 1.55614767167993-1.74174276171448i, -2.23430861671215-1.65262168622253i, -2.23430861671215+1.65262168622253i, 1.55614767167993+1.74174276171448i, -3.79913366221062-3.31244294914647i, -3.33827801689622+0i, -0.24558402446046-1.38976239274682i, 0.38994543428825+2.49010387459687i, 1.4081214006546+1.81482300583077i, 1.4081214006546-1.81482300583077i, 0.38994543428825-2.49010387459687i, -0.24558402446046+1.38976239274682i, -2.31885928035568+0i, -4.19304293056817-0.22777444729915i, 0.98896416070392-1.81216964948694i, 1.39179443748361-4.40983340277928i, 1.39179443748361+4.40983340277928i, 0.98896416070392+1.81216964948694i, -4.19304293056817+0.22777444729915i, -1.0554525205105+0i, -0.26365333042432+1.4074399019829i, 0.40560122186879+3.13070845018955i, -1.20041403617116-3.43234427504359i, -1.20041403617116+3.43234427504359i, 0.40560122186879-3.13070845018955i, -0.26365333042432-1.4074399019829i, 0.0498590799965546+0i, 1.83744919383128-0.49050274510365i, -0.24547773966823+4.86316579489277i, -0.99323533469825+1.90306050881202i, -0.99323533469825-1.90306050881202i, -0.24547773966823-4.86316579489277i, 1.83744919383128+0.49050274510365i), .Dim = c(7L, 5L)), structure(c(0.86317353889998+0i, -3.79913366221062+3.31244294914647i, 1.55614767167993-1.74174276171448i, -2.23430861671215-1.65262168622253i, -2.23430861671215+1.65262168622253i, 1.55614767167993+1.74174276171448i, -3.79913366221062-3.31244294914647i, -3.33827801689622+0i, -0.24558402446046-1.38976239274682i, 0.38994543428825+2.49010387459687i, 1.4081214006546+1.81482300583077i, 1.4081214006546-1.81482300583077i, 0.38994543428825-2.49010387459687i, -0.24558402446046+1.38976239274682i, -2.31885928035568+0i, -4.19304293056817-0.22777444729915i, 0.98896416070392-1.81216964948694i, 1.39179443748361-4.40983340277928i, 1.39179443748361+4.40983340277928i, 0.98896416070392+1.81216964948694i, -4.19304293056817+0.22777444729915i, -1.0554525205105+0i, -0.26365333042432+1.4074399019829i, 0.40560122186879+3.13070845018955i, -1.20041403617116-3.43234427504359i, -1.20041403617116+3.43234427504359i, 0.40560122186879-3.13070845018955i, -0.26365333042432-1.4074399019829i, 0.0498590799965546+0i, 1.83744919383128-0.49050274510365i, -0.24547773966823+4.86316579489277i, -0.99323533469825+1.90306050881202i, -0.99323533469825-1.90306050881202i, -0.24547773966823-4.86316579489277i, 1.83744919383128+0.49050274510365i), .Dim = c(7L, 5L)));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators122() {
        assertEval("argv <- list(c(1.22408179743946+0i, 0.359813827057364+0i, 0.400771450594052+0i, 0.11068271594512+0i, -0.555841134754075+0i), structure(c(1.22408179743946+0i, 0.359813827057364+0i, 0.400771450594052+0i, 0.11068271594512+0i, -0.555841134754075+0i), .Dim = c(1L, 5L)));`==`(argv[[1]],argv[[2]]);");

        // comparison between factors does not preserve the names attribute
        assertEval("argv <- list(structure(c(1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 1L, 2L), .Label = c('0-9g/day', '10-19', '20-29', '30+'), class = c('ordered', 'factor'), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '40', '41', '42', '43', '44', '45', '46', '47', '48', '49', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '60', '61', '62', '63', '64', '65', '66', '67', '68', '69', '70', '71', '72', '73', '74', '75', '76', '77', '78', '79', '80', '81', '82', '83', '84', '85', '86', '87', '88')), structure(c(1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 1L, 2L, 3L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 4L, 1L, 2L, 3L, 4L, 1L, 2L, 1L, 2L), .Label = c('0-9g/day', '10-19', '20-29', '30+'), class = c('ordered', 'factor')));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators124() {
        assertEval("argv <- list(16L, 8);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators125() {
        assertEval("argv <- list('«Latin-1 accented chars»: ghè øØ å<Å æ<Æ gh ghè', '«Latin-1 accented chars»: ghè øØ å<Å æ<Æ gh ghè');`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators126() {
        assertEval("argv <- list(structure(list(cde = 2L, cd = 4L), .Names = c('cde', 'cd'), row.names = 'ab', class = 'data.frame'), c(2, 4));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators127() {
        assertEval("argv <- list(1, structure(c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Names = c('is.array', 'is.atomic', 'is.call', 'is.character', 'is.complex', 'is.data.frame', 'is.double', 'is.environment', 'is.expression', 'is.factor', 'is.finite', 'is.function', 'is.infinite', 'is.integer', 'is.language', 'is.list', 'is.logical', 'is.matrix', 'is.na', 'is.name', 'is.nan', 'is.null', 'is.numeric', 'is.numeric_version', 'is.object', 'is.ordered', 'is.package_version', 'is.pairlist', 'is.primitive', 'is.qr', 'is.raw', 'is.recursive', 'is.symbol', 'is.table', 'is.vector')));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators128() {
        assertEval("argv <- list(c(30000L, 100000L), c(30000, 1e+05));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators129() {
        assertEval("argv <- list(2L, e2 = 2);`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators130() {
        assertEval("argv <- list(2, structure(list(2L), class = structure('L', package = '.GlobalEnv')));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators131() {
        assertEval("argv <- list(structure(integer(0), .Label = character(0), class = 'factor'), 1L);`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators132() {
        assertEval("argv <- list(NULL, NULL);`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators133() {
        assertEval("argv <- list(structure(c(2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2), .Dim = 5:6), structure(c(2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L), .Dim = 5:6, .Dimnames = structure(list(blocks = c('1', '2', '3', '4', '5'), varieties = c('1', '2', '3', '4', '5', '6')), .Names = c('blocks', 'varieties')), class = 'table'));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators134() {
        assertEval("argv <- list(FALSE, 'Sweave');`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators135() {
        assertEval("argv <- list(1, 26);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators136() {
        assertEval("argv <- list(NULL, NULL);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators137() {
        // FIXME FastR output ignores .Tsp attribute of structure()
        assertEval(Ignored.OutputFormatting, "argv <- list(structure(c(2, 1, 0, 1, 2), .Tsp = c(-1, 3, 1), class = 'ts'), 1e-05);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators138() {
        assertEval("argv <- list(structure(NA_real_, class = c('POSIXct', 'POSIXt')), structure(1386394754, class = c('POSIXct', 'POSIXt')));`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators139() {
        assertEval("argv <- list(structure(c(-0.626453810742332, 0.183643324222082, -0.835628612410047, 1.59528080213779, 0.329507771815361, -0.820468384118015, 0.487429052428485, 0.738324705129217, 0.575781351653492, -0.305388387156356, 1.51178116845085, 0.389843236411431, -0.621240580541804, -2.2146998871775, 1.12493091814311, -0.0449336090152309, -0.0161902630989461, 0.943836210685299, 0.821221195098089, 0.593901321217509, 0.918977371608218, 0.782136300731067, 0.0745649833651906, -1.98935169586337, 0.61982574789471, -0.0561287395290008, -0.155795506705329, -1.47075238389927), .Dim = c(4L, 7L)), 0);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators140() {
        assertEval("argv <- list(structure(c(24L, 13L, 15L, 68L, 39L, 74L, 22L, 1L, 8L, 55L, 24L, 20L, 51L, 13L, 3L, 4L, 5L, 6L, 15L, 2L, 8L, 60L, 67L, 23L, 58L, 24L, 22L, 21L, 37L, 74L, 59L, 39L, 14L, 14L, 19L, 23L, 70L, 21L, 22L, 31L, 29L, 30L, 45L, 58L, 17L, 7L, 19L, 26L, 39L, 74L, 57L, 59L, 12L, 72L, 70L, 37L, 64L, 16L, 18L, 21L, 22L, 8L, 62L, 61L, 63L, 71L, 105L, 64L, 10L, 41L, 8L, 27L, 11L, 34L, 32L, 33L, 68L, 107L, NA, 66L, NA, 65L, 48L, 52L, 43L, 47L, 46L, 44L, 41L, 54L, 28L, 50L, 40L, NA, 69L, NA, 75L, 109L, NA, 86L, 112L, 110L, 104L, 24L, 111L, 87L, NA, NA, 92L, 73L, 85L, 90L, 89L, NA, 83L, NA, 102L, NA, 108L, 88L, 91L, 93L, NA, 94L, 84L, NA, 106L, NA, 95L, 82L, 56L, 87L, 109L, 75L, 104L, 110L, 112L, 111L, 24L, 73L, 85L, 86L, 90L, 89L, 102L, 88L, 92L, 9L, 49L, 42L, 38L, 35L, 36L, 25L, NA, NA, 9L, 49L, 42L, NA, 36L, 38L, 25L, 53L, 79L, 78L, 103L, 77L, 80L, 114L, 97L, 113L, 76L, 96L, 81L, 116L, 99L, 117L, 115L, 98L, 101L, 100L), .Label = c('1008', '1011', '1013', '1014', '1015', '1016', '1027', '1028', '1030', '1032', '1051', '1052', '1083', '1093', '1095', '1096', '110', '1102', '111', '1117', '112', '113', '116', '117', '1219', '125', '1250', '1251', '126', '127', '128', '1291', '1292', '1293', '1298', '1299', '130', '1308', '135', '1376', '1377', '1383', '1408', '1409', '141', '1410', '1411', '1413', '1418', '1422', '1438', '1445', '1456', '1492', '2001', '2316', '262', '266', '269', '270', '2708', '2714', '2715', '272', '2728', '2734', '280', '283', '286', '290', '3501', '411', '412', '475', '5028', '5042', '5043', '5044', '5045', '5047', '5049', '5050', '5051', '5052', '5053', '5054', '5055', '5056', '5057', '5058', '5059', '5060', '5061', '5062', '5066', '5067', '5068', '5069', '5070', '5072', '5073', '5115', '5160', '5165', '655', '724', '885', '931', '942', '952', '955', '958', 'c118', 'c168', 'c203', 'c204', 'c266')), 20);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators141() {
        assertEval("argv <- list(structure(c(2, 2, 1, 1, 1, 0, 1, 2, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0), .Dim = 18L, .Dimnames = list(c('5', '8', '9', '12', '13', '16', '18', '23', '27', '28', '30', '31', '33', '34', '43', '45', '48', '161'))), 0);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators142() {
        assertEval("argv <- list(structure(list(c(3L, 0L, 1L)), class = c('R_system_version', 'package_version', 'numeric_version')), structure('2.13.2', .Names = 'SweaveListingUtils'));`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators143() {
        assertEval("argv <- list(c(8262, 2889), 1e+05);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators144() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'));`>`(argv[[1]]);");
    }

    @Test
    public void testoperators145() {
        assertEval("argv <- list(c(1, 2, 3, NA, -1, 0, 1, NA), 0);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators146() {
        assertEval("argv <- list(10, 16L);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators147() {
        // FIXME FastR output ignores .Tsp in structure()
        assertEval(Ignored.OutputFormatting, "argv <- list(structure(0, .Tsp = c(1, 1, 1), class = 'ts'), 1e-05);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators148() {
        assertEval("argv <- list(FALSE, FALSE);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators149() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'));`>=`(argv[[1]]);");
    }

    @Test
    public void testoperators150() {
        assertEval("argv <- list(NULL, NULL);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators151() {
        assertEval("argv <- list(structure(c(1L, 1L, 1L, 1L, 6L, 2L, 4L, 3L, 7L, 2L, 8L, 4L, 2L, 2L, 1L, 3L, 3L, 4L, 3L, 2L, 1L, 2L, 3L, 1L, 1L, 2L, 1L, 3L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 2L, 4L, 1L, 1L, 1L, 1L, 2L, 1L, 5L, 2L, 1L, 3L, 2L, 2L, 6L, 2L, 1L, 2L, 5L, 2L, 2L, 2L, 4L, 4L, 1L, 1L, 3L, 4L, 2L, 2L, 2L, 1L, 5L, 4L, 4L, 1L, 1L, 4L, 2L, 3L, 2L, 1L, 8L, 1L, 5L, 1L, 3L, 4L, 4L, 1L, 3L, 1L, 2L, 6L, 1L, 1L, 1L, 1L, 1L, 6L, 2L, 2L, 1L, 1L, 2L, 3L, 1L, 1L, 1L, 1L), .Dim = 124L, .Dimnames = structure(list(ne60 = c('96', '100', '102', '104', '105', '107', '108', '109', '110', '111', '112', '113', '115', '116', '117', '118', '119', '120', '121', '122', '124', '125', '126', '128', '129', '130', '131', '132', '133', '134', '135', '136', '137', '138', '139', '140', '141', '142', '143', '144', '145', '149', '157', '158', '168', '173', '174', '184', '199', '200', '202', '205', '207', '210', '214', '216', '221', '223', '224', '225', '226', '229', '230', '231', '233', '235', '237', '238', '240', '242', '243', '244', '245', '246', '247', '248', '249', '250', '251', '252', '254', '255', '256', '257', '258', '259', '260', '261', '262', '263', '264', '265', '266', '267', '268', '269', '270', '271', '272', '273', '274', '275', '276', '277', '278', '279', '280', '282', '283', '284', '285', '286', '287', '288', '289', '290', '291', '293', '294', '296', '300', '302', '304', '306')), .Names = 'ne60'), class = 'table'), 4);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators152() {
        assertEval("argv <- list(structure(3.00390625, base = 16, lens = 3L, .classes = c('R_system_version', 'package_version', 'numeric_version')), structure(2.9375, base = 16, lens = 3L, .classes = c('package_version', 'numeric_version')));`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators153() {
        assertEval("argv <- list(structure(list(2L), class = 'numeric_version'), '2');`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators154() {
        assertEval("argv <- list('3.0.1', '2.3.0');`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators155() {
        assertEval("argv <- list(c(30L, 30L, 60L, 60L, 60L, 60L, 60L, 60L, 30L, 30L, 60L, 60L, 60L, NA, 30L, 30L, 30L, 30L, 60L, 60L, 60L, 60L, 60L, 60L, 30L, 30L, 60L, 60L, 60L, 60L, 30L, 30L, 30L, NA, 30L, 30L, 60L, 60L, 30L, 30L, 30L, 30L, 30L, 60L, 60L, 30L, 30L, 30L, 30L, 60L, NA, 60L, NA, 30L, 60L, 60L, 30L, NA, 30L, 30L, 60L, NA, 30L, 30L, 30L, 30L, 30L, NA, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, 30L, NA, 18L, 18L, 30L, 30L, 30L, 30L, 18L, 18L, 30L, 30L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, NA, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, NA, 18L, 18L, 30L, 30L, 18L, 18L, 30L, 30L, 18L, 18L, 30L, 30L, 30L, 30L, NA, 18L, NA, 30L, 30L, NA, 18L, 18L, 30L, 30L, 7L, 7L, 18L, 18L, 30L, 30L, 30L, 30L, NA, 30L, 18L, 18L, 30L, 30L, 18L, 18L, 7L, 7L, 30L, 30L, 18L, 18L, NA, 30L, 7L, 7L, 7L, NA, 18L, 18L, 7L, 7L, 18L, NA, 30L, 30L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 18L, 18L), 30);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators156() {
        assertEval("argv <- list(structure(c(0L, 1L, 1L, 3L), .Names = c('1', '2', '3', '4')), 0:3);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators157() {
        assertEval(Output.IgnoreWarningContext,
                        "argv <- list(structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = 'data.frame'), structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = 'data.frame'));`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators158() {
        assertEval("argv <- list(c(1.67451869393188, 0.668927329809365, 0.0791361259651342, 0.543924729050942, 0.00967644138302005, 0.464139419264689, 1.12629957234273), 1e-30);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators159() {
        assertEval("argv <- list(c(2.00256647265648e-308, 2.22284878464869e-308, 2.22507363599982e-308, 2.2250738585072e-308, 2.22507408101459e-308, 2.22729893236571e-308, 2.44758124435792e-308, 1.61792382137608e+308, 1.79589544172745e+308, 1.797692955093e+308, 1.79769313486232e+308), 1);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators160() {
        assertEval("argv <- list(structure(c(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1), .Dim = c(4L, 4L)), 0);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators161() {
        assertEval("argv <- list(structure(c(-0.626453810742332, 0.183643324222082, -0.835628612410047, 1.59528080213779, 0.329507771815361, -0.820468384118015, 0.487429052428485, 0.738324705129217, 0.575781351653492, -0.305388387156356, 1.51178116845085, 0.389843236411431, -0.621240580541804, -2.2146998871775, 1.12493091814311, -0.0449336090152309, -0.0161902630989461, 0.943836210685299, 0.821221195098089, 0.593901321217509, 0.918977371608218, 0.782136300731067, 0.0745649833651906, -1.98935169586337, 0.61982574789471, -0.0561287395290008, -0.155795506705329, -1.47075238389927, -0.47815005510862, 0.417941560199702, 1.35867955152904, -0.102787727342996, 0.387671611559369, -0.0538050405829051, -1.37705955682861, -0.41499456329968, -0.394289953710349, -0.0593133967111857, 1.10002537198388, 0.763175748457544, -0.164523596253587, -0.253361680136508, 0.696963375404737, 0.556663198673657, -0.68875569454952, -0.70749515696212, 0.36458196213683, 0.768532924515416, -0.112346212150228, 0.881107726454215), .Label = structure(list(c(-2.21578569960353, -0.304302574730325), c(-0.689841506975551, -0.0550429271029698), c(-0.254447492562539, 0.3887574239854), c(-0.0548908530089361, 0.620911560320741), c(0.3887574239854, 0.882193538880246), c(0.695877562978706, 1.59636661456382)), class = 'shingleLevel'), class = 'shingle'), -0.254447492562539);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators162() {
        assertEval("argv <- list(c(1, 2, 3, 4, 5, 6, 7, NA, 9, 10, 11, 12), 1);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators163() {
        assertEval("argv <- list(structure(c(18000, 315550800, 631170000, 946702800, 1262322000, 1577854800), class = c('POSIXct', 'POSIXt'), tzone = ''), 28304640);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators164() {
        assertEval("argv <- list(c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE));`!`(argv[[1]]);");
    }

    @Test
    public void testoperators165() {
        assertEval("argv <- list(structure(c(FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE), .Names = c(' 100', '-1e-13', ' Inf', '-Inf', ' NaN', '3.14', '  NA')));`!`(argv[[1]]);");
    }

    @Test
    public void testoperators166() {
        assertEval("argv <- list(structure(c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE), .Dim = c(5L, 2L), .Dimnames = list(NULL, c('VAR1', 'VAR3'))));`!`(argv[[1]]);");
    }

    @Test
    public void testoperators167() {
        assertEval("argv <- list(structure(c(FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, TRUE), .Names = c(' 100', '-1e-13', ' Inf', '-Inf', ' NaN', '3.14', '  NA')), structure(c(TRUE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE), .Names = c(' 100', '-1e-13', ' Inf', '-Inf', ' NaN', '3.14', '  NA')));`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators168() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'));`%%`(argv[[1]]);");
    }

    @Test
    public void testoperators169() {
        assertEval("argv <- list(structure(1:3, .Label = c('1', '2', NA), class = 'factor'), structure(1:3, .Label = c('1', '2', NA), class = 'factor'));`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators170() {
        assertEval("argv <- list(429204532L, 2L);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators171() {
        assertEval("argv <- list(structure(c(1960.08433333333, 1960.16766666667, 1960.251, 1960.33433333333, 1960.41766666667, 1960.501, 1960.58433333333, 1960.66766666667, 1960.751, 1960.83433333333, 1960.91766666667, 1961.001, 1961.08433333333, 1961.16766666667, 1961.251, 1961.33433333333, 1961.41766666667, 1961.501, 1961.58433333333, 1961.66766666667), .Tsp = c(1960.08333333333, 1961.66666666667, 12), class = 'ts'), 1);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators172() {
        assertEval("argv <- list(c(-1, 0, 0, 0, 0, 0, 1, 1, 1), 2L);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators173() {
        assertEval("argv <- list(-65205377L, 1073741824L);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators174() {
        assertEval("argv <- list(160L, 16);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators175() {
        assertEval("argv <- list(structure(c(52L, 52L, 1L, 1L), .Names = c('y', 'x', 'Ta', 'Tb')), 52L);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators176() {
        assertEval("argv <- list(1, 2);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators177() {
        assertEval("argv <- list(c(0, 1, 1, 2, 2, 3, 3, 4, 4), 2L);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators178() {
        assertEval("argv <- list(structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0), .Dim = c(12L, 4L), .Dimnames = list(c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23'), c('(Intercept)', 'M.userY', 'TempLow', 'M.userY:TempLow')), assign = 0:3, contrasts = structure(list(M.user = 'contr.treatment', Temp = 'contr.treatment'), .Names = c('M.user', 'Temp'))), c(0.262364229584951, -0.851832547542732, 0.0441056253109867, 0.444266588736502));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators179() {
        assertEval("argv <- list(structure(c(1976.001, 1976.08433333333, 1976.16766666667, 1976.251, 1976.33433333333, 1976.41766666667, 1976.501, 1976.58433333333, 1976.66766666667, 1976.751, 1976.83433333333, 1976.91766666667, 1977.001, 1977.08433333333, 1977.16766666667, 1977.251, 1977.33433333333, 1977.41766666667, 1977.501, 1977.58433333333, 1977.66766666667, 1977.751, 1977.83433333333, 1977.91766666667, 1978.001), .Tsp = c(1976, 1978, 12), class = 'ts'), 1);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators180() {
        assertEval("argv <- list(structure(c(1, 0, NA, 1), .Dim = c(2L, 2L)), structure(c(1, 2, 0, 1, 0, 0), .Dim = 2:3));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators181() {
        assertEval("argv <- list(0, NA_real_);`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators182() {
        assertEval("argv <- list(structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.35, 0.64, 0.12, 1.66, 1.52, 0.23, -1.99, 0.42, 1.86, -0.02, -1.64, -0.46, -0.1, 1.25, 0.37, 0.31, 1.11, 1.65, 0.33, 0.89, -0.25, -0.87, -0.22, 0.71, -2.26, 0.77, -0.05, 0.32, -0.64, 0.39, 0.19, -1.62, 0.37, 0.02, 0.97, -2.62, 0.15, 1.55, -1.41, -2.35, -0.43, 0.57, -0.66, -0.08, 0.02, 0.24, -0.33, -0.03, -1.13, 0.32, 1.55, 2.13, -0.1, -0.32, -0.67, 1.44, 0.04, -1.1, -0.95, -0.19, -0.68, -0.43, -0.84, 0.69, -0.65, 0.71, 0.19, 0.45, 0.45, -1.19, 1.3, 0.14, -0.36, -0.5, -0.47, -1.31, -1.02, 1.17, 1.51, -0.33, -0.01, -0.59, -0.28, -0.18, -1.07, 0.66, -0.71, 1.88, -0.14, -0.19, 0.84, 0.44, 1.33, -0.2, -0.45, 1.46, 1, -1.02, 0.68, 0.84), .Dim = c(100L, 2L), .Dimnames = list(c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '40', '41', '42', '43', '44', '45', '46', '47', '48', '49', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '60', '61', '62', '63', '64', '65', '66', '67', '68', '69', '70', '71', '72', '73', '74', '75', '76', '77', '78', '79', '80', '81', '82', '83', '84', '85', '86', '87', '88', '89', '90', '91', '92', '93', '94', '95', '96', '97', '98', '99', '100'), c('(Intercept)', 'x')), assign = 0:1), c(1.15937252188199, 0.442508987631707));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators183() {
        assertEval("argv <- list(c(-3, -2, -1, 0, 1, 2, 3, 4, 5), structure(c(-3, -2, -1, 0, 1, 2, 3, 4, 5), .Dim = c(1L, 9L)));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators184() {
        assertEval("argv <- list(c(4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 4000, 8000, 12000, 16000, 20000, 24000, 28000, 32000, 36000, 40000, 44000, 48000), structure(c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24), .Dim = c(1L, 24L)));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators185() {
        // FIXME NullPointerException
        // at com.oracle.truffle.r.nodes.builtin.base.MatMult.left0Dim(MatMult.java:118)
        assertEval(Ignored.ImplementationError,
                        "argv <- list(structure(numeric(0), .Dim = c(10L, 0L), .Dimnames = list(c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10'), NULL)), structure(numeric(0), .Names = character(0)));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators186() {
        assertEval("argv <- list(structure(c(0.553622032575332, 0, 0, 0, 0, 1.83583330034692, 0, 0, 0, 0, 0.540309168173204, 0, 0, 0, 0, 0.347171956892285), .Dim = c(4L, 4L)), structure(c(3.26267089696047, -0.712693854979374, 2.39769041729195, 5.15111718577956, -0.712693854979374, 0.296710908544859, -1.00753262176762, -0.987904999293151, 2.39769041729195, -1.00753262176762, 3.42543180838832, 3.32535677689614, 5.15111718577956, -0.987904999293151, 3.32535677689614, 8.29680198510459), .Dim = c(4L, 4L), .Dimnames = list(c('A', 'B', 'C', 'D'), c('A', 'B', 'C', 'D'))));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators187() {
        assertEval("argv <- list(243L, 16);`%/%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators188() {
        assertEval("argv <- list(4L, 2L);`%/%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators189() {
        assertEval("argv <- list(5, 3);`%/%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators190() {
        assertEval("argv <- list(1:2, 4L);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators191() {
        assertEval("argv <- list(c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE), c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE));`&`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators192() {
        assertEval("argv <- list(structure(c(TRUE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, NA), .Dim = c(5L, 2L), .Dimnames = list(NULL, c('VAR1', 'VAR3'))), structure(c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE), .Dim = c(5L, 2L), .Dimnames = list(NULL, c('VAR1', 'VAR3'))));`&`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators193() {
        assertEval("argv <- list(structure(c(FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE), .Names = c(' 100', '-1e-13', ' Inf', '-Inf', ' NaN', '3.14', '  NA')), structure(c(TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, TRUE), .Names = c(' 100', '-1e-13', ' Inf', '-Inf', ' NaN', '3.14', '  NA')));`&`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators195() {
        assertEval("argv <- list(7);`(`(argv[[1]]);");
    }

    @Test
    public void testoperators196() {
        assertEval("argv <- list(structure(c(2L, 1L, 3L), .Label = c('NA', 'a', 'b'), class = 'factor'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators197() {
        assertEval("argv <- list(structure(list(), .Names = character(0), row.names = integer(0), class = 'data.frame'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators198() {
        assertEval("argv <- list(structure(c(0.500999999999976, 0.584333333333234, 0.667666666666719, 0.750999999999976, 0.834333333333234, 0.917666666666719, 0.000999999999976353, 0.0843333333332339, 0.167666666666719, 0.250999999999976), .Tsp = c(1920.5, 1921.25, 12), class = 'ts'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators200() {
        assertEval("argv <- list(structure(list(coefficients = structure(NA_real_, .Names = 'x'), residuals = structure(c(-0.667819876370237, 0.170711734013213, 0.552921941721332, -0.253162069270378, -0.00786394222146348, 0.0246733498130512, 0.0730305465518564, -1.36919169254062, 0.0881443844426084, -0.0834190388782434), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10')), effects = structure(c(-0.667819876370237, 0.170711734013213, 0.552921941721332, -0.253162069270378, -0.00786394222146348, 0.0246733498130512, 0.0730305465518564, -1.36919169254062, 0.0881443844426084, -0.0834190388782434), .Names = c('', '', '', '', '', '', '', '', '', '')), rank = 0L, fitted.values = structure(c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10')), assign = 1L, qr = structure(list(qr = structure(c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0), .Dim = c(10L, 1L), .Dimnames = list(c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10'), 'x'), assign = 1L), qraux = 0, pivot = 1L, tol = 1e-07, rank = 0L), .Names = c('qr', 'qraux', 'pivot', 'tol', 'rank'), class = 'qr'), df.residual = 10L, xlevels = structure(list(), .Names = character(0)), call = quote(lm(formula = y ~ x + 0)), terms = quote(y ~ x + 0), model = structure(list(y = c(-0.667819876370237, 0.170711734013213, 0.552921941721332, -0.253162069270378, -0.00786394222146348, 0.0246733498130512, 0.0730305465518564, -1.36919169254062, 0.0881443844426084, -0.0834190388782434), x = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0)), .Names = c('y', 'x'), terms = quote(y ~ x + 0), row.names = c(NA, 10L), class = 'data.frame')), .Names = c('coefficients', 'residuals', 'effects', 'rank', 'fitted.values', 'assign', 'qr', 'df.residual', 'xlevels', 'call', 'terms', 'model'), class = 'lm'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators201() {
        assertEval("argv <- list(3e+09, 30000L);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators202() {
        assertEval("argv <- list(structure(list(A = c(1, NA, 1), B = c(1.1, NA, 2), C = c(1.1+0i, NA, 3+0i), D = c(NA_integer_, NA_integer_, NA_integer_), E = c(FALSE, NA, TRUE), F = c('abc', NA, 'def')), .Names = c('A', 'B', 'C', 'D', 'E', 'F'), class = 'data.frame', row.names = c('1', '2', '3')));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators203() {
        assertEval("argv <- list(structure(1395082079.73982, class = c('POSIXct', 'POSIXt')));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators204() {
        assertEval("argv <- list(quote(y ~ a + b:c + d + e + e:d));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators205() {
        assertEval("argv <- list(structure(c(-Inf, -Inf, -Inf, -Inf, 0, 0, 0, 0, 0, -Inf, -Inf, -Inf, -Inf, 0, 0, 0, 0, 0, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, 0, 0, 0, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, 0, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, 0, 0, 0, -Inf, -Inf, -Inf, -Inf, -Inf, 0, 0, 0, 0, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, 0, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, 0, 0, 0, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, 0, 0, 0, -Inf, -Inf, -Inf, 0, 0, 1, 1, Inf, Inf, -Inf, -Inf, -Inf, 0, 0.5, 1, Inf, Inf, Inf, -Inf, -Inf, -Inf, -Inf, 0, 1, 1, 1, Inf, -Inf, -Inf, -Inf, -Inf, 0, 0.5, 1, Inf, Inf, -Inf, -Inf, -Inf, 0, 0.5, 1, Inf, Inf, Inf, -Inf, -Inf, -Inf, 0, 0.6, Inf, Inf, Inf, Inf, -Inf, -Inf, -Inf, 0, 0.4, 0.8, Inf, Inf, Inf, -Inf, -Inf, -Inf, 0, 0.533333333333334, Inf, Inf, Inf, Inf, -Inf, -Inf, -Inf, 0, 0.525, Inf, Inf, Inf, Inf, -Inf, -Inf, 0, 0, 1, 2, Inf, Inf, Inf, -Inf, -Inf, 0, 0.5, 1, 2, Inf, Inf, Inf, -Inf, -Inf, -Inf, 0, 1, 2, 2, Inf, Inf, -Inf, -Inf, -Inf, 0, 0.8, 1.6, Inf, Inf, Inf, -Inf, -Inf, -Inf, 0.5, 1.3, Inf, Inf, Inf, Inf, -Inf, -Inf, -Inf, 0.5, 1.4, Inf, Inf, Inf, Inf, -Inf, -Inf, -Inf, 0.5, 1.2, 1.9, Inf, Inf, Inf, -Inf, -Inf, -Inf, 0.499999999999999, 1.33333333333333, Inf, Inf, Inf, Inf, -Inf, -Inf, -Inf, 0.5, 1.325, Inf, Inf, Inf, Inf, -Inf, -Inf, 0, 1, 2, 3, Inf, Inf, Inf, -Inf, -Inf, 0, 1, 2, 3, Inf, Inf, Inf, -Inf, -Inf, -Inf, 1, 2, 3, Inf, Inf, Inf, -Inf, -Inf, -Inf, 0.5, 1.6, 2.7, Inf, Inf, Inf, -Inf, -Inf, -Inf, 1, 2.1, Inf, Inf, Inf, Inf, -Inf, -Inf, -Inf, 1, 2.2, Inf, Inf, Inf, Inf, -Inf, -Inf, 0, 1, 2, 3, Inf, Inf, Inf, -Inf, -Inf, -Inf, 1, 2.13333333333333, Inf, Inf, Inf, Inf, -Inf, -Inf, -Inf, 1, 2.125, Inf, Inf, Inf, Inf, -Inf, -Inf, 0, 1, 3, 4, Inf, Inf, Inf, -Inf, -Inf, 0, 1.5, 3, 4, Inf, Inf, Inf, -Inf, -Inf, 0, 1, 2, 4, Inf, Inf, Inf, -Inf, -Inf, -Inf, 1, 2.4, 3.8, Inf, Inf, Inf, -Inf, -Inf, 0.100000000000001, 1.5, 2.9, Inf, Inf, Inf, Inf, -Inf, -Inf, 0, 1.5, 3, Inf, Inf, Inf, Inf, -Inf, -Inf, 0.2, 1.5, 2.8, Inf, Inf, Inf, Inf, -Inf, -Inf, 0.0666666666666664, 1.5, 2.93333333333333, Inf, Inf, Inf, Inf, -Inf, -Inf, 0.0750000000000002, 1.5, 2.925, Inf, Inf, Inf, Inf, -Inf, -Inf, 0, 2, 4, 5, Inf, Inf, Inf, -Inf, -Inf, 0, 2, 4, 5, Inf, Inf, Inf, -Inf, -Inf, 0, 1, 3, 5, Inf, Inf, Inf, -Inf, -Inf, -Inf, 1.5, 3.2, 4.9, Inf, Inf, Inf, -Inf, -Inf, 0.300000000000001, 2, 3.7, Inf, Inf, Inf, Inf, -Inf, -Inf, 0.2, 2, 3.8, Inf, Inf, Inf, Inf, -Inf, -Inf, 0.4, 2, 3.6, Inf, Inf, Inf, Inf, -Inf, -Inf, 0.266666666666667, 2, 3.73333333333333, Inf, Inf, Inf, Inf, -Inf, -Inf, 0.275, 2, 3.725, Inf, Inf, Inf, Inf), .Dim = c(9L, 9L, 6L), .Dimnames = list(c('20%', '30%', '40%', '50%', '60%', '70%', '80%', '90%', '100%'), NULL, NULL)));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators206() {
        assertEval("argv <- list(structure(character(0), .Dim = c(0L, 7L), .Dimnames = list(NULL, c('description', 'class', 'mode', 'text', 'isopen', 'can read', 'can write'))));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators207() {
        assertEval("argv <- list(structure(list(coefficients = structure(c(1.47191076131574, 0.586694550701453, NA, 0.258706725324317), .Names = c('(Intercept)', 'x1', 'x2', 'x3')), residuals = structure(c(0.224762433374997, 0.4813346401898, -0.548705796690786, -0.873306430909872, 0.3255545927283, -0.288240908441576, 0.530823516045489, -0.0649703574297026, 1.2699009772491, -1.05715266611575), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10')), effects = structure(c(-18.0083860263211, 7.91372047070235, 0.594462796282497, -0.733976126666906, 0.546582698364345, -0.032332374655677, 0.774795104738016, 0.120246912926227, 1.34954655602521, -1.1298961521627), .Names = c('(Intercept)', 'x1', 'x3', '', '', '', '', '', '', '')), rank = 3L, fitted.values = structure(c(2.08447598454963, 2.74878255284838, 3.46483046621199, 4.23261972464046, 5.0521503281338, 5.923422276692, 6.84643557031507, 7.821190209003, 8.84768619275579, 9.92592352157344), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10')), assign = 0:3, qr = structure(list(    qr = structure(c(-3.16227766016838, 0.316227766016838, 0.316227766016838, 0.316227766016838, 0.316227766016838, 0.316227766016838, 0.316227766016838, 0.316227766016838, 0.316227766016838, 0.316227766016838, -17.3925271309261, 9.08295106229247, 0.15621147358221, 0.0461150970695743, -0.0639812794430617, -0.174077655955698, -0.284174032468334, -0.39427040898097, -0.504366785493606, -0.614463162006242, -12.1747689916483, 9.99124616852172, 2.29782505861521, 0.388354773181155, 0.471167347118467, 0.46694109307793,     0.375676011059543, 0.197372101063308, -0.0679706369107753, -0.420352202862709, -17.3925271309261, 9.08295106229247, 1.30962518065979e-16, -1.00907321685019e-15, 0.0501848681992808, -0.170313338748631, 0.0400139169574381, -0.419073670426332, -0.887431917453648, -0.0447724572319277), .Dim = c(10L, 4L), .Dimnames = list(c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10'), c('(Intercept)', 'x1', 'x3', 'x2')), assign = 0:3), qraux = c(1.31622776601684, 1.26630785009485, 1.21850337126599, 1.04136435435488    ), pivot = c(1L, 2L, 4L, 3L), tol = 1e-07, rank = 3L), .Names = c('qr', 'qraux', 'pivot', 'tol', 'rank'), class = 'qr'), df.residual = 7L, xlevels = structure(list(), .Names = character(0)), call = quote(lm(formula = y ~ x1 + x2 + x3)), terms = quote(y ~ x1 + x2 + x3), model = structure(list(y = c(2.30923841792462, 3.23011719303818, 2.9161246695212, 3.35931329373059, 5.3777049208621, 5.63518136825043, 7.37725908636056, 7.75621985157329, 10.1175871700049, 8.86877085545769), x1 = 1:10, x2 = 1:10,     x3 = c(0.1, 0.4, 0.9, 1.6, 2.5, 3.6, 4.9, 6.4, 8.1, 10)), .Names = c('y', 'x1', 'x2', 'x3'), terms = quote(y ~ x1 + x2 + x3), row.names = c(NA, 10L), class = 'data.frame')), .Names = c('coefficients', 'residuals', 'effects', 'rank', 'fitted.values', 'assign', 'qr', 'df.residual', 'xlevels', 'call', 'terms', 'model'), class = 'lm'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators208() {
        assertEval("argv <- list(structure(c(1L, 2L, 1L), .Dim = 3L, .Dimnames = structure(list(c('1', '2', NA)), .Names = ''), class = 'table'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators209() {
        assertEval("argv <- list(0.603420215896625, c(0, 0, 0, 0, 0, -0.0303676182248376, -0.0303676182248376, -0.0616574286863247, -0.0616574286863247, -0.0616574286863247, -0.0616574286863247, -0.0616574286863247, -0.0616574286863247, -0.0938974361662337, -0.0938974361662337, -0.0938974361662337, -0.127116495884859, -0.127116495884859, -0.127116495884859, -0.127116495884859, -0.161344339326807, -0.161344339326807, -0.161344339326807, -0.161344339326807, -0.161344339326807, -0.161344339326807, -0.196611600851059, -0.196611600851059, -0.196611600851059, -0.196611600851059, -0.196611600851059, -0.196611600851059, -0.196611600851059, -0.196611600851059, -0.196611600851059, -0.232949845109116, -0.232949845109116, -0.232949845109116, -0.232949845109116, -0.232949845109116, -0.232949845109116, -0.232949845109116, -0.232949845109116, -0.232949845109116, -0.232949845109116, -0.270391595295763, -0.270391595295763, -0.270391595295763, -0.270391595295763, -0.270391595295763, -0.348720674486417, -0.389678109021166));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators210() {
        assertEval("argv <- list(5, c(0.90483741803596, 0.042329219623205, 3.72007597602068e-44));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators211() {
        assertEval("argv <- list(structure(c(110, 72, 89, 67, 116, 56, 102, 70, 116, 56, 106, 48), .Names = c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23')), structure(c(0.618181818181818, 0.583333333333333, 0.415730337078652, 0.358208955223881, 0.568965517241379, 0.589285714285714, 0.46078431372549, 0.328571428571429, 0.543103448275862, 0.517857142857143, 0.537735849056604, 0.395833333333333), .Names = c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23')));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators212() {
        assertEval("argv <- list(0, 0L);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators213() {
        assertEval("argv <- list(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), structure(c(110, 72, 89, 67, 116, 56, 102, 70, 116, 56, 106, 48), .Names = c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23')));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators214() {
        assertEval("argv <- list(0+6.28318530717959i, 1:16);`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators215() {
        assertEval("argv <- list(10, structure(0:100, .Tsp = c(1, 101, 1), class = 'ts'));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators216() {
        assertEval("argv <- list(1, 8);`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators217() {
        assertEval("argv <- list(0+1i, 2);`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators218() {
        assertEval("argv <- list(2L, 5L);`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators219() {
        assertEval("argv <- list(0+2i, 3.14159265358979);`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators220() {
        assertEval("argv <- list(structure(11323, class = 'Date'), c(12, 24, 36, 48, 60, 72, 84, 96, 108));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators221() {
        assertEval("argv <- list(3, 0+5i);`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators222() {
        assertEval("argv <- list(structure(c(68, 42, 37, 24, 66, 33, 47, 23, 63, 29, 57, 19), .Names = c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23')), structure(c(42, 30, 52, 43, 50, 23, 55, 47, 53, 27, 49, 29), .Names = c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23')));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators224() {
        assertEval("argv <- list(structure(1:12, .Dim = 3:4), 3);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators225() {
        assertEval("argv <- list(0.02);`+`(argv[[1]]);");
    }

    @Test
    public void testoperators226() {
        assertEval("argv <- list(1, structure(c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8), .Tsp = c(1960.08333333333, 1961.66666666667, 12), class = 'ts'));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators227() {
        assertEval("argv <- list(3.14159265358979, c(8.24339426780198e-14, 8.88066145332545e-14, 3.39607080058103e-14, 2.87112686384263e-14, -5.3372537031158e-14, 9.96185601455202e-14, -3.26659396832497e-14, 1.39086823244366e-13, 1.72881695621852e-13, 4.32507741831361e-14, -9.84603924440361e-14, 9.87208407136427e-14, -2.73032911651077e-14, -1.48736837028697e-13, 2.94392054503409e-14, -1.05171613093738e-13, -1.14029445758562e-13, 5.13338041611324e-15, -1.87531579189825e-13, -1.25627528672486e-13, 4.10267164560562e-14, 1.74236574669889e-13, 8.02066525165472e-14, 1.57764465352e-13, 1.23253351804626e-13, 1.6788749880341e-13, -1.39908165098147e-13, -1.58115885024452e-13, 1.81544497697974e-13, -1.14362367874561e-13, 1.56626365789358e-13, -1.81348445541539e-13, 1.34029870837468e-13, 5.83660521214748e-14, 1.66415892254192e-13, -1.55962501921682e-13, 5.56922447997358e-15, -1.90684901734508e-13, -1.56068620913678e-13, 1.42594677103356e-13, -1.5324035174056e-13, -1.72045664669025e-13, 6.15626207230525e-14, -1.70423231918929e-13, -2.2440318442518e-14, -6.47937716601402e-14, -1.03307295568126e-13, 7.89213836842498e-14, -9.01552844071197e-15, -1.39863491975671e-13, 1.21580502093206e-13, 1.74391617154328e-13, -7.68474764369541e-15, -9.62952541877272e-14, -5.3148471902392e-14, -2.21880305144443e-14, 5.26389742858333e-14, 2.7159840200832e-14, 1.87431554819324e-14, 4.56102486340353e-14, 1.11966090535737e-13, 9.46528420538298e-14, -1.10626253790834e-14, -1.20682584010224e-13, 1.09679727142136e-13, 1.85521222833898e-13, 1.28904258163856e-13, -7.30112958403796e-14, 4.38190249362539e-14, -5.25642067782032e-14, -1.07266296983526e-13, 4.48939091164837e-14, 4.09010010401022e-14, 1.576058154827e-13, -1.65586113176678e-13, 1.64953139323032e-13, -3.61017352519794e-14, -5.98713716165795e-14, 1.5553263601743e-13, -1.40329145253713e-13, -1.34306416738384e-13, 6.33760537168414e-15, -1.47719256195174e-13, 1.30439641217338e-13, -1.9949544714752e-13, 8.89585653992738e-14, 9.03099047696007e-14, -5.47032374550363e-14, 1.44655516265113e-13, 1.70556682807057e-13, -9.71359599142186e-14, -6.53941098287223e-14, -8.38818567534634e-14, 6.7826899389696e-14, 1.86838153280979e-13, 4.37228204318607e-14, 8.3759639291968e-14, -1.92868749423155e-13, -9.13894925944948e-14, 5.76515542011828e-14, 3.92733987046576e-14));`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators228() {
        assertEval("argv <- list(4, 1:5);`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators229() {
        assertEval("argv <- list(structure(c(1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '40', '41', '42', '43', '44', '45', '46', '47', '48', '49', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '60', '61', '62', '63', '64', '65', '66', '67', '68', '69', '70', '71', '72', '73', '74', '75', '76', '77', '78', '79', '80', '81', '82', '83', '84', '85', '86', '87', '88', '89', '90', '91', '92', '93', '94', '95', '96', '97', '98', '99', '100')), 0.1);`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators230() {
        assertEval("argv <- list(structure(1:10, .Tsp = c(1920.5, 1921.25, 12), class = 'ts'), 1);`+`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators231() {
        assertEval("argv <- list(1, 1);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators232() {
        assertEval("argv <- list(structure(c(68, 42, 37, 24, 66, 33, 47, 23, 63, 29, 57, 19, 42, 30, 52, 43, 50, 23, 55, 47, 53, 27, 49, 29), .Dim = c(12L, 2L), .Dimnames = list(c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23'), c('X', 'M'))), structure(c(68, 42, 37, 24, 66, 33, 47, 23, 63, 29, 57, 19, 42, 30, 52, 43, 50, 23, 55, 47, 53, 27, 49, 29), .Dim = c(12L, 2L), .Dimnames = list(c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23'), c('X', 'M'))));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators233() {
        assertEval("argv <- list(structure(c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Tsp = c(3, 10, 1), class = 'ts'), structure(c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), .Tsp = c(3, 10, 1), class = 'ts'));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators234() {
        assertEval("argv <- list(c(-1.04843842027757e+143, -9.998687937523e+136, -9.53549188377803e+130, -9.09375370386458e+124, -8.67247934711978e+118, -8.27072081298779e+112, -7.88757401780305e+106, -7.52217676063816e+100, -7.17370678430818e+94, -6.84137992972049e+88, -6.5244483891549e+82, -6.22219909169008e+76, -5.93395235884653e+70, -5.65906136797865e+64, -5.39691448428537e+58, -5.14694833309681e+52, -4.90870165301755e+46, -4.68202458334831e+40, -4.46788150641526e+34, -4.27143012156591e+28, -4.11397031483551e+22, -40816513889983680, -45637199262.2201, -83492.8982026505, -1.56717399085881, -0.0019371698216247, -0.0388983050293216, 0.00184649674288725, -0.049895679671468, 0.0161192923654623, -0.0169866996250208));`-`(argv[[1]]);");
    }

    @Test
    public void testoperators235() {
        assertEval("argv <- list(FALSE, c(-3L, -2L, -1L, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L, 30L, 31L, 32L, 33L, 34L, 35L, 36L, 37L, 38L, 39L, 40L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L, 30L, 31L, 32L, 33L, 34L, 35L, 36L, 37L, 38L, 39L, 40L, 41L, 42L, 43L, 44L, 45L, 46L, 47L, 48L, 49L, 50L, 51L, 52L, 53L, 54L, 55L, 56L, 57L, 58L, 59L, 60L, 61L, 62L, 63L, 64L, 65L, 66L, 67L, 68L, 69L, 70L));`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators236() {
        assertEval("argv <- list(structure(1395082079.75887, class = c('POSIXct', 'POSIXt')), 3600);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators237() {
        assertEval("argv <- list(structure(c(2, 1, 0, 1, 0, NA, NA, NA, 0), .Dim = c(3L, 3L)), structure(c(1, 1, 1, 0.5, 0.5, 0.5, 0, 0, 0), .Dim = c(3L, 3L)));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators238() {
        assertEval("argv <- list(structure(2:10, .Tsp = c(2, 10, 1), class = 'ts'), structure(1:9, .Tsp = c(2, 10, 1), class = 'ts'));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators239() {
        assertEval("argv <- list(structure(0:100, .Tsp = c(1, 101, 1), class = 'ts'), 4);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators240() {
        // FIXME FastR output ignores .Dim attribute of structure()
        assertEval(Ignored.OutputFormatting, "argv <- list(structure(numeric(0), .Dim = c(0L, 4L)), structure(numeric(0), .Dim = c(0L, 4L)));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators241() {
        assertEval("argv <- list(structure(c(1L, 0L, 0L, 1L), .Dim = c(2L, 2L), .Dimnames = structure(list(x = c('1', '2'), y = c('1', '2')), .Names = c('x', 'y')), class = 'table'), 1);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators242() {
        assertEval("argv <- list(5);`-`(argv[[1]]);");
    }

    @Test
    public void testoperators243() {
        assertEval("argv <- list(structure(c(68, 42, 37, 24, 66, 33, 47, 23, 63, 29, 57, 19), .Names = c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23')), structure(c(68, 42, 37, 24, 66, 33, 47, 23, 63, 29, 57, 19), .Names = c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23')));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators244() {
        assertEval("argv <- list(10, structure(c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10), .Tsp = c(1, 10, 1), class = 'ts'));`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators245() {
        assertEval("argv <- list(17L, 10L);`-`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators246() {
        assertEval("argv <- list(structure(100L, .Names = 'expsumNoisy'), 100L);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators247() {
        assertEval("argv <- list(50, 51);`:`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators248() {
        assertEval("argv <- list(-1, 1);`:`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators249() {
        assertEval("argv <- list(1L, structure(15L, .Names = 'nc'));`:`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators250() {
        assertEval("argv <- list(-20, 10);`:`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators251() {
        assertEval("argv <- list(-7L, -1L);`:`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators252() {
        assertEval("argv <- list(structure(c(0.618181818181818, 0.583333333333333, 0.415730337078652, 0.358208955223881, 0.568965517241379, 0.589285714285714, 0.46078431372549, 0.328571428571429, 0.543103448275862, 0.517857142857143, 0.537735849056604, 0.395833333333333), .Names = c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23')), 0);`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators253() {
        assertEval("argv <- list(c(1, 1, 1, 1, 1), -10);`<`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators254() {
        assertEval("argv <- list(structure(c(1208822400, 1208908800, 1208995200, 1209081600, 1209168000, 1209254400), class = c('POSIXct', 'POSIXt'), tzone = 'GMT'), structure(1209168000, class = c('POSIXct', 'POSIXt'), tzone = 'GMT'));`<=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators257() {
        assertEval("argv <- list(structure(c(1, 1.4142135623731, 1.73205080756888, 2, 2.23606797749979, 2.44948974278318, 2.64575131106459, 2.82842712474619, 3, 3.16227766016838), id = 'test 1', class = structure('withId', package = '.GlobalEnv')), 1);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators258() {
        assertEval("argv <- list(2L, 1);`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators259() {
        assertEval("argv <- list(structure(c(2L, NA, NA, 4L, 3L, 2L, 1L, 5L, 5L, 6L), .Label = c('NA', 'a', 'b', 'c', 'd', NA), class = 'factor'), structure(c(2L, NA, NA, 4L, 3L, 2L, 1L, 5L, 5L, 6L), .Label = c('NA', 'a', 'b', 'c', 'd', NA), class = 'factor'));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators260() {
        assertEval("argv <- list(c(-Inf, Inf), c(-Inf, Inf));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators261() {
        assertEval("argv <- list(structure(list(VAR1 = c(1, 2, 3, 4, 5), VAR3 = c(1, 1, 1, 1, NA)), .Names = c('VAR1', 'VAR3'), class = 'data.frame', row.names = c(NA, -5L)), 1);`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators262() {
        assertEval("argv <- list(structure(1:20, .Dim = c(2L, 2L, 5L)), structure(1:20, .Dim = c(2L, 2L, 5L)));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators263() {
        assertEval("argv <- list(structure(c(1L, 2L, NA), .Label = c('1', '2'), class = 'factor'), structure(c(1L, 2L, NA), .Label = c('1', '2'), class = 'factor'));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators264() {
        assertEval("argv <- list(c(5L, 2L, 4L), c(5, 2, 4));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators265() {
        assertEval("argv <- list(NULL, 'foo');`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators266() {
        assertEval("argv <- list(structure(FALSE, .Names = 'd'), FALSE);`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators267() {
        assertEval("argv <- list(c('1', '2', NA), c('1', '2', NA));`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators268() {
        assertEval("argv <- list(-1:12, 2);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators269() {
        assertEval("argv <- list(structure('(converted from warning) NAs produced\\n', class = 'try-error', condition = structure(list(message = '(converted from warning) NAs produced', call = quote(rnorm(1, sd = Inf))), .Names = c('message', 'call'), class = c('simpleError', 'error', 'condition'))), '(converted from warning) NAs produced\\n');`==`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators270() {
        assertEval("argv <- list(75.1931882101063, 0);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators271() {
        assertEval("argv <- list(3.001e+155, 0);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators272() {
        // FIXME FastR output ignores .Tsp attribute of structure()
        assertEval(Ignored.OutputFormatting, "argv <- list(structure(c(4, 3, 2, 1, 0), .Tsp = c(-1, 3, 1), class = 'ts'), 1e-05);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators273() {
        assertEval("argv <- list(structure(c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), .Dim = c(12L, 2L), .Dimnames = list(c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23'), c('X', 'M'))), 0.001);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators274() {
        assertEval("argv <- list(structure(c(0, 0, 0, 0, 0, 0, 0, 0, 0, 3.5527136788005e-15, 0, 0), .Names = c('1', '3', '5', '7', '9', '11', '13', '15', '17', '19', '21', '23')), 0.001);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators275() {
        // FIXME FastR output ignores .Tsp attribute of structure()
        assertEval(Ignored.OutputFormatting, "argv <- list(structure(c(0, 1, 2, 3, 4, 5, 6, 7, 8), .Tsp = c(3, 11, 1), class = 'ts'), 1e-05);`>`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators276() {
        assertEval("argv <- list(structure(c(13991, 13992, 13993, 13994, 13995), class = 'Date', labels = c('Apr 22', 'Apr 23', 'Apr 24', 'Apr 25', 'Apr 26')), 13991);`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators277() {
        assertEval("argv <- list(structure(3.00510204081633, base = 14, lens = 3L, .classes = c('R_system_version', 'package_version', 'numeric_version')), structure(2.92857142857143, base = 14, lens = 3L, .classes = c('package_version', 'numeric_version')));`>=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators278() {
        assertEval("argv <- list(2, c(1, 53.6315789473684, 106.263157894737, 158.894736842105, 211.526315789474, 264.157894736842, 316.789473684211, 369.421052631579, 422.052631578947, 474.684210526316, 527.315789473684, 579.947368421053, 632.578947368421, 685.210526315789, 737.842105263158, 790.473684210526, 843.105263157895, 895.736842105263, 948.368421052632, 1001));`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators279() {
        assertEval("argv <- list(structure(1:12, .Dim = 12L), 3);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators280() {
        assertEval("argv <- list(c(4.17, 5.58, 5.18, 6.11, 4.5, 4.61, 5.17, 4.53, 5.33, 5.14, 4.81, 4.17, 4.41, 3.59, 5.87, 3.83, 6.03, 4.89, 4.32, 4.69), 2);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators281() {
        assertEval("argv <- list(c(2, 13954490295224484, 9.73638996997572e+31, 6.79331796732739e+47, 4.73986448237219e+63, 3.30711964599708e+79, 2.30745845026066e+95, 1.60997032753976e+111, 1.12331576556267e+127, 7.83764947450857e+142, 5.46852017646992e+158, 3.8155205865895e+174, 2.66218224983966e+190, 1.85746981847535e+206, 1.29600222777925e+222, 9.04252525506755e+237, 6.30919154580821e+253, 4.40207760983472e+269, 3.07143746426322e+285, 2.14301721437253e+301), 0.9);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators282() {
        assertEval("argv <- list(structure(c(FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE), .Names = c(' 100', '-1e-13', ' Inf', '-Inf', ' NaN', '3.14', '  NA')), structure(c(TRUE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE), .Names = c(' 100', '-1e-13', ' Inf', '-Inf', ' NaN', '3.14', '  NA')));`|`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators283() {
        assertEval("argv <- list(10, structure(c(2.62236698682835, 2.59270366218715, 2.63940608371058, 2.64731958493827, 2.65803373028597, 2.71373162990423, 2.77064097627242, 2.76566849458896, 2.68535956033309, 2.6323339540094, 2.56646882037186, 2.60930482928073, 2.61873883018004, 2.58963301587663, 2.63649393196055, 2.64432599746861, 2.65480384168506, 2.71016075212057, 2.76665607635342, 2.76121751481566, 2.68040487260442, 2.62684815424423, 2.56043192269559, 2.60270233556967), .Tsp = c(1961, 1962.91666666667, 12), class = 'ts'));`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators284() {
        // FIXME FastR only outputs 0e+00
        // while GnuR sequence of 0.000000e+00 9.881313e-324 ... 1.000000e-307
        assertEval(Ignored.ImplementationError, "argv <- list(10, -324:-307);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators285() {
        assertEval("argv <- list(structure(c(2, -2, -2, 2), .Dim = c(2L, 2L), .Dimnames = list(c('Milk', 'Tea'), c('Milk', 'Tea'))), 2);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators286() {
        assertEval("argv <- list(c(-0.672916599964862, -0.584338371560402, 0.572115715156077, -0.341116997543456, -0.218053452331652, 0.603114283893957, -0.415268358002702, -0.0134950134274691, 0.76321585191833, 0.804319710846886, 0.0536892937002835, 1.74635019377278, -0.471646028332481, 1.63758588525433, -0.578351427808452, 0.946667542637206, -0.329423655668059, -0.187791022191408, 0.794323068130594, 0.894218687970535, -1.22656982031204, 1.0590522527981, 0.612808669537666, -0.939425042488798, 2.69005530237799, -5.30421668373535, 2.81829750013497, -0.200427817155017, 0.828486397910241, 0.279395276763307, 0.0200169554117855, -0.787735991519008, -1.29364959334893, -0.511638483749587, 0.113049755514737, 1.10102046217428, -0.306657900899176, 0.268100169311174, -0.305146107712725, 0.396162277846222, 0.0150939553276523, 1.49211381144096, -1.92447564755755, 0.872283353434605, -1.19828539105242, 0.249023119183754, -0.888972367366677, -0.343085496017779, -0.789859289813313, 2.25212409468034, 2.24112978772768, -0.268185452742113, -0.258069470254978, -1.83609460856723, -0.0896167695808968, -0.0862703217063487, -0.00265875112142955, -0.414323880711934, -0.87767314293053, -2.22003587446461, -0.8313148988929, 0.832662806275473, -0.671837383858861, -1.85809916947114, -0.433937023889368, -0.851823367571459, -1.57641862799745, -0.880161315252144, -0.658071675968036, -1.21910415241982, -0.103154147995399, -1.92102359833593, 0.794527839025225, -1.0143657782449, 0.633288668140732, -0.0981774734963654, -0.927622152862583, -1.15272382197142, 3.28038998456465, -2.43807429671523, 0.0242203067253644, -0.377015290181077, 1.18353877313309, -5.69817122824189, -0.316441438096387, -0.0880345184260629, -0.161984388003683, -1.04890926431944, 3.34283466347557, -1.14655469197163, -0.0469559138168916, 4.57732396845363, -1.10972642208237, 6.74369483998494, -4.51689622564278, -0.942648739247179, 2.19288903907033, 1.26921808442688, -0.705352464586085, 0.00567568850361933), 2);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators287() {
        assertEval("argv <- list(-3:4, 2);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators288() {
        assertEval("argv <- list(0.9, Inf);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators289() {
        // FIXME
        // Expected output: [1] Inf+0i Inf+0i Inf+0i 1+0i 0+0i 0+0i 0+0i
        // FastR output: [1] Inf+NaNi Inf+NaNi Inf+NaNi 1+ 0i 0+ 0i 0+ 0i 0+ 0i
        assertEval(Ignored.ImplementationError, "argv <- list(0+0i, -3:3);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators290() {
        assertEval("argv <- list(structure(c(8L, 8L), .Names = c('y', 'x')), 8L);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators291() {
        assertEval("argv <- list(c(-Inf, -2, -1), -3);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators292() {
        assertEval("argv <- list(integer(0), 1:3);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators293() {
        // FIXME
        // Expected output: [1] 1 1 1 1 1 1 1 1 1
        // FastR output: [1] NA 1 1 1 1 1 NA NA NA
        assertEval(Ignored.ImplementationError, "argv <- list(c(NA, -2L, -1L, 0L, 1L, 2L, NA, NA, NA), 0L);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators294() {
        // FIXME 'NaN' instead of 'Inf' in output
        // Expected output: [1] 0.0000000-0.5000000i 0.0000000-0.5773503i 0.0000000-0.7071068i
        // [4] 0.0000000-1.0000000i Inf+0.0000000i 1.0000000+0.0000000i
        // ...
        // FastR output: [1] 0.0000000-0.5000000i 0.0000000-0.5773503i 0.0000000-0.7071068i
        // [4] 0.0000000-1.0000000i NaN+ NaNi 1.0000000+0.0000000i
        // ...
        assertEval(Ignored.OutputFormatting,
                        "argv <- list(c(-4+0i, -3+0i, -2+0i, -1+0i, 0+0i, 1+0i, 2+0i, 3+0i, 4+0i, 5+0i, 6+0i, 7+0i, 8+0i, 9+0i, 10+0i, 11+0i, 12+0i, -4+0i, -3+0i, -2+0i, -1+0i, 0+0i, 1+0i, 2+0i, 3+0i, 4+0i, 5+0i, 6+0i, 7+0i, 8+0i, 9+0i, 10+0i, 11+0i, 12+0i, -4+0i, -3+0i, -2+0i, -1+0i, 0+0i, 1+0i, 2+0i, 3+0i, 4+0i, 5+0i, 6+0i, 7+0i, 8+0i, 9+0i, 10+0i, 11+0i, 12+0i, -4+0i, -3+0i, -2+0i, -1+0i, 0+0i, 1+0i, 2+0i, 3+0i, 4+0i, 5+0i, 6+0i, 7+0i, 8+0i, 9+0i, 10+0i, 11+0i, 12+0i, -4+0i, -3+0i, -2+0i, -1+0i, 0+0i, 1+0i, 2+0i, 3+0i, 4+0i, 5+0i, 6+0i, 7+0i, 8+0i, 9+0i, 10+0i, 11+0i, 12+0i, -4+0i, -3+0i, -2+0i, -1+0i, 0+0i, 1+0i, 2+0i, 3+0i, 4+0i, 5+0i, 6+0i, 7+0i, 8+0i, 9+0i, 10+0i, 11+0i, 12+0i), c(-0.5, -0.5, -0.5, -0.5, -0.5, -0.5, -0.5, -0.5, -0.5, -0.5, -0.5, -0.5, -0.5, -0.5, -0.5, -0.5, -0.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2));`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators295() {
        assertEval("argv <- list(structure(c(26.2845882236184, 26.2845882236184, 26.2845882236184, 19.6276109953659, 19.6276109953659, 19.6276109953659, 19.6276109953659, 19.6276109953659, 16.7854987799975, 16.7854987799975, 16.7854987799975, 12.5343124120522, 12.5343124120522, 28.7031306388734, 28.7031306388734, 28.7031306388734, 28.7031306388734, 21.4336202544253, 21.4336202544253, 21.4336202544253, 21.4336202544253, 21.4336202544253, 21.4336202544253, 21.4336202544253, 28.044754781901, 28.044754781901, 28.044754781901, 28.044754781901, 28.044754781901, 28.044754781901, 28.044754781901, 24.2091543637699, 18.0778127599455, 18.0778127599455, 18.0778127599455, 18.0778127599455, 15.4601140250197, 15.4601140250197, 15.4601140250197, 15.4601140250197, 15.4601140250197, 15.4601140250197, 15.4601140250197, 15.4601140250197, 15.4601140250197, 15.4601140250197, 11.5446017812987, 11.5446017812987, 11.5446017812987, 11.5446017812987, 11.5446017812987, 26.436728414697, 26.436728414697, 26.436728414697, 26.436728414697, 26.436728414697, 26.436728414697, 26.436728414697, 26.436728414697, 19.7412193373284, 25.830337984867, 25.830337984867, 25.830337984867, 25.830337984867, 25.830337984867, 25.830337984867, 25.830337984867, 25.830337984867, 25.830337984867, 14.8736630467598, 14.8736630467598, 14.8736630467598, 11.1066785552923, 11.1066785552923, 11.1066785552923, 11.1066785552923, 11.1066785552923, 11.1066785552923, 9.49841217984702, 9.49841217984702, 9.49841217984702, 9.49841217984702, 9.49841217984702, 9.49841217984702, 9.49841217984702, 7.0927928470328, 7.0927928470328, 16.2422439293196, 16.2422439293196, 16.2422439293196, 12.1286452283118, 12.1286452283118, 12.1286452283118, 12.1286452283118, 12.1286452283118, 12.1286452283118, 12.1286452283118, 15.8696887052689, 15.8696887052689, 15.8696887052689, 15.8696887052689, 15.8696887052689, 15.8696887052689, 15.8696887052689, 13.6992370430272, 10.2296940445213, 10.2296940445213, 10.2296940445213, 10.2296940445213, 8.74841655179539, 8.74841655179539, 8.74841655179539, 8.74841655179539, 8.74841655179539, 8.74841655179539, 8.74841655179539, 8.74841655179539, 8.74841655179539, 8.74841655179539, 8.74841655179539, 6.53274517535593, 6.53274517535593, 6.53274517535593, 6.53274517535593, 6.53274517535593, 6.53274517535593, 14.959754634679, 14.959754634679, 14.959754634679, 14.959754634679, 14.959754634679, 14.959754634679, 14.959754634679, 14.959754634679, 14.959754634679, 11.170966121195, 14.6166164104337, 14.6166164104337, 14.6166164104337, 14.6166164104337, 14.6166164104337, 14.6166164104337, 14.6166164104337, 14.6166164104337, 14.6166164104337, 14.6166164104337), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '40', '41', '42', '43', '44', '45', '46', '47', '48', '49', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '60', '61', '62', '63', '64', '65', '66', '67', '68', '69', '70', '71', '72', '73', '74', '75', '76', '77', '78', '79', '80', '81', '82', '83', '84', '85', '86', '87', '88', '89', '90', '91', '92', '93', '94', '95', '96', '97', '98', '99', '100', '101', '102', '103', '104', '105', '106', '107', '108', '109', '110', '111', '112', '113', '114', '115', '116', '117', '118', '119', '120', '121', '122', '123', '124', '125', '126', '127', '128', '129', '130', '131', '132', '133', '134', '135', '136', '137', '138', '139', '140', '141', '142', '143', '144', '145', '146')), 2);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators296() {
        assertEval("argv <- list(17L, c(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L, 30L, 31L, 32L, 33L, 34L, 35L, 36L, 37L, 38L, 39L, 40L, 41L, 42L, 43L, 44L, 45L, 46L, 47L, 48L, 49L, 50L, 51L, 52L, 53L, 54L, 55L, 56L, 57L, 58L, 59L, 60L, 61L, 62L, 63L, 64L, 65L, 66L, 67L, 68L, 69L, 70L, 71L, 72L, 73L, 74L, 75L, 76L, 77L, 78L, 79L, 80L, 81L, 82L, 83L, 84L, 85L, 86L, 87L, 88L, 89L, 90L, 91L, 92L, 93L, 94L, 95L, 96L, 97L, 98L, 99L, 100L, 77L, 50L, 49L, 48L, 47L, 46L, 45L, 44L, 43L, 42L, 41L, 40L, 10L));`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators297() {
        assertEval("argv <- list(c(-Inf, -2, -1), 0.5);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators298() {
        assertEval("argv <- list(structure(c(4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L), .Dim = 27L, .Dimnames = structure(list(groups = c('M01', 'M02', 'M03', 'M04', 'M05', 'M06', 'M07', 'M08', 'M09', 'M10', 'M11', 'M12', 'M13', 'M14', 'M15', 'M16', 'F01', 'F02', 'F03', 'F04', 'F05', 'F06', 'F07', 'F08', 'F09', 'F10', 'F11')), .Names = 'groups'), class = 'table'), 2);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators299() {
        assertEval("argv <- list(NA_integer_, structure(-2, .Names = 'power'));`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators300() {
        assertEval("argv <- list(c(-Inf, -2, -1, 0, 1, 2, Inf, NA, NaN), 0);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators301() {
        assertEval("argv <- list(structure(1:12, .Dim = 3:4, .Dimnames = list(c('Case_1', 'Case_2', 'Case_3'), NULL)), 5);`%%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators302() {
        assertEval("argv <- list(structure(c(2L, 3L, 4L, 5L, 6L, 7L, 8L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), .Names = c('2:', '3:', '4:', '5:', '6:', '7:', '8:', '2:', '3:', '4:', '5:', '6:', '7:', '8:', '2:', '3:', '4:', '5:', '6:', '7:', '8:', '2:', '3:', '4:', '5:', '6:', '7:', '8:', '2:', '3:', '4:', '5:', '6:', '7:', '8:', '2:', '3:', '4:', '5:', '6:', '7:', '8:', '2:', '3:', '4:', '5:', '6:', '7:', '8:', '2:', '3:', '4:', '5:', '6:', '7:', '8:', '2:', '3:', '4:', '5:', '6:', '7:', '8:')), structure(c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 9L, 9L, 9L, 9L, 9L, 9L, 9L), .Names = c('1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9')));`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators303() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'));`^`(argv[[1]]);");
    }

    @Test
    public void testoperators304() {
        assertEval("argv <- list(0.8, structure(c(0L, 1L, 2L, 1L, 0L, 1L, 2L, 1L, 0L), .Dim = c(3L, 3L)));`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators305() {
        assertEval("argv <- list(structure(c(0, 0, 0, 0, 6, 0, 0, 0, 0, 6, 0, 0, 0, 0, 6, 0), .Dim = c(4L, 4L)), structure(c(0, 0, 0, 0, 6, 0, 0, 0, 0, 6, 0, 0, 0, 0, 6, 0), .Dim = c(4L, 4L)));`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators306() {
        assertEval("argv <- list(c(1.1, 2, Inf), -Inf);`^`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators307() {
        // FIXME FastR ignores .Dim attribute of the structure()
        assertEval(Ignored.OutputFormatting, "argv <- list(logical(0), structure(logical(0), .Dim = c(0L, 0L), .Dimnames = list(NULL, NULL)));`|`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators308() {
        assertEval("argv <- list(list());`|`(argv[[1]]);");
    }

    @Test
    public void testoperators309() {
        assertEval("argv <- list(structure(c(TRUE, FALSE, TRUE, TRUE), .Dim = c(2L, 2L), .Dimnames = list(NULL, NULL)), structure(c(FALSE, FALSE, FALSE, FALSE), .Dim = c(2L, 2L), .Dimnames = list(NULL, NULL)));`|`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators310() {
        assertEval("argv <- list(structure(c(TRUE, TRUE, TRUE, TRUE), .Dim = c(2L, 2L)), structure(c(FALSE, FALSE, FALSE, FALSE), .Dim = c(2L, 2L)));`|`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators311() {
        assertEval("argv <- list(structure(c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '40', '42', '43', '44', '45', '46', '47', '48', '49', '50', '51', '52', '53')), structure(c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '40', '42', '43', '44', '45', '46', '47', '48', '49', '50', '51', '52', '53')));`|`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators312() {
        // FIXME FastR ignores .Dimnames attribute of the structure()
        assertEval(Ignored.OutputFormatting,
                        "argv <- list(structure(c(0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0), .Dim = c(6L, 3L), .Dimnames = structure(list(`  p L s` = c('. . .', '. | .', '. . |', '. | |', '. . ?', '. | ?'), c('perm', 'LDL', 'super')), .Names = c('  p L s', ''))), c(4, 2, 1));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators313() {
        assertEval("argv <- list(structure(c(NA, FALSE, TRUE, NA, FALSE, TRUE, NA, FALSE, TRUE), .Names = c(NA, 'FALSE', 'TRUE', NA, 'FALSE', 'TRUE', NA, 'FALSE', 'TRUE')), structure(c(NA, NA, NA, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE), .Names = c(NA, NA, NA, 'FALSE', 'FALSE', 'FALSE', 'TRUE', 'TRUE', 'TRUE')));`|`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators314() {
        assertEval("argv <- list(structure(120L, class = 'octmode'), '644');`|`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators315() {
        assertEval("argv <- list(structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1), .Dim = c(9L, 5L), .Dimnames = list(c('1', '2', '3', '4', '5', '6', '7', '8', '9'), c('(Intercept)', 'outcome2', 'outcome3', 'treatment2', 'treatment3')), assign = c(0L, 1L, 1L, 2L, 2L), contrasts = structure(list(outcome = 'contr.treatment', treatment = 'contr.treatment'), .Names = c('outcome', 'treatment'))), c(3.04452243772342, -0.454255272277594, -0.292987124681473, 1.33790930192987e-15, 1.42108546079721e-15));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators316() {
        assertEval("argv <- list(character(0));`!`(argv[[1]]);");
    }

    @Test
    public void testoperators317() {
        assertEval("argv <- list(structure(c(-1, 2), .Dim = c(2L, 1L), .Dimnames = list(NULL, 'x')), c(-1, 2));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators318() {
        assertEval("argv <- list(structure(c(0.94232064077615, 0.62152295589611, 0.178333356339776, 0.0222599883329273), .Dim = c(4L, 1L)), structure(c(0.941251786864296, 0.603637002512359, 0.159215730735261, 0.0172717433258791), .Dim = c(1L, 4L)));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators319() {
        // FIXME NullPointerException
        // at com.oracle.truffle.r.nodes.builtin.base.MatMult.right0Dim(MatMult.java:125)
        assertEval(Ignored.ImplementationError, "argv <- list(numeric(0), structure(numeric(0), .Dim = c(1L, 0L)));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators320() {
        assertEval("argv <- list(structure(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 68, 56, 60, 68, 71, 61, 68, 60, 63, 56, 49, 58, 72, 60, 70, 74, 73, 48, 60, 61, 62, 65, 74, 73, 59, 60, 76, 74, 74, 63, 68, 58, 62, 65, 57, 75, 68, 67, 64, 68, 63, 74, 51, 81, 73, 59, 61, 72, 63, 69, 72, 70, 58, 59, 75, 69, 75, 76, 49, 68, 66, 75, 60, 72, 70, 77, 48, 47, 67, 74, 56, 56, 73, 76, 71, 82, 59, 60, 62, 55, 69, 62, 62, 69, 57, 46, 65, 58, 43, 56, 74, 60, 39, 66, 51, 45, 72, 58, 53, 52, 70, 52, 63, 50, 63, 62, 55, 50, 60, 64, 76, 70, 57, 39, 75, 0, 0, 0, 0, 0, 0, 0, NA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, NA, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, NA, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), .Dim = c(115L, 5L), .Dimnames = list(c('2', '3', '5', '7', '8', '10', '12', '14', '18', '19', '22', '24', '25', '27', '28', '30', '32', '33', '34', '35', '36', '37', '39', '42', '43', '44', '46', '47', '49', '52', '53', '54', '56', '57', '58', '61', '66', '67', '68', '69', '71', '73', '77', '79', '80', '81', '88', '90', '91', '95', '96', '100', '101', '105', '110', '111', '114', '116', '117', '118', '119', '121', '122', '124', '125', '129', '130', '133', '135', '136', '138', '140', '141', '143', '147', '149', '150', '152', '153', '155', '156', '158', '161', '163', '166', '168', '170', '172', '174', '177', '180', '181', '182', '183', '185', '186', '187', '188', '190', '192', '196', '199', '203', '204', '205', '206', '207', '208', '211', '214', '218', '219', '220', '225', '226'), c('(Intercept)', 'age', 'factor(ph.ecog)1', 'factor(ph.ecog)2', 'factor(ph.ecog)3')), assign = c(0L, 1L, 2L, 2L, 2L), contrasts = structure(list(`factor(ph.ecog)` = 'contr.treatment'), .Names = 'factor(ph.ecog)')), structure(c(6.76534252253894, -0.00731543889899693, -0.256632132912267, -0.629047717825279, -1.48257717514349), .Names = c('(Intercept)', 'age', 'factor(ph.ecog)1', 'factor(ph.ecog)2', 'factor(ph.ecog)3')));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators321() {
        assertEval("argv <- list(structure(c(544.790381900886, 398.486952468991, 440.879079007027, 273.26068924187, -165.547292067734, -289.908895455829, -336.563851641157, -433.491123254512, -446.830170210184, -229.698549757081, 7.43503106965538, 237.187718724823, 544.790381900886, 398.486952468991, 440.879079007027, 273.26068924187, -165.547292067734, -289.908895455829, -336.563851641157, -433.491123254512, -446.830170210184, -229.698549757081, 7.43503106965538, 237.187718724823, 544.790381900886, 398.486952468991, 440.879079007027, 273.26068924187, -165.547292067734, -289.908895455829, -336.563851641157, -433.491123254512, -446.830170210184, -229.698549757081, 7.43503106965538, 237.187718724823, 544.790381900886, 398.486952468991, 440.879079007027, 273.26068924187, -165.547292067734, -289.908895455829, -336.563851641157, -433.491123254512, -446.830170210184, -229.698549757081, 7.43503106965538, 237.187718724823, 544.790381900886, 398.486952468991, 440.879079007027, 273.26068924187, -165.547292067734, -289.908895455829, -336.563851641157, -433.491123254512, -446.830170210184, -229.698549757081, 7.43503106965538, 237.187718724823, 544.790381900886, 398.486952468991, 440.879079007027, 273.26068924187, -165.547292067734, -289.908895455829, -336.563851641157, -433.491123254512, -446.830170210184, -229.698549757081, 7.43503106965538, 237.187718724823, 1539.44739946315, 1548.66655077773, 1557.88570209231, 1566.45228027983, 1575.01885846735, 1583.14083472285, 1591.26281097836, 1599.26100149451, 1607.25919201066, 1611.39689466313, 1615.5345973156, 1612.61129444623, 1609.68799157686, 1603.44643859537, 1597.20488561388, 1588.73002343463, 1580.25516125537, 1570.86127478964, 1561.46738832392, 1549.89535441445, 1538.32332050498, 1524.62526591843, 1510.92721133189, 1499.65830819836, 1488.38940506483, 1479.31388700637, 1470.23836894792, 1460.03887936132, 1449.83938977473, 1441.27547309544, 1432.71155641615, 1432.51830671501, 1432.32505701387, 1433.15763708544, 1433.99021715701, 1434.96142536256, 1435.9326335681, 1435.47421580154, 1435.01579803498, 1433.4368629411, 1431.85792784722, 1430.85617066215, 1429.85441347709, 1432.59097206397, 1435.32753065085, 1440.49425642708, 1445.66098220331, 1448.76676550395, 1451.87254880459, 1452.9163236715, 1453.96009853841, 1454.6961768366, 1455.43225513478, 1452.22362902495, 1449.01500291512, 1442.43484036078, 1435.85467780644, 1426.50159512644, 1417.14851244644, 1409.58997614642, 1402.0314398464, 1397.59624058751, 1393.16104132862, 1386.64426440334, 1380.12748747807, 1371.71107833433, 1363.2946691906, 1354.59002807904, 1345.88538696748, 1336.94914699242, 1328.01290701735, 1318.64960669271, 49.7622186359663, -84.1535032467218, -121.764781099341, 37.2870304782966, 82.528433600382, -44.2319392670254, 25.3010406627996, -34.7698782399993, 48.5709781995188, 110.301655093951, -1.96962838525201, -3.7990131710535, -51.4783734777507, 135.066608935635, 114.916035379091, -28.990712676497, -11.7078691876363, 7.04762066618673, -38.9035366827579, 16.5957688400649, -38.4931502947952, 52.0732838386475, 26.6377575984557, 329.153973076816, -13.1797869657194, 872.199160524634, 371.882552045056, -254.299568603192, -95.2920977069916, 8.63342236039193, 16.852295225008, -29.0271834604991, 13.5051131963112, 4.54091267164154, 25.5747517733375, 386.850855912621, 259.276984531009, -199.961168270532, -153.894877042003, 94.302447817031, -20.3106357794875, 21.0527247936745, -6.29056183593116, 13.9001511905426, -29.4973604406664, -31.7957066699985, -224.096013272965, -30.9544842287708, 22.3370692945275, 432.596723859509, 47.1608224545594, -304.956866078466, 50.1150369329559, 24.6852664308792, -14.4511512739648, -4.94371710626865, -19.024507596255, -56.8030453693573, -314.583543516094, 165.222305128756, 316.17817825271, 23.9168069434991, 11.9598796643579, -128.904953645213, 0.419804589665318, -6.80218287850425, 29.2691824505584, 53.9010951754703, 40.9447832426993, -26.2505972353374, -41.4479380870087, -214.837325417531), .Dim = c(72L, 3L), .Dimnames = list(NULL, c('seasonal', 'trend', 'remainder')), .Tsp = c(1974, 1979.91666666667, 12), class = c('mts', 'ts', 'matrix')), c(1, 1, 1));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators322() {
        assertEval("argv <- list(c(-1, 1), structure(c(1e-05, 1e-04, 0.001, 0.01, 0.1, 1, 10, 100, 1000, 10000, 1e+05), .Dim = c(1L, 11L)));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators323() {
        assertEval("argv <- list(structure(c(-0.560475646552213+0i, 0.7424437487+0.205661411508856i, 1.39139505579429-0.26763356813179i, 0.928710764113827-0.221714979045717i, -0.46926798541295+1.18846175213664i, 0.7424437487-0.205661411508856i, 0.460916205989202+0i, -0.452623703774585+0.170604003753717i, -0.094501186832143+0.54302538277632i, -0.331818442379127+0.612232958468282i, 1.39139505579429+0.26763356813179i, -0.452623703774585-0.170604003753717i, 0.400771450594052+0i, -0.927967220342259+0.479716843914174i, -0.790922791530657+0.043092176305418i, 0.928710764113827+0.221714979045717i, -0.094501186832143-0.54302538277632i, -0.927967220342259-0.479716843914174i, 0.701355901563686+0i, -0.600841318509537+0.213998439984336i, -0.46926798541295-1.18846175213664i, -0.331818442379127-0.612232958468282i, -0.790922791530657-0.043092176305418i, -0.600841318509537-0.213998439984336i, -0.625039267849257+0i), .Dim = c(5L, 5L)), structure(c(0.63829956885596+0i, -0.190923866036828-0.209348060979014i, -0.478761262752136-0.086103851005322i, -0.365383456834977+0.041833555661111i, -0.222902888615007-0.301211043305794i, 0.537261763078809+0i, 0.305061935059249+0.040985454461732i, 0.320062315956695-0.375563080684186i, 0.339383913939873+0.23302799386284i, -0.286918674221019+0.348301421162371i, 0.428338589082996+0.09065231252407i, -0.107969030611945+0.281263066654197i, 0.001811723298003+0.250507832255811i, 0.144305664871353+0.232873855829054i, 0.761400139936914+0i, -0.050390571101999+0.329984002238884i, 0.120127927801654-0.008394623232215i, -0.521562263306688+0.262168616442556i, 0.691801039177503+0i, -0.206933988216912-0.109088169082914i, -0.014684754774299-0.0242358465049725i, 0.848358097780775+0i, -0.232315601522623+0.249797304698912i, -0.362004462885974+0.102815998405382i, 0.086977040883207+0.118037795588006i), .Dim = c(5L, 5L)));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators324() {
        assertEval("argv <- list(c(0, 0, 0, 0, 0, 0, 4.94065645841247e-324, 0, 0, 0, 0, 0), structure(c(73.0102287440125, 79.6161885135717, 81.5497837663961, 53.9710956454646, 43.6831159601594, 20.8581884349194, 7.6155030786098, 10.8008470888011, 14.7201505829463, 8.49167208457355, 101.686214382123, 921.711710792497), .Names = c('1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1')));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators325() {
        assertEval("argv <- list(-97.5074316406251, structure(c(73.0102287440125, 79.6161885135717, 81.5497837663961, 53.9710956454646, 43.6831159601594, 20.8581884349194, 7.6155030786098, 10.8008470888011, 14.7201505829463, 8.49167208457355, 101.686214382123, 921.711710792497), .Dim = c(1L, 12L), .Dimnames = list(NULL, c('1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1'))));`%*%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators326() {
        assertEval("argv <- list(structure(c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11), .Tsp = c(1959, 1997.91666667, 12), class = 'ts'), 3);`%/%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators327() {
        assertEval("argv <- list(structure(c(FALSE, FALSE, FALSE, FALSE), .Dim = 4L, .Dimnames = list(c('8', '10', '12', '14'))));`!`(argv[[1]]);");
    }

    @Test
    public void testoperators328() {
        assertEval("argv <- list(350L, 7);`%/%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators329() {
        assertEval("argv <- list(34, 2L);`%/%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators330() {
        assertEval("argv <- list(TRUE, 0:10);`%/%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators331() {
        assertEval("argv <- list(structure(1L, .Names = 'rate'), 2);`%/%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators332() {
        assertEval(Output.IgnoreWarningContext,
                        "argv <- list(structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = 'data.frame'));`%/%`(argv[[1]]);");
    }

    @Test
    public void testoperators333() {
        assertEval(Output.IgnoreWarningContext,
                        "argv <- list(structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = 'data.frame'), structure(list(c0 = structure(integer(0), .Label = character(0), class = 'factor')), .Names = 'c0', row.names = character(0), class = 'data.frame'));`%/%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators334() {
        assertEval("argv <- list(c(0, -1, 0, -1, -1, 0, NA, NA, 0, 0, 0, 0, 0, 15, 0, 17, 18, 0, 0, 0, NA, 0, 0, 0, 0, 0, NA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 0, 33, 34, 0, 0, 35, 0, 37, 38, 0), 2);`%/%`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators335() {
        assertEval("argv <- list(structure(numeric(0), .Dim = c(0L, 0L)));`&`(argv[[1]]);");
    }

    @Test
    public void testoperators336() {
        assertEval(Output.IgnoreWarningContext, "argv <- list(structure(integer(0), .Label = character(0), class = 'factor'));`&`(argv[[1]]);");
    }

    @Test
    public void testoperators337() {
        assertEval("argv <- list(c(TRUE, TRUE, TRUE, FALSE, TRUE, TRUE, TRUE, FALSE), c(TRUE, TRUE, TRUE, NA, FALSE, FALSE, TRUE, NA));`&`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators338() {
        assertEval("argv <- list(structure(c(FALSE, FALSE), .Names = c('(Intercept)', 'age')));`!`(argv[[1]]);");
    }

    @Test
    public void testoperators339() {
        assertEval("argv <- list(c(FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, TRUE, FALSE, TRUE), structure(c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE), .Names = c('is.R', 'is.array', 'is.atomic', 'is.call', 'is.character', 'is.complex', 'is.data.frame', 'is.double', 'is.element', 'is.environment', 'is.expression', 'is.factor', 'is.finite', 'is.function', 'is.infinite', 'is.integer', 'is.language', 'is.list', 'is.loaded', 'is.logical', 'is.matrix', 'is.na', 'is.na.POSIXlt', 'is.na.data.frame', 'is.na.numeric_version', 'is.name', 'is.nan', 'is.null', 'is.numeric', 'is.numeric.Date', 'is.numeric.POSIXt', 'is.numeric.difftime', 'is.numeric_version', 'is.object', 'is.ordered', 'is.package_version', 'is.pairlist', 'is.primitive', 'is.qr', 'is.raw', 'is.recursive', 'is.single', 'is.symbol', 'is.table', 'is.unsorted', 'is.vector')));`&`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators340() {
        // FIXME FastR ignores .Tsp attribute of the structure()
        assertEval(Ignored.OutputFormatting,
                        "argv <- list(structure(c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE), .Tsp = c(1790, 1970, 0.1), class = 'ts'), c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE));`&`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators341() {
        // FIXME FastR ignores .Tsp attribute of the structure()
        assertEval(Ignored.OutputFormatting,
                        "argv <- list(structure(c(TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE), .Dim = c(101L, 3L), .Dimnames = list(NULL, c('t1', '10 * t1', 't1 - 4')), .Tsp = c(1, 101, 1), class = c('mts', 'ts', 'matrix')), structure(c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE), .Dim = c(101L, 3L), .Dimnames = list(NULL, c('t1', '10 * t1', 't1 - 4'))));`&`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators342() {
        assertEval("argv <- list(structure(c(NA, FALSE, TRUE, NA, FALSE, TRUE, NA, FALSE, TRUE), .Names = c(NA, 'FALSE', 'TRUE', NA, 'FALSE', 'TRUE', NA, 'FALSE', 'TRUE')), structure(c(NA, NA, NA, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE), .Names = c(NA, NA, NA, 'FALSE', 'FALSE', 'FALSE', 'TRUE', 'TRUE', 'TRUE')));`&`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators343() {
        assertEval("argv <- list(structure(508L, class = 'octmode'), '755');`&`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators344() {
        assertEval("argv <- list(list());`&`(argv[[1]]);");
    }

    @Test
    public void testoperators345() {
        assertEval("argv <- list(structure(c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE), .Names = c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38', '39', '40', '41', '42', '43', '44', '45', '46', '47', '48', '49', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '60', '61', '62', '63', '64', '65', '66', '67', '68', '69', '70', '71', '72', '73', '74', '75', '76', '77', '78', '79', '80', '81', '82', '83', '84', '85', '86', '87', '88', '89', '90', '91', '92', '93', '94', '95', '96', '97', '98', '99', '100', '101', '102', '103', '104', '105', '106', '107', '108', '109', '110', '111', '112', '113', '114', '115', '116', '117', '118', '119', '120', '121', '122', '123', '124', '125', '126', '127', '128', '129', '130', '131', '132', '133', '134', '135', '136', '137', '138', '139', '140', '141', '142', '143', '144', '145', '146')));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators347() {
        assertEval("argv <- list(c(1-0i, 1+0i, 1+0i, 9.99999999999989e-01-5e-15i, 1+0i, 1+0i, 1-0i, 1e+00+9e-16i, 9.99999999999999e-01+3e-15i, 9.99999999999997e-01-3e-15i, 1e+00-1e-15i, 1+0i, 1+0i, 1e+00+1e-15i, 1+0i, 1+0i, 1+0i, 1-0i, 1+0i, 1e+00-5e-15i, 1-0i, 1+0i, 1+0i, 1+0i));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators348() {
        assertEval("argv <- list(structure(c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11), .Tsp = c(1959, 1997.91666667, 12), class = 'ts'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators349() {
        assertEval("argv <- list(structure(c(FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, TRUE, FALSE), .Dim = c(3L, 3L)));`!`(argv[[1]]);");
    }

    @Test
    public void testoperators350() {
        assertEval("argv <- list(c(-Inf, 2.17292368994844e-311, 4.34584737989688e-311, 8.69169475979376e-311, 1.73833895195875e-310, 3.4766779039175e-310, 6.953355807835e-310, 1.390671161567e-309, 2.781342323134e-309, 5.562684646268e-309, 1.1125369292536e-308, 2.2250738585072e-308, 4.4501477170144e-308, 8.90029543402881e-308, 1.78005908680576e-307, 2.2250738585072e-303, 2.2250738585072e-298, 1.79769313486232e+298, 1.79769313486232e+303, 2.24711641857789e+307, 4.49423283715579e+307, 8.98846567431158e+307, 1.79769313486232e+308, Inf, Inf, NaN, NA));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators351() {
        // FIXME exp(1) expressed as number in FastR
        // Expected output: function (x, base = exp(1)) .Primitive("log")
        // FastR output: function (x, base = 2.718282) .Primitive("log")
        assertEval(Ignored.OutputFormatting, "argv <- list(.Primitive('log'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators352() {
        assertEval("argv <- list(structure(NA, .Dim = c(1L, 1L)));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators353() {
        assertEval("argv <- list(structure(c(NA, 2, NA, 1, NA, 0), .Dim = 2:3));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators354() {
        assertEval("argv <- list(structure(list(A = c(1L, NA, 1L), B = c(1.1, NA, 2), C = c(1.1+0i, NA, 3+0i), D = c(NA, NA, NA), E = c(FALSE, NA, TRUE), F = structure(c(1L, NA, 2L), .Label = c('abc', 'def'), class = 'factor')), .Names = c('A', 'B', 'C', 'D', 'E', 'F'), class = 'data.frame', row.names = c('1', '2', '3')));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators355() {
        assertEval("argv <- list(structure(NA, .Dim = c(1L, 1L), name = 'Sam', class = structure('Foo', package = '.GlobalEnv')));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators356() {
        assertEval("argv <- list(structure(list(x = numeric(0), y = numeric(0), fac = structure(integer(0), .Label = c('A', 'B', 'C'), class = 'factor')), .Names = c('x', 'y', 'fac'), row.names = integer(0), class = 'data.frame'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators357() {
        assertEval("argv <- list(structure(list(x = c(-2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2), y = c(1, 4, 5, 9, 0, 0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 8, 8, 9, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 0, 1, 1, 1, 1, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 5, 5, 7, 8, 8, 9, 9, 9, 9, 10, 10, 10, 1, 2, 3, 5, 5, 10), z = c(-2, 5, -1, 7, -8, 17, -4, -2, -1, 0, -8, -3, 6, -9, 4, -10, 4, -9, -3, 4, -3, 8, 2, 8, 14, -14, -2, -1, 8, 9, -13, -12, -9, 0, 0, 5, 12, 14, -3, -1, 3, 4, 6, 18, 2, 8, 12, -23, 0, 2, 3, 13, -12, -6, -2, 3, 5, 8, -1, 12, 15, -11, 3, 4, 8, 10, 0, -8, -5, 7, 8, 1, -11, -10, -7, -3, 2, 4, 18, -5, -3, 0, -18, -7, -16, -10, -5, -6, -5, -3, -3, -11, -1, 2, 20, 0, -7, -1, 9, 3), u = c(12, 2, 6, 36, 17, 38, 24, 25, 19, 21, 6, 5, 28, 41, 28, 10, 6, 48, 33, 2, 45, 45, 37, 0, 29, 8, 23, 21, 1, 48, 20, 24, 26, 34, 35, 5, 35, 26, 33, 20, 7, 17, 40, 9, 17, 48, 50, 47, 46, 42, 28, 1, 14, 17, 32, 48, 14, 20, 2, 19, 27, 37, 44, 41, 23, 50, 30, 19, 42, 16, 12, 35, 38, 30, 33, 17, 32, 4, 41, 13, 9, 41, 39, 31, 32, 32, 36, 33, 32, 19, 37, 27, 17, 39, 19, 48, 33, 33, 42, 44)), .Names = c('x', 'y', 'z', 'u'), row.names = c(67L, 84L, 24L, 14L, 81L, 28L, 97L, 98L, 99L, 72L, 46L, 74L, 91L, 75L, 1L, 45L, 35L, 6L, 3L, 58L, 54L, 65L, 80L, 13L, 52L, 71L, 12L, 86L, 32L, 89L, 78L, 5L, 88L, 2L, 90L, 57L, 66L, 76L, 77L, 41L, 62L, 23L, 27L, 16L, 33L, 29L, 47L, 82L, 26L, 79L, 49L, 53L, 34L, 38L, 17L, 42L, 69L, 7L, 36L, 37L, 10L, 64L, 51L, 60L, 100L, 30L, 85L, 48L, 8L, 44L, 92L, 22L, 9L, 31L, 94L, 63L, 20L, 87L, 21L, 73L, 39L, 59L, 55L, 40L, 96L, 68L, 15L, 43L, 83L, 25L, 50L, 18L, 19L, 93L, 56L, 70L, 4L, 61L, 95L, 11L), class = 'data.frame'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators358() {
        assertEval("argv <- list(structure(list(x = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1), y = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10), fac = structure(c(1L, 2L, 2L, 3L, 1L, 3L, 3L, 2L, 2L, 1L), .Label = c('A', 'B', 'C'), class = 'factor'), char = structure(c('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'), class = 'AsIs')), .Names = c('x', 'y', 'fac', 'char'), row.names = c(NA, -10L), class = 'data.frame'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators359() {
        assertEval("argv <- list(c('«L', 'tin-1 ', '', '', 'ented ', 'h', 'rs»: éè øØ å<Å æ<Æ é éè'));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators360() {
        assertEval("argv <- list(structure(integer(0), .Label = character(0), class = 'factor'), 'auto');`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators361() {
        assertEval("argv <- list(structure(c(6.36917889425777, 5.36917889425777, 6.36917889425777, 6.36917889425777, 6.36917889425777, 6.36917889425777, 6.36917889425777, 6.36917889425777, 6.36917889425777, 6.36917889425777, 6.36917889425777, 5.36917889425777, 6.36917889425777, 4.36917889425777, 5.36917889425777, 5.36917889425777, 6.36917889425777, 6.36917889425777, 4.36917889425777, 5.36917889425777, 6.36917889425777, 5.36917889425777, 6.36917889425777, 5.36917889425777, 6.36917889425777, 5.36917889425777, 6.36917889425777, 6.36917889425777, 6.36917889425777, 6.36917889425777, 6.36917889425777, 5.36917889425777, 6.36917889425777, 5.36917889425777, 6.36917889425777, 4.36917889425777, 5.36917889425777, 5.36917889425777), .Dim = 38L, .Dimnames = list(c('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31', '32', '33', '34', '35', '36', '37', '38'))));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators362() {
        assertEval("argv <- list(structure(c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE), .Dim = c(14L, 11L), .Dimnames = list(c('0-18', '18-19', '19-20', '20-21', '21-22', '22-23', '23-24', '24-25', '25-26', '26-27', '27-28', '28-29', '29-30', '30-31'), c('1954', '1955', '1956', '1957', '1958', '1959', '1960', '1961', '1962', '1963', '1964'))));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators363() {
        assertEval("argv <- list(structure(NA, .Tsp = c(1, 1, 1), .S3Class = 'ts', class = structure('ts', package = 'methods')));`(`(argv[[1]]);");
    }

    @Test
    public void testoperators364() {
        assertEval("argv <- list(6, structure(c(-1, 1, -1), .Dim = 3L, .Dimnames = list(c('73', '312', '674'))));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators365() {
        assertEval("argv <- list(-0.0290053253855826, c(95, 175, 250, 350, 500, 675, 1000));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators366() {
        assertEval("argv <- list(c(2L, 1L), c(2L, 2L));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators367() {
        assertEval("argv <- list(c(2.80068140446062, 1.8317224411983, 1.22900361620513, 0.0769946405427206, 2.80068140446062e-07), structure(c(-0.579458297883801, 0.378144472053104, 0.289151395420297, -0.322488635437406, 0.577604873429495, -0.439515769918701, -0.563213485796381, 0.19897761279598, -0.497766353148047, -0.449725499265461, -0.183421202297383, -0.367349618966443, -0.8113056422696, -0.10946638264776, 0.401511127970965, 0.369976492463818, -0.594590295135748, 0.453781444579942, 0.0303676587408212, 0.550218122031705, 0.548204365705284, 0.22652586176497, -0.112538595641497, -0.797072552569732, 0.012977588540091), .Dim = c(5L, 5L)));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators368() {
        assertEval("argv <- list(1.5, 1.5);`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators369() {
        assertEval("argv <- list(structure(c(0.853345363892062, -0.0256071578412401, -0.0612813871821256, -0.0612813871821256, -0.0256071578412401, -0.0612813871821256, -0.0256071578412401, -0.0612813871821256, -0.0256071578412401, 0, 0, 0.0786725879812683, 0.0786725879812683, 0.22692030644121, -0.254660745352065, -0.106413026892124, -0.254660745352065, -0.106413026892124, 0, 0, 0.11837902431235, 0.11837902431235, 0.243512113989909, -0.322431463531475, -0.134731829015137, -0.322431463531475, -0.134731829015137, 0, 0, 0.186882435497702, 0.186882435497702, 0.272137080615963, -0.439352693506895, -0.18358875815211, -0.439352693506895, -0.18358875815211, 0, 0, 0, 0, 0, 0, 0, 0.172822903136154, -0.345645806272308), .Dim = c(9L, 5L)), structure(c(1.03259546878074, -0.967404531219257, 0.032595468780743, 0.032595468780743, -0.967404531219257, 0.032595468780743, -0.967404531219257, 0.032595468780743, -0.967404531219257, 1.15961954033819, -0.840380459661814, 0.159619540338186, 0.159619540338186, -0.840380459661814, 0.159619540338186, -0.840380459661814, 0.159619540338186, -0.840380459661814, 1.16167819481816, -0.838321805181836, 0.161678194818164, 0.161678194818164, -0.838321805181836, 0.161678194818164, -0.838321805181836, 0.161678194818164, -0.838321805181836, 1.1652298823369, -0.834770117663101, 0.165229882336899, 0.165229882336899, -0.834770117663101, 0.165229882336899, -0.834770117663101, 0.165229882336899, -0.834770117663101, 1.17282290313615, -0.827177096863846, 0.172822903136154, 0.172822903136154, -0.827177096863846, 0.172822903136154, -0.827177096863846, 0.172822903136154, -0.827177096863846), .Dim = c(9L, 5L)));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators370() {
        assertEval("argv <- list(0.5, structure(c(-1.12095129310443+0i, 1.4848874974+0.41132282301771i, 2.78279011158859-0.53526713626358i, 1.85742152822765-0.44342995809143i, -0.9385359708259+2.37692350427328i, 1.4848874974-0.41132282301771i, 0.921832411978405+0i, -0.90524740754917+0.341208007507433i, -0.18900237366429+1.08605076555264i, -0.66363688475825+1.22446591693656i, 2.78279011158859+0.53526713626358i, -0.90524740754917-0.341208007507433i, 0.801542901188104+0i, -1.85593444068452+0.95943368782835i, -1.58184558306131+0.08618435261084i, 1.85742152822765+0.44342995809143i, -0.18900237366429-1.08605076555264i, -1.85593444068452-0.95943368782835i, 1.40271180312737+0i, -1.20168263701907+0.42799687996867i, -0.9385359708259-2.37692350427328i, -0.66363688475825-1.22446591693656i, -1.58184558306131-0.08618435261084i, -1.20168263701907-0.42799687996867i, -1.25007853569851+0i), .Dim = c(5L, 5L)));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators371() {
        assertEval("argv <- list(TRUE, TRUE);`!=`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators372() {
        assertEval("argv <- list(structure(1.6768574855882, .Names = 'x'), c(1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, NA));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators373() {
        assertEval("argv <- list(structure(c(2134, 1863, 1877, 1877, 1492, 1249, 1280, 1131, 1209, 1492, 1621, 1846, 2103, 2137, 2153, 1833, 1403, 1288, 1186, 1133, 1053, 1347, 1545, 2066, 2020, 2750, 2283, 1479, 1189, 1160, 1113, 970, 999, 1208, 1467, 2059, 2240, 1634, 1722, 1801, 1246, 1162, 1087, 1013, 959, 1179, 1229, 1655, 2019, 2284, 1942, 1423, 1340, 1187, 1098, 1004, 970, 1140, 1110, 1812, 2263, 1820, 1846, 1531, 1215, 1075, 1056, 975), .Tsp = c(1974, 1979.58333333333, 12), class = 'ts'), c(-33.5, -32.5, -31.5, -30.5, -29.5, -28.5, -27.5, -26.5, -25.5, -24.5, -23.5, -22.5, -21.5, -20.5, -19.5, -18.5, -17.5, -16.5, -15.5, -14.5, -13.5, -12.5, -11.5, -10.5, -9.5, -8.5, -7.5, -6.5, -5.5, -4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5, 4.5, 5.5, 6.5, 7.5, 8.5, 9.5, 10.5, 11.5, 12.5, 13.5, 14.5, 15.5, 16.5, 17.5, 18.5, 19.5, 20.5, 21.5, 22.5, 23.5, 24.5, 25.5, 26.5, 27.5, 28.5, 29.5, 30.5, 31.5, 32.5, 33.5));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators374() {
        assertEval("argv <- list(c(0.0125360439090882, 0.109084258765985, 0.283058130441221, 0.5, 0.716941869558779, 0.890915741234015, 0.987463956090912, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.987463956090912, 0.890915741234015, 0.716941869558779, 0.5, 0.283058130441221, 0.109084258765985, 0.0125360439090882), structure(c(430.689117199391, 165.5304253221, 185.371733444809, 191.213041567518, -187.945650309773, -425.104342187064, -388.263034064356, -531.421725941647, -447.580417818938, -158.739109696229, -23.8978015735202, 206.943506549189, 469.784814671898, 509.626122794606, 531.467430917315, 217.308739040024, -206.849952837267, -316.008644714558, -412.167336591849, -459.32602846914, -533.484720346432, -233.643412223723, -29.8021041010139, 497.039204021695, 456.880512144404, 1192.72182026711, 731.563128389821, -66.5955634874696, -350.754255364761, -373.912947242052, -415.071639119343, -552.230330996634, -517.389022873925, -302.547714751216, -37.7064066285076, 560.134901494201, 746.97620961691, 146.817517739619, 240.658825862328, 325.500133985037, -223.658557892254, -301.817249769546, -370.975941646837, -439.134633524128, -487.293325401419, -261.45201727871, -205.610709156001, 226.230598966708, 596.071907089416, 866.913215212125, 530.754523334834, 17.5958314575429, -59.5628604197482, -206.721552297039, -289.880244174331, -378.038936051622, -406.197627928913, -230.356319806204, -254.515011683495, 453.326296439214, 910.167604561923, 473.008912684631, 504.85022080734, 195.691528930049, -114.467162947242, -248.625854824533, -261.784546701824, -336.943238579115, -366.101930456407, -219.260622333698, -0.419314210988802, 52.4219939117201), .Tsp = c(1974, 1979.91666666667, 12), class = 'ts'));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators375() {
        assertEval("argv <- list(structure(c(12L, 23L), .Dim = 2L, .Dimnames = structure(list(c('1', '2')), .Names = ''), class = 'table'), 1:2);`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators376() {
        assertEval("argv <- list(3, structure(2.39313505864491, .Names = 'x'));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators377() {
        assertEval("argv <- list(30, 1:100);`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators378() {
        assertEval("argv <- list(1, structure(c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE), .Dim = c(14L, 11L), .Dimnames = list(c('0-18', '18-19', '19-20', '20-21', '21-22', '22-23', '23-24', '24-25', '25-26', '26-27', '27-28', '28-29', '29-30', '30-31'), c('1954', '1955', '1956', '1957', '1958', '1959', '1960', '1961', '1962', '1963', '1964'))));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators379() {
        assertEval("argv <- list(structure(c(125.462606837607, 127.867786930034, 130.144676735994, 132.324464274255, 134.336734211717, 136.082072800639, 137.721118421779, 140.845055930758, 143.28591535884, 145.768223343737, 146.185327931547, 145.802002908545, 149.002460060179, 153.598715100046, 155.183805036251, 159.724429366298, 161.673726141005, 170.116738471067, 169.947660568386, 170.006973600711, 170.719702563484, 171.765986080317, 174.613600436266, 179.048948110372, 179.883872548102, 181.827282092545, 184.331859119525, 182.743207226061, 183.03021399043, 184.153788490888, 191.745076839764, 194.148810101473, 199.10701170422, 199.286358868728, 202.588173234443, 206.570808710438, 208.901416980527, 210.197793333945, 208.990030330146, 213.988947898492, 221.910492791482, 225.858547195805, 224.629928649936, 225.693827143939, 226.925133971988, 227.909074259919, 228.294198948883, 226.413286455683, 224.858486784216, 224.205996780539, 218.296565215286, 217.952397420454, 218.203297324152, 222.634503912979, 229.136665168488, 238.199012563706, 241.084558136518, 244.474599589944, 246.541678441215, 249.943070595034, 252.738029658228, 257.655553126827, 261.948737901648, 259.38828865138, 260.581624400595, 261.35845107056, 266.721536928548, 274.727021103557, 279.519739428079, 285.613419212625, 290.081183406543, 292.578703689536, 298.536510073918, 301.854944861174, 306.72012690062, 308.552564035999, 308.960906756251, 310.45531361152, 314.471901471993, 316.180279500694, 321.131980519447, 324.487238338646, 326.432439140534, 330.587069598829, 332.257828918305, 334.897103376149, 336.500107838622, 341.040184577164, 343.37680996925, 346.04109648055, 350.540519967376, 353.909804788829, 360.713606630499, 365.246028758837, 368.653301499587, 371.870254918956, 371.890026901483, 370.974100279234, 368.423988230309, 364.248564265975, 359.879991232458, 359.533794053725, 361.493423852232, 366.272105696357, 374.712558672268, 373.691234302716, 377.311059795731, 378.958918379956, 378.434557854932, 383.493556594665, 388.051875855736, 394.72909801417, 399.975945122541, 406.14684914494, 404.223720368284, 407.657133649615, 412.1384117511, 418.253339402259, 423.102585806067, 430.610654889479, 439.381586214864, 443.452574204404, 446.154893648303, 437.948767898975, 448.065211483223, 452.98477480065, 456.22724907891, 460.426882491713, 459.053158913271, 461.490725714314, 468.825080012951, 470.090114620358), .Tsp = c(1950, 1960.91666666667, 12), class = 'ts'), structure(c(0.885377815022177, 0.956702662008391, 1.05604790005129, 0.99999180855271, 0.919180306022048, 1.08513403180744, 1.17950860096112, 1.17526020717901, 1.07399050289666, 0.935173924204861, 0.814655016855593, 0.918977224438701, 0.904886860495219, 0.974651014130265, 1.07318431817519, 1.01267995772422, 0.926294652616773, 1.09129604332202, 1.2136804527299, 1.19513265851781, 1.09196097114148, 0.920716625833028, 0.792428126174694, 0.944665370656132, 0.947060673767712, 0.975861204272186, 1.11889468518085, 1.01760687119493, 1.00966041750694, 1.06261400924208, 1.18646278417314, 1.17953219321689, 1.08299041001682, 0.934768432861068, 0.819582111385122, 0.933541960135008, 0.949299218066574, 0.984712956742138, 1.07274478711742, 1.00035738265237, 1.00344619530389, 1.136720297344, 1.19466716852011, 1.22110179994975, 1.06180417436075, 0.949583554116272, 0.837964127353819, 0.93707048913996, 0.942302022727904, 0.95126138690835, 1.10787035072032, 1.06044554393152, 1.0212841877174, 1.09777947829535, 1.18237485006198, 1.21101795468964, 1.05077474260124, 0.934482494680629, 0.806219558496273, 0.905507672627939, 0.919955309911582, 0.877743501942818, 1.0879384725907, 1.04844380534261, 1.05308404040641, 1.15209925173403, 1.2652951992685, 1.2229795664526, 1.06552999327079, 0.93588195611389, 0.816986956383517, 0.912235531149947, 0.943381852486145, 0.894360852742568, 1.04386693859046, 1.0412387923364, 1.04235110100738, 1.18519852082375, 1.32667886524828, 1.24804193460951, 1.09707745322343, 0.950576085705186, 0.817003170713368, 0.935893112057161, 0.94836946371363, 0.908951898620782, 1.03731973240637, 1.02419763657726, 1.03406277428866, 1.19743269363204, 1.31822462831668, 1.26862748613699, 1.10235655952769, 0.945803515760855, 0.82528228386107, 0.929397385899463, 0.948173569563647, 0.902518233330453, 1.05026106742455, 1.02180458893893, 1.03392834532348, 1.21128679495018, 1.32344975581348, 1.30039314766586, 1.11343783106856, 0.948475302349546, 0.826576551185179, 0.912962090088511, 0.926561968385747, 0.87353380715788, 1.00678775995668, 0.979149663293728, 1.01788806209298, 1.21041189004384, 1.34524520684843, 1.34901427843594, 1.0909897186673, 0.956150231433401, 0.823434379283845, 0.897915761073492, 0.942043948926554, 0.884990150921632, 1.03141421940795, 0.994229969777015, 1.03800763998638, 1.17962620510919, 1.3518161330406, 1.3629765592452, 1.11127249087291, 0.966786065425125, 0.843497574054032, 0.924445014403716), .Tsp = c(1950, 1960.91666666667, 12), class = 'ts'));`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators380() {
        assertEval("argv <- list(-3:3, 0+1i);`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testoperators381() {
        assertEval("argv <- list(181L, 3.14159265358979);`*`(argv[[1]],argv[[2]]);");
    }

    @Test
    public void testDispatchToOpsSpecializations() {
        assertEval(Output.IgnoreErrorContext, "factor(c(\"a\",\"b\",\"c\")) == factor(c(1,2,3))");
        assertEval("data.frame(factor(c(1,2,3))) == data.frame(factor(c(1,2,3)))");
        assertEval("data.frame(factor(c(1,2,1))) == data.frame(factor(c(1,2,2)))");
    }

    @Test
    public void testNames() {
        assertEval("data <- c(1,2,3,4); names(data) <- c('a','b','c','d'); " +
                        "data[c('a','b')] + data[c('c','d')]; data[c('a','b')] + data[c('c')]; data[c('a')] + data[c('c','d')]; data[c('a')] + data[c('c')]; " +
                        "data[c('a')] + 1; 1 + data[c('a')]; data[c('a')] + c(1,2); c(1,2) + data[c('a')]; " +
                        "data[c('a','b')] + 1; 1 + data[c('a','b')]; data[c('a','b')] + c(1,2); c(1,2) + data[c('a','b')]");
    }

    @Test
    public void testBooleanOperators() {
        // tests that deparse in as.symbol removes backticks
        assertEval("as.symbol('*') == '*'");
        assertEval("as.symbol('<-') == '<-'");
    }

    @Test
    public void testOperators() {
        assertEval("{ `+`(1,2) }");
        assertEval("{ `-`(1,2) }");
        assertEval("{ `*`(1,2) }");
        assertEval("{ `/`(1,2) }");
        assertEval("{ `%/%`(1,2) }");
        assertEval("{ `%%`(1,2) }");
        assertEval("{ `^`(1,2) }");
        assertEval("{ `!`(TRUE) }");
        assertEval("{ `%o%`(3,5) }");
        assertEval("{ x <- `+` ; x(2,3) }");
        assertEval("{ x <- `+` ; f <- function() { x <- 1 ; x(2,3) } ; f() }");
        assertEval("{ `||`(TRUE, FALSE) }");
        assertEval("{ `&&`(TRUE, FALSE) }");
        assertEval("{ `|`(TRUE, FALSE) }");
        assertEval("{ `&`(TRUE, FALSE) }");
        assertEval("{ `%*%`(3,5) }");

        assertEval("as.symbol('asdf') == as.symbol('fdsa')");
        assertEval("as.symbol('asdf') + as.symbol('fdsa')");
    }

    @Test
    public void testMatMult() {
        assertEval("{ matrix(c(1,2,3,4), 2) %*% matrix(c(5,6,7,8), 2) }");
        assertEval("{ matrix(c(3,1,2,0,1,2), 2) %*% matrix(c(1,0,4,2,1,0), 3) }");
        assertEval("{ c(1,2,3) %*% c(4,5,6) }");
        assertEval("{ matrix(c(3,1,2,0,1,2),2) %*% c(1,0,4) }");
        assertEval("{ c(1,0,4) %*% matrix(c(3,1,2,0,1,2),3) }");
        assertEval("{ as.vector(c(1,2,3)) %*% t(as.vector(c(1,2))) }");

        assertEval("{ matrix(c(1+1i,2-2i,3+3i,4-4i), 2) %*% matrix(c(5+5i,6-6i,7+7i,8-8i), 2) }");
        assertEval("{ matrix(c(3+3i,1-1i,2+2i,0-0i,1+1i,2-2i), 2) %*% matrix(c(1+1i,0-0i,4+4i,2-2i,1+1i,0-0i), 3) }");
        assertEval("{ c(1+1i,2-2i,3+3i) %*% c(4-4i,5+5i,6-6i) }");
        assertEval("{ matrix(c(1+1i,0-0i,4+4i),3) %*% matrix(c(3+3i,1-1i,2+2i,0-0i,1+1i,2-2i),1) }");

        assertEval("{ matrix(c(3+3i,1-1i,2+2i,0-0i,1+1i,2-2i),2) %*% c(1+1i,0-0i,4+4i) }");
        assertEval("{ c(1+1i,0-0i,4+4i) %*% matrix(c(3+3i,1-1i,2+2i,0-0i,1+1i,2-2i),3) }");
    }

    @Test
    public void testIn() {
        assertEval("{ 2 %in% c(1,2,3) }");
        assertEval("{ c(1,2,3,4,5) %in% c(1,2,1,2) }");
        assertEval("{ \"hello\" %in% c(\"I\", \"say\", \"hello\", \"world\") }");
        assertEval("{ c(\"hello\", \"say\") %in% c(\"I\", \"say\", \"hello\", \"world\") }");
        assertEval("{ `%in%`(2,c(1,2,3)) }");
    }

    @Test
    public void testColon() {
        assertEval("NULL:5");
        assertEval("8.2:NULL");
        assertEval("8.2:c(9,8)");
        assertEval("new.env():new.env()");
        assertEval("numeric(0):numeric(0)");

        assertEval("1:'1'");
        assertEval("1:'1.1'");
        assertEval("2147483647L:'2147483648'");
    }

    private static final String[] INT_MAX_VALUES = new String[]{"2147483647L", "2147483648"};
    private static final String[] INT_MAX_VALUES_VEC = new String[]{"c(2147483647L, 2147483647L)", "c(2147483648, 2147483648)"};
    // note that java's Integer.MIN_VALUE -2147483648 isn't an integer in GNUR
    private static final String[] INT_MIN_VALUES = new String[]{"-2147483647L", "-2147483648", "-2147483649"};
    private static final String[] INT_MIN_VALUES_VEC = new String[]{"c(-2147483647L, -2147483647L)", "c(-2147483648, -2147483648)", "c(-2147483649, -2147483649)"};

    // borderline cases between integer and double
    @Test
    public void testColonIntAndDouble() {
        assertColon(INT_MAX_VALUES);
        assertColon(INT_MAX_VALUES_VEC);
        assertColon(INT_MIN_VALUES);
        assertColon(INT_MIN_VALUES_VEC);
    }

    private void assertColon(String[] parameters) {
        assertEval(template("%0:%1", parameters, parameters));
        assertEval(template("typeof(%0:%1)", parameters, parameters));
    }

    @Test
    public void testEqualsList() {
        assertEval("{ l <- list(an=1, bn=2, 3, 4);  l == 1 }");
        assertEval("{ l <- list(an=1, bn=2, 3, 4);  1 == l }");
        assertEval("{ l <- list(an=1L, bn=2L, 3, 4);  l == 1 }");
        assertEval("{ l <- list(an=1L, bn=2L, 3, 4);  1 == l }");
        assertEval("{ l <- list(an='a', bn='b', 3, 4);  l == 'a' }");
        assertEval("{ l <- list(an='a', bn='b', 3, 4);  'a' == l }");
        assertEval("{ l <- list(an=T, bn=F, T, F);  l == T }");
        assertEval("{ l <- list(an=T, bn=F, T, F);  T == l }");
    }

    @Test
    public void testListWithNull() {
        assertEval("{ list(NULL) < 1 }");
        assertEval("{ list(1, NULL) < c(1, 1) }");
        assertEval("{ c(1, 1) < list(1, NULL) }");
    }

    @Test
    public void testPrecedence() {
        assertEval("{ 3 %% 2 %in% 1}");
    }

    @Test
    public void testCopyAttribOnBinaryBoolean() {
        String[] lhs = {"lhs <- array(FALSE,dim=c(2,3),dimnames=list(c('ly1','ly2'),c('lx1','lx2','lx3')))",
                        "lhs <- array(FALSE,dim=c(2,3))",
                        "lhs <- c(FALSE, FALSE)"};
        String[] rhs = {"rhs <- array(FALSE,dim=c(2,3),dimnames=list(c('ry1','ry2'),c('rx1','rx2','rx3')))",
                        "rhs <- array(FALSE,dim=c(2,3))",
                        "rhs <- c(FALSE, FALSE)",
        };
        assertEval(template("{ %0; %1; lhs == rhs }", lhs, rhs));
        assertEval(template("{ %0; %1; as.logical(lhs) == rhs }", lhs, rhs));
        assertEval(template("{ %0; %1; lhs == as.logical(rhs) }", lhs, rhs));

        assertEval(template("{ %0; %1; temp <- as.logical(lhs); temp == rhs }", lhs, rhs));
        assertEval(template("{ %0; %1; temp <- as.logical(rhs); lhs == temp }", lhs, rhs));
    }

}
