# Sulong

Sulong is a high-performance LLVM bitcode runtime built on the
[GraalVM](https://www.graalvm.org) by [Oracle Labs](https://labs.oracle.com).

Sulong is written in Java and uses the Truffle language implementation
framework and Graal as a dynamic compiler.

With Sulong you can execute programming languages that can be transformed
to LLVM bitcode on GraalVM. This includes languages like C/C++, Fortran, and others.


## User Documentation

Sulong is part of [GraalVM](https://www.graalvm.org). If you are a user of GraalVM and want
to run C/C++/... programs on GraalVM, we recommend downloading a pre-built binary of
[GraalVM](https://www.graalvm.org/downloads).

See [GraalVM LLVM Runtime](../docs/reference-manual/llvm/README.md) and [graalvm.org](https://www.graalvm.org/reference-manual/llvm/) for documentation about using the GraalVM LLVM runtime.

## Contributor Documentation

If you are interested in the internals of Sulong, or want to contribute, there are those
resources:

* [Building Sulong from Source](docs/contributor/BUILDING.md)
* [The GraalVM LLVM Toolchain](docs/contributor/TOOLCHAIN.md)
* [Cross-Language Interoperability](docs/contributor/INTEROP.md)
* [Debugging the GraalVM LLVM Runtime](docs/contributor/DEBUGGING.md)
* [Publications](docs/contributor/PUBLICATIONS.md)
* [Sulong test cases](docs/contributor/TESTS.md)
* [FAQ](docs/contributor/FAQ.md)


## Further Information

Sulong is developed in a research collaboration with
[Johannes Kepler University, Linz](http://www.ssw.jku.at).
