/*
 * Copyright (c) 2017, 2020, Oracle and/or its affiliates.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of
 * conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other materials provided
 * with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>

int main() {
    FILE *writeableFile = fopen("sulong_test_file", "w");
    if (writeableFile == NULL) {
        printf("error opening file!\n");
        exit(1);
    }
    const char *text = "hello world!";
    fprintf(writeableFile, "write this to the writeableFile: %s\n", text);
    fclose(writeableFile);

    writeableFile = fopen("sulong_test_file", "r+");
    if (writeableFile == NULL) {
        printf("error opening file!\n");
        exit(1);
    }
    fputs("asdfasdfasdf", writeableFile);
    fclose(writeableFile);

    FILE *readableFile = fopen("sulong_test_file", "r+");
    if (readableFile == NULL) {
        printf("error opening file!\n");
        exit(2);
    }
    char buff[1000];
    if (fgets(buff, 1000, readableFile) == NULL) {
        printf("error!");
    }
    puts(buff);
    if (remove("sulong_test_file")) {
        printf("error removing file!\n");
        exit(3);
    }
}
