;;
;; Copyright (c) 2019, 2020, Oracle and/or its affiliates. All rights reserved.
;; DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
;;
;; The Universal Permissive License (UPL), Version 1.0
;;
;; Subject to the condition set forth below, permission is hereby granted to any
;; person obtaining a copy of this software, associated documentation and/or
;; data (collectively the "Software"), free of charge and under any and all
;; copyright rights in the Software, and any and all patent rights owned or
;; freely licensable by each licensor hereunder covering either (i) the
;; unmodified Software as contributed to or provided by such licensor, or (ii)
;; the Larger Works (as defined below), to deal in both
;;
;; (a) the Software, and
;;
;; (b) any piece of software and/or hardware listed in the lrgrwrks.txt file if
;; one is included with the Software each a "Larger Work" to which the Software
;; is contributed by such licensors),
;;
;; without restriction, including without limitation the rights to copy, create
;; derivative works of, display, perform, and distribute the Software and make,
;; use, sell, offer for sale, import, export, have made, and have sold the
;; Software and the Larger Work(s), and to sublicense the foregoing rights on
;; either these or other terms.
;;
;; This license is subject to the following condition:
;;
;; The above copyright notice and either this complete permission notice or at a
;; minimum a reference to the UPL must be included in all copies or substantial
;; portions of the Software.
;;
;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
;; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
;; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
;; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
;; SOFTWARE.
;;

;; This WebAssembly module was generated by emcc (emscripten) from the following C source:
;;
;; #include <stdio.h>
;;
;; #define MAXM 6
;; #define MAXNUM 10000
;;
;; int superperfect() {
;;     int number, first, m, tmpnum, sumdiv, div, k;
;;     int distmkperf = 0, mkperf = 0, perf = 0, mperf = 0, supperf = 0;
;;     for (number = 2 ; number <= MAXNUM ; number++) {
;;         first = 1;
;;         tmpnum = number;
;;         for (m = 1 ; m <= MAXM ; m++) {
;;             sumdiv = tmpnum + 1;
;;             for (div = 2 ; div * div < tmpnum ; div++)
;;                 if (tmpnum % div == 0)
;;                     sumdiv += div + tmpnum / div;
;;             if (div * div == tmpnum)
;;                 sumdiv += div;
;;             tmpnum = sumdiv;
;;             if (tmpnum % number == 0) {
;;                 k = tmpnum / number;
;;                 if (first) {
;;                     distmkperf++;
;;                     first = 0;
;;                 }
;;                 mkperf++;
;;                 if (m == 1) {
;;                     mperf++;
;;                     if (k == 2) {
;;                         perf++;
;;                     }
;;                 }
;;                 if (m == 2 && k == 2) {
;;                     supperf++;
;;                 }
;;             }
;;         }
;;     }
;;     return distmkperf;
;; }
;;
;; int main() {
;;     int n = superperfect();
;;     printf("count = %d\n", n);
;;     return n;
;; }
;;
;; In the following way:
;;
;; $ emcc -Os superperfect.c -o superperfect.wasm
;; $ wasm2wat superperfect.wasm > superperfect.wat
;;
(module
  (type (;0;) (func (result i32)))
  (type (;1;) (func (param i32) (result i32)))
  (func (;0;) (type 0) (result i32)
    call 1)
  (func (;1;) (type 0) (result i32)
    (local i32 i32 i32 i32 i32 i32 i32 i32)
    i32.const 2
    local.set 3
    loop  ;; label = @1
      local.get 3
      local.set 2
      i32.const 1
      local.set 7
      i32.const 1
      local.set 6
      local.get 0
      local.set 4
      loop  ;; label = @2
        local.get 2
        i32.const 1
        i32.add
        local.set 0
        local.get 2
        i32.const 4
        i32.gt_s
        if  ;; label = @3
          i32.const 2
          local.set 1
          loop  ;; label = @4
            local.get 0
            local.get 2
            local.get 1
            i32.div_s
            local.tee 5
            local.get 0
            local.get 1
            i32.add
            i32.add
            local.get 2
            local.get 1
            local.get 5
            i32.mul
            i32.sub
            select
            local.set 0
            local.get 1
            i32.const 1
            i32.add
            local.tee 1
            local.get 1
            i32.mul
            local.tee 5
            local.get 2
            i32.lt_s
            br_if 0 (;@4;)
          end
        else
          i32.const 2
          local.set 1
          i32.const 4
          local.set 5
        end
        i32.const 0
        local.get 6
        local.get 0
        local.get 1
        i32.const 0
        local.get 2
        local.get 5
        i32.eq
        select
        i32.add
        local.tee 2
        local.get 3
        i32.rem_s
        i32.eqz
        local.tee 0
        select
        local.set 1
        local.get 4
        local.get 6
        i32.const 0
        i32.ne
        local.get 0
        i32.and
        i32.add
        local.set 0
        local.get 7
        i32.const 1
        i32.add
        local.tee 4
        i32.const 7
        i32.ne
        if  ;; label = @3
          local.get 4
          local.set 7
          local.get 1
          local.set 6
          local.get 0
          local.set 4
          br 1 (;@2;)
        end
      end
      local.get 3
      i32.const 1
      i32.add
      local.tee 3
      i32.const 10001
      i32.ne
      br_if 0 (;@1;)
    end
    local.get 0)
  (func (;2;) (type 1) (param i32) (result i32)
    (local i32 i32)
    global.get 0
    local.set 2
    local.get 0
    global.get 0
    i32.add
    global.set 0
    global.get 0
    i32.const 15
    i32.add
    i32.const -16
    i32.and
    global.set 0
    local.get 2)
  (memory (;0;) 4)
  (global (;0;) (mut i32) (i32.const 2768))
  (export "memory" (memory 0))
  (export "_main" (func 0))
  (export "stackAlloc" (func 2)))
