/*
 * Copyright (c) 2022, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The Universal Permissive License (UPL), Version 1.0
 *
 * Subject to the condition set forth below, permission is hereby granted to any
 * person obtaining a copy of this software, associated documentation and/or
 * data (collectively the "Software"), free of charge and under any and all
 * copyright rights in the Software, and any and all patent rights owned or
 * freely licensable by each licensor hereunder covering either (i) the
 * unmodified Software as contributed to or provided by such licensor, or (ii)
 * the Larger Works (as defined below), to deal in both
 *
 * (a) the Software, and
 *
 * (b) any piece of software and/or hardware listed in the lrgrwrks.txt file if
 * one is included with the Software each a "Larger Work" to which the Software
 * is contributed by such licensors),
 *
 * without restriction, including without limitation the rights to copy, create
 * derivative works of, display, perform, and distribute the Software and make,
 * use, sell, offer for sale, import, export, have made, and have sold the
 * Software and the Larger Work(s), and to sublicense the foregoing rights on
 * either these or other terms.
 *
 * This license is subject to the following condition:
 *
 * The above copyright notice and either this complete permission notice or at a
 * minimum a reference to the UPL must be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.graalvm.wasm.predefined.go;

import static org.graalvm.wasm.WasmType.I32_TYPE;

import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.predefined.BuiltinModule;

public class GoModule extends BuiltinModule {

    @Override
    protected WasmModule createModule(WasmLanguage language, WasmContext context, String name) {
        WasmModule module = WasmModule.createBuiltin(name);
        defineFunction(context, module, "debug", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "runtime.wasmExit", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "runtime.wasmWrite", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "runtime.nanotime", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "runtime.walltime", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "runtime.scheduleTimeoutEvent", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "runtime.clearTimeoutEvent", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "runtime.getRandomData", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "syscall/js.stringVal", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "syscall/js.valueGet", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "syscall/js.valueSet", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "syscall/js.valueIndex", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "syscall/js.valueSetIndex", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "syscall/js.valueCall", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "syscall/js.valueNew", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "syscall/js.valueLength", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "syscall/js.valuePrepareString", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "syscall/js.valueLoadString", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        defineFunction(context, module, "syscall/js.copyBytesToJS", types(I32_TYPE), types(), new GoFunctionNode(language, module));
        return module;
    }
}
