# Reporting security vulnerabilities

Oracle values the independent security research community and believes that responsible disclosure of security vulnerabilities helps us ensure the security and privacy of all our users.

Please do NOT raise a GitHub Issue to report a security vulnerability.
If you believe you have found a security vulnerability, please submit a report to [secalert_us@oracle.com][1] preferably with a proof of concept.
Please review some additional information on [how to report security vulnerabilities to Oracle][2].
We encourage people who contact Oracle Security to use email encryption using [our encryption key][3].

We ask that you do not use other channels or contact the project maintainers directly.

Non-vulnerability related security issues including ideas for new or improved security features are welcome on GitHub Issues.

## Security updates, alerts and bulletins

Security updates will be released on a regular cadence.
Many of our projects will typically release security fixes in conjunction with the Oracle Critical Patch Update program.
Additional information, including past advisories, is available on our [security alerts][4] page.

## Security-related information

Please refer to the [GraalVM Security Guide](https://www.graalvm.org/latest/security-guide/) for security related topics such as how to support trusted and less trusted code execution using the Truffle language framework, or compiler mitigations for transitive execution attacks.
However please note that we do not currently support the execution of untrusted or adversarial code.
Non-vulnerability related security issues may be discussed on GitHub Issues or the Security channel in the [GraalVM Slack Workspace](https://graalvm.slack.com/)

[1]: mailto:secalert_us@oracle.com
[2]: https://www.oracle.com/corporate/security-practices/assurance/vulnerability/reporting.html
[3]: https://www.oracle.com/security-alerts/encryptionkey.html
[4]: https://www.oracle.com/security-alerts/
